// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * The dimension of an Amazon CloudWatch metric that is used when DevOps Guru analyzes the resources in your account for operational problems and anomalous behavior. A dimension is a name/value pair that is part of the identity of a metric. A metric can have up to 10 dimensions. For more information, see [Dimensions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension) in the *Amazon CloudWatch User Guide*.
 */
public class CloudWatchMetricsDimension private constructor(builder: Builder) {
    /**
     * The name of the CloudWatch dimension.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The value of the CloudWatch dimension.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.CloudWatchMetricsDimension = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchMetricsDimension(")
        append("name=$name,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchMetricsDimension

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.CloudWatchMetricsDimension = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the CloudWatch dimension.
         */
        public var name: kotlin.String? = null
        /**
         * The value of the CloudWatch dimension.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.CloudWatchMetricsDimension) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.CloudWatchMetricsDimension = CloudWatchMetricsDimension(this)
    }
}
