// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * A logical grouping of Performance Insights metrics for a related subject area. For example, the `db.sql` dimension group consists of the following dimensions: `db.sql.id`, `db.sql.db_id`, `db.sql.statement`, and `db.sql.tokenized_id`.
 *
 * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.
 *
 * Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host.
 * + To learn more about Performance Insights and Amazon Aurora DB instances, go to the [ Amazon Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
 * + To learn more about Performance Insights and Amazon RDS DB instances, go to the [ Amazon RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
 */
public class PerformanceInsightsMetricDimensionGroup private constructor(builder: Builder) {
    /**
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested or are present in the response.
     *
     * Valid values for elements in the `Dimensions` array are:
     * + `db.application.name` - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)
     * + `db.host.id` - The host ID of the connected client (all engines)
     * + `db.host.name` - The host name of the connected client (all engines)
     * + `db.name` - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * + `db.session_type.name` - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * + `db.sql.id` - The SQL ID generated by Performance Insights (all engines)
     * + `db.sql.db_id` - The SQL ID generated by the database (all engines)
     * + `db.sql.statement` - The SQL text that is being executed (all engines)
     * + `db.sql.tokenized_id`
     * + `db.sql_tokenized.id` - The SQL digest ID generated by Performance Insights (all engines)
     * + `db.sql_tokenized.db_id` - SQL digest ID generated by the database (all engines)
     * + `db.sql_tokenized.statement` - The SQL digest text (all engines)
     * + `db.user.id` - The ID of the user logged in to the database (all engines)
     * + `db.user.name` - The name of the user logged in to the database (all engines)
     * + `db.wait_event.name` - The event for which the backend is waiting (all engines)
     * + `db.wait_event.type` - The type of event for which the backend is waiting (all engines)
     * + `db.wait_event_type.name` - The name of the event type for which the backend is waiting (all engines)
     */
    public val dimensions: List<String>? = builder.dimensions
    /**
     * The name of the dimension group. Its valid values are:
     * + `db` - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * + `db.application` - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)
     * + `db.host` - The host name of the connected client (all engines)
     * + `db.session_type` - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * + `db.sql` - The SQL that is currently executing (all engines)
     * + `db.sql_tokenized` - The SQL digest (all engines)
     * + `db.wait_event` - The event for which the database backend is waiting (all engines)
     * + `db.wait_event_type` - The type of event for which the database backend is waiting (all engines)
     * + `db.user` - The user logged in to the database (all engines)
     */
    public val group: kotlin.String? = builder.group
    /**
     * The maximum number of items to fetch for this dimension group.
     */
    public val limit: kotlin.Int? = builder.limit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PerformanceInsightsMetricDimensionGroup(")
        append("dimensions=$dimensions,")
        append("group=$group,")
        append("limit=$limit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PerformanceInsightsMetricDimensionGroup

        if (dimensions != other.dimensions) return false
        if (group != other.group) return false
        if (limit != other.limit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested or are present in the response.
         *
         * Valid values for elements in the `Dimensions` array are:
         * + `db.application.name` - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)
         * + `db.host.id` - The host ID of the connected client (all engines)
         * + `db.host.name` - The host name of the connected client (all engines)
         * + `db.name` - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
         * + `db.session_type.name` - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
         * + `db.sql.id` - The SQL ID generated by Performance Insights (all engines)
         * + `db.sql.db_id` - The SQL ID generated by the database (all engines)
         * + `db.sql.statement` - The SQL text that is being executed (all engines)
         * + `db.sql.tokenized_id`
         * + `db.sql_tokenized.id` - The SQL digest ID generated by Performance Insights (all engines)
         * + `db.sql_tokenized.db_id` - SQL digest ID generated by the database (all engines)
         * + `db.sql_tokenized.statement` - The SQL digest text (all engines)
         * + `db.user.id` - The ID of the user logged in to the database (all engines)
         * + `db.user.name` - The name of the user logged in to the database (all engines)
         * + `db.wait_event.name` - The event for which the backend is waiting (all engines)
         * + `db.wait_event.type` - The type of event for which the backend is waiting (all engines)
         * + `db.wait_event_type.name` - The name of the event type for which the backend is waiting (all engines)
         */
        public var dimensions: List<String>? = null
        /**
         * The name of the dimension group. Its valid values are:
         * + `db` - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
         * + `db.application` - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)
         * + `db.host` - The host name of the connected client (all engines)
         * + `db.session_type` - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
         * + `db.sql` - The SQL that is currently executing (all engines)
         * + `db.sql_tokenized` - The SQL digest (all engines)
         * + `db.wait_event` - The event for which the database backend is waiting (all engines)
         * + `db.wait_event_type` - The type of event for which the database backend is waiting (all engines)
         * + `db.user` - The user logged in to the database (all engines)
         */
        public var group: kotlin.String? = null
        /**
         * The maximum number of items to fetch for this dimension group.
         */
        public var limit: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup) : this() {
            this.dimensions = x.dimensions
            this.group = x.group
            this.limit = x.limit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup = PerformanceInsightsMetricDimensionGroup(this)
    }
}
