// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Contains information used to update a collection of Amazon Web Services resources.
 */
public class UpdateResourceCollectionFilter private constructor(builder: Builder) {
    /**
     * A collection of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public val cloudFormation: aws.sdk.kotlin.services.devopsguru.model.UpdateCloudFormationCollectionFilter? = builder.cloudFormation
    /**
     * The updated Amazon Web Services tags used to filter the resources in the resource collection.
     *
     * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the [Tagging best practices](https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf) whitepaper.
     *
     * Each Amazon Web Services tag has two parts.
     * + A tag *key* (for example, `CostCenter`, `Environment`, `Project`, or `Secret`). Tag *keys* are case-sensitive.
     * + An optional field known as a tag *value* (for example, `111122223333`, `Production`, or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive.
     *
     * Together these are known as *key*-*value* pairs.
     *
     * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
     */
    public val tags: List<UpdateTagCollectionFilter>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.UpdateResourceCollectionFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateResourceCollectionFilter(")
        append("cloudFormation=$cloudFormation,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudFormation?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateResourceCollectionFilter

        if (cloudFormation != other.cloudFormation) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.UpdateResourceCollectionFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A collection of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        public var cloudFormation: aws.sdk.kotlin.services.devopsguru.model.UpdateCloudFormationCollectionFilter? = null
        /**
         * The updated Amazon Web Services tags used to filter the resources in the resource collection.
         *
         * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the [Tagging best practices](https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf) whitepaper.
         *
         * Each Amazon Web Services tag has two parts.
         * + A tag *key* (for example, `CostCenter`, `Environment`, `Project`, or `Secret`). Tag *keys* are case-sensitive.
         * + An optional field known as a tag *value* (for example, `111122223333`, `Production`, or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive.
         *
         * Together these are known as *key*-*value* pairs.
         *
         * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
         */
        public var tags: List<UpdateTagCollectionFilter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.UpdateResourceCollectionFilter) : this() {
            this.cloudFormation = x.cloudFormation
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.UpdateResourceCollectionFilter = UpdateResourceCollectionFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.UpdateCloudFormationCollectionFilter] inside the given [block]
         */
        public fun cloudFormation(block: aws.sdk.kotlin.services.devopsguru.model.UpdateCloudFormationCollectionFilter.Builder.() -> kotlin.Unit) {
            this.cloudFormation = aws.sdk.kotlin.services.devopsguru.model.UpdateCloudFormationCollectionFilter.invoke(block)
        }
    }
}
