// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.devopsguru.model.CostEstimationResourceCollectionFilter
import aws.sdk.kotlin.services.devopsguru.model.CostEstimationStatus
import aws.sdk.kotlin.services.devopsguru.model.CostEstimationTimeRange
import aws.sdk.kotlin.services.devopsguru.model.DevOpsGuruException
import aws.sdk.kotlin.services.devopsguru.model.GetCostEstimationResponse
import aws.sdk.kotlin.services.devopsguru.model.ServiceResourceCost
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCostEstimationOperationDeserializer: HttpDeserialize<GetCostEstimationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCostEstimationResponse {
        if (!response.status.isSuccess()) {
            throwGetCostEstimationError(context, response)
        }
        val builder = GetCostEstimationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCostEstimationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCostEstimationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DevOpsGuruException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DevOpsGuruException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCostEstimationOperationBody(builder: GetCostEstimationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COSTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Costs"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESOURCECOLLECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResourceCollection"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TIMERANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeRange"))
    val TOTALCOST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("TotalCost"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COSTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOURCECOLLECTION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TIMERANGE_DESCRIPTOR)
        field(TOTALCOST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COSTS_DESCRIPTOR.index -> builder.costs =
                    deserializer.deserializeList(COSTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ServiceResourceCost>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServiceResourceCostDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESOURCECOLLECTION_DESCRIPTOR.index -> builder.resourceCollection = deserializeCostEstimationResourceCollectionFilterDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { CostEstimationStatus.fromValue(it) }
                TIMERANGE_DESCRIPTOR.index -> builder.timeRange = deserializeCostEstimationTimeRangeDocument(deserializer)
                TOTALCOST_DESCRIPTOR.index -> builder.totalCost = deserializeDouble()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
