// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.devopsguru.model.*
import aws.sdk.kotlin.services.devopsguru.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "DevOps Guru"
public const val ServiceApiVersion: String = "2020-12-01"
public const val SdkVersion: String = "0.17.3-beta"

internal class DefaultDevOpsGuruClient(override val config: DevOpsGuruClient.Config) : DevOpsGuruClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated.
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for cross account Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
     *
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
     *
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
     */
    override suspend fun addNotificationChannel(input: AddNotificationChannelRequest): AddNotificationChannelResponse {
        val op = SdkHttpOperation.build<AddNotificationChannelRequest, AddNotificationChannelResponse> {
            serializer = AddNotificationChannelOperationSerializer()
            deserializer = AddNotificationChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddNotificationChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the insight along with the associated anomalies, events and recommendations.
     */
    override suspend fun deleteInsight(input: DeleteInsightRequest): DeleteInsightResponse {
        val op = SdkHttpOperation.build<DeleteInsightRequest, DeleteInsightResponse> {
            serializer = DeleteInsightOperationSerializer()
            deserializer = DeleteInsightOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInsight"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account.
     */
    override suspend fun describeAccountHealth(input: DescribeAccountHealthRequest): DescribeAccountHealthResponse {
        val op = SdkHttpOperation.build<DescribeAccountHealthRequest, DescribeAccountHealthResponse> {
            serializer = DescribeAccountHealthOperationSerializer()
            deserializer = DescribeAccountHealthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountHealth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
     */
    override suspend fun describeAccountOverview(input: DescribeAccountOverviewRequest): DescribeAccountOverviewResponse {
        val op = SdkHttpOperation.build<DescribeAccountOverviewRequest, DescribeAccountOverviewResponse> {
            serializer = DescribeAccountOverviewOperationSerializer()
            deserializer = DescribeAccountOverviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountOverview"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns details about an anomaly that you specify using its ID.
     */
    override suspend fun describeAnomaly(input: DescribeAnomalyRequest): DescribeAnomalyResponse {
        val op = SdkHttpOperation.build<DescribeAnomalyRequest, DescribeAnomalyResponse> {
            serializer = DescribeAnomalyOperationSerializer()
            deserializer = DescribeAnomalyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAnomaly"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
     */
    override suspend fun describeEventSourcesConfig(input: DescribeEventSourcesConfigRequest): DescribeEventSourcesConfigResponse {
        val op = SdkHttpOperation.build<DescribeEventSourcesConfigRequest, DescribeEventSourcesConfigResponse> {
            serializer = DescribeEventSourcesConfigOperationSerializer()
            deserializer = DescribeEventSourcesConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventSourcesConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
     */
    override suspend fun describeFeedback(input: DescribeFeedbackRequest): DescribeFeedbackResponse {
        val op = SdkHttpOperation.build<DescribeFeedbackRequest, DescribeFeedbackResponse> {
            serializer = DescribeFeedbackOperationSerializer()
            deserializer = DescribeFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFeedback"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns details about an insight that you specify using its ID.
     */
    override suspend fun describeInsight(input: DescribeInsightRequest): DescribeInsightResponse {
        val op = SdkHttpOperation.build<DescribeInsightRequest, DescribeInsightResponse> {
            serializer = DescribeInsightOperationSerializer()
            deserializer = DescribeInsightOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInsight"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns active insights, predictive insights, and resource hours analyzed in last hour.
     */
    override suspend fun describeOrganizationHealth(input: DescribeOrganizationHealthRequest): DescribeOrganizationHealthResponse {
        val op = SdkHttpOperation.build<DescribeOrganizationHealthRequest, DescribeOrganizationHealthResponse> {
            serializer = DescribeOrganizationHealthOperationSerializer()
            deserializer = DescribeOrganizationHealthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrganizationHealth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an overview of your organization's history based on the specified time range. The overview includes the total reactive and proactive insights.
     */
    override suspend fun describeOrganizationOverview(input: DescribeOrganizationOverviewRequest): DescribeOrganizationOverviewResponse {
        val op = SdkHttpOperation.build<DescribeOrganizationOverviewRequest, DescribeOrganizationOverviewResponse> {
            serializer = DescribeOrganizationOverviewOperationSerializer()
            deserializer = DescribeOrganizationOverviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrganizationOverview"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you can filter those accounts using the `AccountIds` field.
     */
    override suspend fun describeOrganizationResourceCollectionHealth(input: DescribeOrganizationResourceCollectionHealthRequest): DescribeOrganizationResourceCollectionHealthResponse {
        val op = SdkHttpOperation.build<DescribeOrganizationResourceCollectionHealthRequest, DescribeOrganizationResourceCollectionHealthResponse> {
            serializer = DescribeOrganizationResourceCollectionHealthOperationSerializer()
            deserializer = DescribeOrganizationResourceCollectionHealthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrganizationResourceCollectionHealth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    override suspend fun describeResourceCollectionHealth(input: DescribeResourceCollectionHealthRequest): DescribeResourceCollectionHealthResponse {
        val op = SdkHttpOperation.build<DescribeResourceCollectionHealthRequest, DescribeResourceCollectionHealthResponse> {
            serializer = DescribeResourceCollectionHealthOperationSerializer()
            deserializer = DescribeResourceCollectionHealthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeResourceCollectionHealth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
     */
    override suspend fun describeServiceIntegration(input: DescribeServiceIntegrationRequest): DescribeServiceIntegrationResponse {
        val op = SdkHttpOperation.build<DescribeServiceIntegrationRequest, DescribeServiceIntegrationResponse> {
            serializer = DescribeServiceIntegrationOperationSerializer()
            deserializer = DescribeServiceIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeServiceIntegration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](http://aws.amazon.com/devops-guru/pricing/).
     */
    override suspend fun getCostEstimation(input: GetCostEstimationRequest): GetCostEstimationResponse {
        val op = SdkHttpOperation.build<GetCostEstimationRequest, GetCostEstimationResponse> {
            serializer = GetCostEstimationOperationSerializer()
            deserializer = GetCostEstimationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCostEstimation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    override suspend fun getResourceCollection(input: GetResourceCollectionRequest): GetResourceCollectionResponse {
        val op = SdkHttpOperation.build<GetResourceCollectionRequest, GetResourceCollectionResponse> {
            serializer = GetResourceCollectionOperationSerializer()
            deserializer = GetResourceCollectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResourceCollection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     */
    override suspend fun listAnomaliesForInsight(input: ListAnomaliesForInsightRequest): ListAnomaliesForInsightResponse {
        val op = SdkHttpOperation.build<ListAnomaliesForInsightRequest, ListAnomaliesForInsightResponse> {
            serializer = ListAnomaliesForInsightOperationSerializer()
            deserializer = ListAnomaliesForInsightOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAnomaliesForInsight"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of log groups that contain log anomalies.
     */
    override suspend fun listAnomalousLogGroups(input: ListAnomalousLogGroupsRequest): ListAnomalousLogGroupsResponse {
        val op = SdkHttpOperation.build<ListAnomalousLogGroupsRequest, ListAnomalousLogGroupsResponse> {
            serializer = ListAnomalousLogGroupsOperationSerializer()
            deserializer = ListAnomalousLogGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAnomalousLogGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to specify which events are returned.
     */
    override suspend fun listEvents(input: ListEventsRequest): ListEventsResponse {
        val op = SdkHttpOperation.build<ListEventsRequest, ListEventsResponse> {
            serializer = ListEventsOperationSerializer()
            deserializer = ListEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time and status (`ONGOING`, `CLOSED`, or `ANY`).
     */
    override suspend fun listInsights(input: ListInsightsRequest): ListInsightsResponse {
        val op = SdkHttpOperation.build<ListInsightsRequest, ListInsightsResponse> {
            serializer = ListInsightsOperationSerializer()
            deserializer = ListInsightsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInsights"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
     */
    override suspend fun listMonitoredResources(input: ListMonitoredResourcesRequest): ListMonitoredResourcesResponse {
        val op = SdkHttpOperation.build<ListMonitoredResourcesRequest, ListMonitoredResourcesResponse> {
            serializer = ListMonitoredResourcesOperationSerializer()
            deserializer = ListMonitoredResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMonitoredResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     */
    override suspend fun listNotificationChannels(input: ListNotificationChannelsRequest): ListNotificationChannelsResponse {
        val op = SdkHttpOperation.build<ListNotificationChannelsRequest, ListNotificationChannelsResponse> {
            serializer = ListNotificationChannelsOperationSerializer()
            deserializer = ListNotificationChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNotificationChannels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of insights associated with the account or OU Id.
     */
    override suspend fun listOrganizationInsights(input: ListOrganizationInsightsRequest): ListOrganizationInsightsResponse {
        val op = SdkHttpOperation.build<ListOrganizationInsightsRequest, ListOrganizationInsightsResponse> {
            serializer = ListOrganizationInsightsOperationSerializer()
            deserializer = ListOrganizationInsightsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOrganizationInsights"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics and a list of related events.
     */
    override suspend fun listRecommendations(input: ListRecommendationsRequest): ListRecommendationsResponse {
        val op = SdkHttpOperation.build<ListRecommendationsRequest, ListRecommendationsResponse> {
            serializer = ListRecommendationsOperationSerializer()
            deserializer = ListRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Collects customer feedback about the specified insight.
     */
    override suspend fun putFeedback(input: PutFeedbackRequest): PutFeedbackResponse {
        val op = SdkHttpOperation.build<PutFeedbackRequest, PutFeedbackResponse> {
            serializer = PutFeedbackOperationSerializer()
            deserializer = PutFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutFeedback"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations.
     */
    override suspend fun removeNotificationChannel(input: RemoveNotificationChannelRequest): RemoveNotificationChannelResponse {
        val op = SdkHttpOperation.build<RemoveNotificationChannelRequest, RemoveNotificationChannelResponse> {
            serializer = RemoveNotificationChannelOperationSerializer()
            deserializer = RemoveNotificationChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveNotificationChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
     *
     *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
     */
    override suspend fun searchInsights(input: SearchInsightsRequest): SearchInsightsResponse {
        val op = SdkHttpOperation.build<SearchInsightsRequest, SearchInsightsResponse> {
            serializer = SearchInsightsOperationSerializer()
            deserializer = SearchInsightsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchInsights"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time, one or more statuses (`ONGOING`, `CLOSED`, and `CLOSED`), one or more severities (`LOW`, `MEDIUM`, and `HIGH`), and type (`REACTIVE` or `PROACTIVE`).
     *
     *  Use the `Filters` parameter to specify status and severity search parameters. Use the `Type` parameter to specify `REACTIVE` or `PROACTIVE` in your search.
     */
    override suspend fun searchOrganizationInsights(input: SearchOrganizationInsightsRequest): SearchOrganizationInsightsResponse {
        val op = SdkHttpOperation.build<SearchOrganizationInsightsRequest, SearchOrganizationInsightsResponse> {
            serializer = SearchOrganizationInsightsOperationSerializer()
            deserializer = SearchOrganizationInsightsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchOrganizationInsights"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
     */
    override suspend fun startCostEstimation(input: StartCostEstimationRequest): StartCostEstimationResponse {
        val op = SdkHttpOperation.build<StartCostEstimationRequest, StartCostEstimationResponse> {
            serializer = StartCostEstimationOperationSerializer()
            deserializer = StartCostEstimationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartCostEstimation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can be stored and viewed in DevOps Guru.
     */
    override suspend fun updateEventSourcesConfig(input: UpdateEventSourcesConfigRequest): UpdateEventSourcesConfigResponse {
        val op = SdkHttpOperation.build<UpdateEventSourcesConfigRequest, UpdateEventSourcesConfigResponse> {
            serializer = UpdateEventSourcesConfigOperationSerializer()
            deserializer = UpdateEventSourcesConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEventSourcesConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru.
     */
    override suspend fun updateResourceCollection(input: UpdateResourceCollectionRequest): UpdateResourceCollectionResponse {
        val op = SdkHttpOperation.build<UpdateResourceCollectionRequest, UpdateResourceCollectionResponse> {
            serializer = UpdateResourceCollectionOperationSerializer()
            deserializer = UpdateResourceCollectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateResourceCollection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight.
     */
    override suspend fun updateServiceIntegration(input: UpdateServiceIntegrationRequest): UpdateServiceIntegrationResponse {
        val op = SdkHttpOperation.build<UpdateServiceIntegrationRequest, UpdateServiceIntegrationResponse> {
            serializer = UpdateServiceIntegrationOperationSerializer()
            deserializer = UpdateServiceIntegrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateServiceIntegration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "devops-guru"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "devops-guru")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
