// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Information about a filter used to specify which Amazon Web Services resources are analyzed to create a monthly DevOps Guru cost estimate. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](http://aws.amazon.com/devops-guru/pricing/).
 */
public class CostEstimationResourceCollectionFilter private constructor(builder: Builder) {
    /**
     * An object that specifies the CloudFormation stack that defines the Amazon Web Services resources used to create a monthly estimate for DevOps Guru.
     */
    public val cloudFormation: aws.sdk.kotlin.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter? = builder.cloudFormation
    /**
     * The Amazon Web Services tags used to filter the resource collection that is used for a cost estimate.
     *
     * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the [Tagging best practices](https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf) whitepaper.
     *
     * Each Amazon Web Services tag has two parts.
     * + A tag *key* (for example, `CostCenter`, `Environment`, `Project`, or `Secret`). Tag *keys* are case-sensitive.
     * + An optional field known as a tag *value* (for example, `111122223333`, `Production`, or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive.
     *
     * Together these are known as *key*-*value* pairs.
     *
     * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
     */
    public val tags: List<TagCostEstimationResourceCollectionFilter>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.CostEstimationResourceCollectionFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CostEstimationResourceCollectionFilter(")
        append("cloudFormation=$cloudFormation,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudFormation?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CostEstimationResourceCollectionFilter

        if (cloudFormation != other.cloudFormation) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.CostEstimationResourceCollectionFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that specifies the CloudFormation stack that defines the Amazon Web Services resources used to create a monthly estimate for DevOps Guru.
         */
        public var cloudFormation: aws.sdk.kotlin.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter? = null
        /**
         * The Amazon Web Services tags used to filter the resource collection that is used for a cost estimate.
         *
         * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the [Tagging best practices](https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf) whitepaper.
         *
         * Each Amazon Web Services tag has two parts.
         * + A tag *key* (for example, `CostCenter`, `Environment`, `Project`, or `Secret`). Tag *keys* are case-sensitive.
         * + An optional field known as a tag *value* (for example, `111122223333`, `Production`, or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive.
         *
         * Together these are known as *key*-*value* pairs.
         *
         * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `Devops-guru-deployment-application` or `Devops-guru-rds-application`. While *keys* are case-sensitive, the case of *key* characters don't matter to DevOps Guru. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
         */
        public var tags: List<TagCostEstimationResourceCollectionFilter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.CostEstimationResourceCollectionFilter) : this() {
            this.cloudFormation = x.cloudFormation
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.CostEstimationResourceCollectionFilter = CostEstimationResourceCollectionFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter] inside the given [block]
         */
        public fun cloudFormation(block: aws.sdk.kotlin.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter.Builder.() -> kotlin.Unit) {
            this.cloudFormation = aws.sdk.kotlin.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter.invoke(block)
        }
    }
}
