// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Details about a proactive insight. This object is returned by `DescribeInsight`.
 */
public class ProactiveOrganizationInsightSummary private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The ID of the insight summary.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A time ranged that specifies when the observed behavior in an insight started and ended.
     */
    public val insightTimeRange: aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange? = builder.insightTimeRange
    /**
     * The name of the insight summary.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the organizational unit.
     */
    public val organizationalUnitId: kotlin.String? = builder.organizationalUnitId
    /**
     * The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
     */
    public val predictionTimeRange: aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange? = builder.predictionTimeRange
    /**
     * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public val resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = builder.resourceCollection
    /**
     * A collection of the names of Amazon Web Services services.
     */
    public val serviceCollection: aws.sdk.kotlin.services.devopsguru.model.ServiceCollection? = builder.serviceCollection
    /**
     * An array of severity values used to search for insights. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
     */
    public val severity: aws.sdk.kotlin.services.devopsguru.model.InsightSeverity? = builder.severity
    /**
     * An array of status values used to search for insights.
     */
    public val status: aws.sdk.kotlin.services.devopsguru.model.InsightStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.ProactiveOrganizationInsightSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProactiveOrganizationInsightSummary(")
        append("accountId=$accountId,")
        append("id=$id,")
        append("insightTimeRange=$insightTimeRange,")
        append("name=$name,")
        append("organizationalUnitId=$organizationalUnitId,")
        append("predictionTimeRange=$predictionTimeRange,")
        append("resourceCollection=$resourceCollection,")
        append("serviceCollection=$serviceCollection,")
        append("severity=$severity,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (insightTimeRange?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitId?.hashCode() ?: 0)
        result = 31 * result + (predictionTimeRange?.hashCode() ?: 0)
        result = 31 * result + (resourceCollection?.hashCode() ?: 0)
        result = 31 * result + (serviceCollection?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProactiveOrganizationInsightSummary

        if (accountId != other.accountId) return false
        if (id != other.id) return false
        if (insightTimeRange != other.insightTimeRange) return false
        if (name != other.name) return false
        if (organizationalUnitId != other.organizationalUnitId) return false
        if (predictionTimeRange != other.predictionTimeRange) return false
        if (resourceCollection != other.resourceCollection) return false
        if (serviceCollection != other.serviceCollection) return false
        if (severity != other.severity) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.ProactiveOrganizationInsightSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account.
         */
        public var accountId: kotlin.String? = null
        /**
         * The ID of the insight summary.
         */
        public var id: kotlin.String? = null
        /**
         * A time ranged that specifies when the observed behavior in an insight started and ended.
         */
        public var insightTimeRange: aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange? = null
        /**
         * The name of the insight summary.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the organizational unit.
         */
        public var organizationalUnitId: kotlin.String? = null
        /**
         * The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur.
         */
        public var predictionTimeRange: aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange? = null
        /**
         * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        public var resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = null
        /**
         * A collection of the names of Amazon Web Services services.
         */
        public var serviceCollection: aws.sdk.kotlin.services.devopsguru.model.ServiceCollection? = null
        /**
         * An array of severity values used to search for insights. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
         */
        public var severity: aws.sdk.kotlin.services.devopsguru.model.InsightSeverity? = null
        /**
         * An array of status values used to search for insights.
         */
        public var status: aws.sdk.kotlin.services.devopsguru.model.InsightStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.ProactiveOrganizationInsightSummary) : this() {
            this.accountId = x.accountId
            this.id = x.id
            this.insightTimeRange = x.insightTimeRange
            this.name = x.name
            this.organizationalUnitId = x.organizationalUnitId
            this.predictionTimeRange = x.predictionTimeRange
            this.resourceCollection = x.resourceCollection
            this.serviceCollection = x.serviceCollection
            this.severity = x.severity
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.ProactiveOrganizationInsightSummary = ProactiveOrganizationInsightSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange] inside the given [block]
         */
        public fun insightTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange.Builder.() -> kotlin.Unit) {
            this.insightTimeRange = aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange] inside the given [block]
         */
        public fun predictionTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange.Builder.() -> kotlin.Unit) {
            this.predictionTimeRange = aws.sdk.kotlin.services.devopsguru.model.PredictionTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ResourceCollection] inside the given [block]
         */
        public fun resourceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.Builder.() -> kotlin.Unit) {
            this.resourceCollection = aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ServiceCollection] inside the given [block]
         */
        public fun serviceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ServiceCollection.Builder.() -> kotlin.Unit) {
            this.serviceCollection = aws.sdk.kotlin.services.devopsguru.model.ServiceCollection.invoke(block)
        }
    }
}
