// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.devopsguru.model.AnomalousLogGroup
import aws.sdk.kotlin.services.devopsguru.model.DevOpsGuruException
import aws.sdk.kotlin.services.devopsguru.model.ListAnomalousLogGroupsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListAnomalousLogGroupsOperationDeserializer: HttpDeserialize<ListAnomalousLogGroupsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListAnomalousLogGroupsResponse {
        if (!response.status.isSuccess()) {
            throwListAnomalousLogGroupsError(context, response)
        }
        val builder = ListAnomalousLogGroupsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAnomalousLogGroupsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListAnomalousLogGroupsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DevOpsGuruException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DevOpsGuruException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAnomalousLogGroupsOperationBody(builder: ListAnomalousLogGroupsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALOUSLOGGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AnomalousLogGroups"))
    val INSIGHTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InsightId"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALOUSLOGGROUPS_DESCRIPTOR)
        field(INSIGHTID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALOUSLOGGROUPS_DESCRIPTOR.index -> builder.anomalousLogGroups =
                    deserializer.deserializeList(ANOMALOUSLOGGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<AnomalousLogGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAnomalousLogGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INSIGHTID_DESCRIPTOR.index -> builder.insightId = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
