// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon CloudWatch log group that contains log anomalies and is used to generate an insight.
 */
public class AnomalousLogGroup private constructor(builder: Builder) {
    /**
     * The time the anomalous log events stopped.
     */
    public val impactEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.impactEndTime
    /**
     * The time the anomalous log events began. The impact start time indicates the time of the first log anomaly event that occurs.
     */
    public val impactStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.impactStartTime
    /**
     * The log anomalies in the log group. Each log anomaly displayed represents a cluster of similar anomalous log events.
     */
    public val logAnomalyShowcases: List<LogAnomalyShowcase>? = builder.logAnomalyShowcases
    /**
     * The name of the CloudWatch log group.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The number of log lines that were scanned for anomalous log events.
     */
    public val numberOfLogLinesScanned: kotlin.Int = builder.numberOfLogLinesScanned

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.AnomalousLogGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnomalousLogGroup(")
        append("impactEndTime=$impactEndTime,")
        append("impactStartTime=$impactStartTime,")
        append("logAnomalyShowcases=$logAnomalyShowcases,")
        append("logGroupName=$logGroupName,")
        append("numberOfLogLinesScanned=$numberOfLogLinesScanned)")
    }

    override fun hashCode(): kotlin.Int {
        var result = impactEndTime?.hashCode() ?: 0
        result = 31 * result + (impactStartTime?.hashCode() ?: 0)
        result = 31 * result + (logAnomalyShowcases?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (numberOfLogLinesScanned)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnomalousLogGroup

        if (impactEndTime != other.impactEndTime) return false
        if (impactStartTime != other.impactStartTime) return false
        if (logAnomalyShowcases != other.logAnomalyShowcases) return false
        if (logGroupName != other.logGroupName) return false
        if (numberOfLogLinesScanned != other.numberOfLogLinesScanned) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.AnomalousLogGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time the anomalous log events stopped.
         */
        public var impactEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the anomalous log events began. The impact start time indicates the time of the first log anomaly event that occurs.
         */
        public var impactStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The log anomalies in the log group. Each log anomaly displayed represents a cluster of similar anomalous log events.
         */
        public var logAnomalyShowcases: List<LogAnomalyShowcase>? = null
        /**
         * The name of the CloudWatch log group.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The number of log lines that were scanned for anomalous log events.
         */
        public var numberOfLogLinesScanned: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.AnomalousLogGroup) : this() {
            this.impactEndTime = x.impactEndTime
            this.impactStartTime = x.impactStartTime
            this.logAnomalyShowcases = x.logAnomalyShowcases
            this.logGroupName = x.logGroupName
            this.numberOfLogLinesScanned = x.numberOfLogLinesScanned
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.AnomalousLogGroup = AnomalousLogGroup(this)
    }
}
