// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Details about a reactive anomaly. This object is returned by `DescribeAnomaly.`
 */
public class ReactiveAnomalySummary private constructor(builder: Builder) {
    /**
     * An `AnomalyReportedTimeRange` object that specifies the time range between when the anomaly is opened and the time when it is closed.
     */
    public val anomalyReportedTimeRange: aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange? = builder.anomalyReportedTimeRange
    /**
     * The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.
     */
    public val anomalyResources: List<AnomalyResource>? = builder.anomalyResources
    /**
     * A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from `AnomalyReportedTimeRange`, which specifies the time range when DevOps Guru opens and then closes an anomaly.
     */
    public val anomalyTimeRange: aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange? = builder.anomalyTimeRange
    /**
     * The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
     */
    public val associatedInsightId: kotlin.String? = builder.associatedInsightId
    /**
     * The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.
     */
    public val causalAnomalyId: kotlin.String? = builder.causalAnomalyId
    /**
     * A description of the reactive anomaly.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the reactive anomaly.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the reactive anomaly.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public val resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = builder.resourceCollection
    /**
     * The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
     */
    public val severity: aws.sdk.kotlin.services.devopsguru.model.AnomalySeverity? = builder.severity
    /**
     * Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
     */
    public val sourceDetails: aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails? = builder.sourceDetails
    /**
     * The status of the reactive anomaly.
     */
    public val status: aws.sdk.kotlin.services.devopsguru.model.AnomalyStatus? = builder.status
    /**
     * The type of the reactive anomaly. It can be one of the following types.
     * + `CAUSAL` - the anomaly can cause a new insight.
     * + `CONTEXTUAL` - the anomaly contains additional information about an insight or its causal anomaly.
     */
    public val type: aws.sdk.kotlin.services.devopsguru.model.AnomalyType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.ReactiveAnomalySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReactiveAnomalySummary(")
        append("anomalyReportedTimeRange=$anomalyReportedTimeRange,")
        append("anomalyResources=$anomalyResources,")
        append("anomalyTimeRange=$anomalyTimeRange,")
        append("associatedInsightId=$associatedInsightId,")
        append("causalAnomalyId=$causalAnomalyId,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("resourceCollection=$resourceCollection,")
        append("severity=$severity,")
        append("sourceDetails=$sourceDetails,")
        append("status=$status,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalyReportedTimeRange?.hashCode() ?: 0
        result = 31 * result + (anomalyResources?.hashCode() ?: 0)
        result = 31 * result + (anomalyTimeRange?.hashCode() ?: 0)
        result = 31 * result + (associatedInsightId?.hashCode() ?: 0)
        result = 31 * result + (causalAnomalyId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceCollection?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (sourceDetails?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReactiveAnomalySummary

        if (anomalyReportedTimeRange != other.anomalyReportedTimeRange) return false
        if (anomalyResources != other.anomalyResources) return false
        if (anomalyTimeRange != other.anomalyTimeRange) return false
        if (associatedInsightId != other.associatedInsightId) return false
        if (causalAnomalyId != other.causalAnomalyId) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (resourceCollection != other.resourceCollection) return false
        if (severity != other.severity) return false
        if (sourceDetails != other.sourceDetails) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.ReactiveAnomalySummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An `AnomalyReportedTimeRange` object that specifies the time range between when the anomaly is opened and the time when it is closed.
         */
        public var anomalyReportedTimeRange: aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange? = null
        /**
         * The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.
         */
        public var anomalyResources: List<AnomalyResource>? = null
        /**
         * A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from `AnomalyReportedTimeRange`, which specifies the time range when DevOps Guru opens and then closes an anomaly.
         */
        public var anomalyTimeRange: aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange? = null
        /**
         * The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
         */
        public var associatedInsightId: kotlin.String? = null
        /**
         * The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.
         */
        public var causalAnomalyId: kotlin.String? = null
        /**
         * A description of the reactive anomaly.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the reactive anomaly.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the reactive anomaly.
         */
        public var name: kotlin.String? = null
        /**
         * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        public var resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = null
        /**
         * The severity of the anomaly. The severity of anomalies that generate an insight determine that insight's severity. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
         */
        public var severity: aws.sdk.kotlin.services.devopsguru.model.AnomalySeverity? = null
        /**
         * Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics.
         */
        public var sourceDetails: aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails? = null
        /**
         * The status of the reactive anomaly.
         */
        public var status: aws.sdk.kotlin.services.devopsguru.model.AnomalyStatus? = null
        /**
         * The type of the reactive anomaly. It can be one of the following types.
         * + `CAUSAL` - the anomaly can cause a new insight.
         * + `CONTEXTUAL` - the anomaly contains additional information about an insight or its causal anomaly.
         */
        public var type: aws.sdk.kotlin.services.devopsguru.model.AnomalyType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.ReactiveAnomalySummary) : this() {
            this.anomalyReportedTimeRange = x.anomalyReportedTimeRange
            this.anomalyResources = x.anomalyResources
            this.anomalyTimeRange = x.anomalyTimeRange
            this.associatedInsightId = x.associatedInsightId
            this.causalAnomalyId = x.causalAnomalyId
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.resourceCollection = x.resourceCollection
            this.severity = x.severity
            this.sourceDetails = x.sourceDetails
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.ReactiveAnomalySummary = ReactiveAnomalySummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange] inside the given [block]
         */
        public fun anomalyReportedTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange.Builder.() -> kotlin.Unit) {
            this.anomalyReportedTimeRange = aws.sdk.kotlin.services.devopsguru.model.AnomalyReportedTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange] inside the given [block]
         */
        public fun anomalyTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange.Builder.() -> kotlin.Unit) {
            this.anomalyTimeRange = aws.sdk.kotlin.services.devopsguru.model.AnomalyTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ResourceCollection] inside the given [block]
         */
        public fun resourceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.Builder.() -> kotlin.Unit) {
            this.resourceCollection = aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails] inside the given [block]
         */
        public fun sourceDetails(block: aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails.Builder.() -> kotlin.Unit) {
            this.sourceDetails = aws.sdk.kotlin.services.devopsguru.model.AnomalySourceDetails.invoke(block)
        }
    }
}
