// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * Information about a reactive insight. This object is returned by `DescribeInsight.`
 */
public class ReactiveInsightSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.
     */
    public val associatedResourceArns: List<String>? = builder.associatedResourceArns
    /**
     * The ID of a reactive summary.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A time ranged that specifies when the observed behavior in an insight started and ended.
     */
    public val insightTimeRange: aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange? = builder.insightTimeRange
    /**
     * The name of a reactive insight.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public val resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = builder.resourceCollection
    /**
     * A collection of the names of Amazon Web Services services.
     */
    public val serviceCollection: aws.sdk.kotlin.services.devopsguru.model.ServiceCollection? = builder.serviceCollection
    /**
     * The severity of the insight. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
     */
    public val severity: aws.sdk.kotlin.services.devopsguru.model.InsightSeverity? = builder.severity
    /**
     * The status of a reactive insight.
     */
    public val status: aws.sdk.kotlin.services.devopsguru.model.InsightStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.ReactiveInsightSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReactiveInsightSummary(")
        append("associatedResourceArns=$associatedResourceArns,")
        append("id=$id,")
        append("insightTimeRange=$insightTimeRange,")
        append("name=$name,")
        append("resourceCollection=$resourceCollection,")
        append("serviceCollection=$serviceCollection,")
        append("severity=$severity,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedResourceArns?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (insightTimeRange?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceCollection?.hashCode() ?: 0)
        result = 31 * result + (serviceCollection?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReactiveInsightSummary

        if (associatedResourceArns != other.associatedResourceArns) return false
        if (id != other.id) return false
        if (insightTimeRange != other.insightTimeRange) return false
        if (name != other.name) return false
        if (resourceCollection != other.resourceCollection) return false
        if (serviceCollection != other.serviceCollection) return false
        if (severity != other.severity) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.ReactiveInsightSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.
         */
        public var associatedResourceArns: List<String>? = null
        /**
         * The ID of a reactive summary.
         */
        public var id: kotlin.String? = null
        /**
         * A time ranged that specifies when the observed behavior in an insight started and ended.
         */
        public var insightTimeRange: aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange? = null
        /**
         * The name of a reactive insight.
         */
        public var name: kotlin.String? = null
        /**
         * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag *key*. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         */
        public var resourceCollection: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection? = null
        /**
         * A collection of the names of Amazon Web Services services.
         */
        public var serviceCollection: aws.sdk.kotlin.services.devopsguru.model.ServiceCollection? = null
        /**
         * The severity of the insight. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) in the *Amazon DevOps Guru User Guide*.
         */
        public var severity: aws.sdk.kotlin.services.devopsguru.model.InsightSeverity? = null
        /**
         * The status of a reactive insight.
         */
        public var status: aws.sdk.kotlin.services.devopsguru.model.InsightStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.ReactiveInsightSummary) : this() {
            this.associatedResourceArns = x.associatedResourceArns
            this.id = x.id
            this.insightTimeRange = x.insightTimeRange
            this.name = x.name
            this.resourceCollection = x.resourceCollection
            this.serviceCollection = x.serviceCollection
            this.severity = x.severity
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.ReactiveInsightSummary = ReactiveInsightSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange] inside the given [block]
         */
        public fun insightTimeRange(block: aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange.Builder.() -> kotlin.Unit) {
            this.insightTimeRange = aws.sdk.kotlin.services.devopsguru.model.InsightTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ResourceCollection] inside the given [block]
         */
        public fun resourceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.Builder.() -> kotlin.Unit) {
            this.resourceCollection = aws.sdk.kotlin.services.devopsguru.model.ResourceCollection.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devopsguru.model.ServiceCollection] inside the given [block]
         */
        public fun serviceCollection(block: aws.sdk.kotlin.services.devopsguru.model.ServiceCollection.Builder.() -> kotlin.Unit) {
            this.serviceCollection = aws.sdk.kotlin.services.devopsguru.model.ServiceCollection.invoke(block)
        }
    }
}
