// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * An object that contains information about the estimated monthly cost to analyze an Amazon Web Services resource. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](http://aws.amazon.com/devops-guru/pricing/).
 */
public class ServiceResourceCost private constructor(builder: Builder) {
    /**
     * The total estimated monthly cost to analyze the active resources for this resource.
     */
    public val cost: kotlin.Double = builder.cost
    /**
     * The number of active resources analyzed for this service to create a monthly cost estimate.
     */
    public val count: kotlin.Int = builder.count
    /**
     * The state of the resource. The resource is `ACTIVE` if it produces metrics, events, or logs within an hour, otherwise it is `INACTIVE`. You pay for the number of active Amazon Web Services resource hours analyzed for each resource. Inactive resources are not charged.
     */
    public val state: aws.sdk.kotlin.services.devopsguru.model.CostEstimationServiceResourceState? = builder.state
    /**
     * The type of the Amazon Web Services resource.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The price per hour to analyze the resources in the service. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](http://aws.amazon.com/devops-guru/pricing/).
     */
    public val unitCost: kotlin.Double = builder.unitCost

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.ServiceResourceCost = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceResourceCost(")
        append("cost=$cost,")
        append("count=$count,")
        append("state=$state,")
        append("type=$type,")
        append("unitCost=$unitCost)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cost.hashCode()
        result = 31 * result + (count)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (unitCost.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceResourceCost

        if (cost != other.cost) return false
        if (count != other.count) return false
        if (state != other.state) return false
        if (type != other.type) return false
        if (unitCost != other.unitCost) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.ServiceResourceCost = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total estimated monthly cost to analyze the active resources for this resource.
         */
        public var cost: kotlin.Double = 0.0
        /**
         * The number of active resources analyzed for this service to create a monthly cost estimate.
         */
        public var count: kotlin.Int = 0
        /**
         * The state of the resource. The resource is `ACTIVE` if it produces metrics, events, or logs within an hour, otherwise it is `INACTIVE`. You pay for the number of active Amazon Web Services resource hours analyzed for each resource. Inactive resources are not charged.
         */
        public var state: aws.sdk.kotlin.services.devopsguru.model.CostEstimationServiceResourceState? = null
        /**
         * The type of the Amazon Web Services resource.
         */
        public var type: kotlin.String? = null
        /**
         * The price per hour to analyze the resources in the service. For more information, see [Estimate your Amazon DevOps Guru costs](https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html) and [Amazon DevOps Guru pricing](http://aws.amazon.com/devops-guru/pricing/).
         */
        public var unitCost: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.ServiceResourceCost) : this() {
            this.cost = x.cost
            this.count = x.count
            this.state = x.state
            this.type = x.type
            this.unitCost = x.unitCost
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.ServiceResourceCost = ServiceResourceCost(this)
    }
}
