// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.model



/**
 * A new collection of Amazon Web Services resources that are defined by an Amazon Web Services tag or tag *key*&#47;*value* pair.
 */
public class UpdateTagCollectionFilter private constructor(builder: Builder) {
    /**
     * An Amazon Web Services tag *key* that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this *key* make up your DevOps Guru application and analysis boundary.
     *
     * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `DevOps-Guru-deployment-application` or `devops-guru-rds-application`. When you create a *key*, the case of characters in the *key* can be whatever you choose. After you create a *key*, it is case-sensitive. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`, and these act as two different *keys*. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
     */
    public val appBoundaryKey: kotlin.String? = builder.appBoundaryKey
    /**
     * The values in an Amazon Web Services tag collection.
     *
     * The tag's *value* is an optional field used to associate a string with the tag *key* (for example, `111122223333`, `Production`, or a team name). The *key* and *value* are the tag's *key* pair. Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive. You can specify a maximum of 256 characters for a tag value.
     */
    public val tagValues: List<String>? = builder.tagValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devopsguru.model.UpdateTagCollectionFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTagCollectionFilter(")
        append("appBoundaryKey=$appBoundaryKey,")
        append("tagValues=$tagValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appBoundaryKey?.hashCode() ?: 0
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTagCollectionFilter

        if (appBoundaryKey != other.appBoundaryKey) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devopsguru.model.UpdateTagCollectionFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An Amazon Web Services tag *key* that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this *key* make up your DevOps Guru application and analysis boundary.
         *
         * The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-`. The tag *key* might be `DevOps-Guru-deployment-application` or `devops-guru-rds-application`. When you create a *key*, the case of characters in the *key* can be whatever you choose. After you create a *key*, it is case-sensitive. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS`, and these act as two different *keys*. Possible *key*&#47;*value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers`.
         */
        public var appBoundaryKey: kotlin.String? = null
        /**
         * The values in an Amazon Web Services tag collection.
         *
         * The tag's *value* is an optional field used to associate a string with the tag *key* (for example, `111122223333`, `Production`, or a team name). The *key* and *value* are the tag's *key* pair. Omitting the tag *value* is the same as using an empty string. Like tag *keys*, tag *values* are case-sensitive. You can specify a maximum of 256 characters for a tag value.
         */
        public var tagValues: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devopsguru.model.UpdateTagCollectionFilter) : this() {
            this.appBoundaryKey = x.appBoundaryKey
            this.tagValues = x.tagValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devopsguru.model.UpdateTagCollectionFilter = UpdateTagCollectionFilter(this)
    }
}
