// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.devopsguru.model.DescribeAccountOverviewResponse
import aws.sdk.kotlin.services.devopsguru.model.DevOpsGuruException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAccountOverviewOperationDeserializer: HttpDeserialize<DescribeAccountOverviewResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAccountOverviewResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAccountOverviewError(context, response)
        }
        val builder = DescribeAccountOverviewResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAccountOverviewOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAccountOverviewError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DevOpsGuruException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DevOpsGuruException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAccountOverviewOperationBody(builder: DescribeAccountOverviewResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MEANTIMETORECOVERINMILLISECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("MeanTimeToRecoverInMilliseconds"))
    val PROACTIVEINSIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ProactiveInsights"))
    val REACTIVEINSIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ReactiveInsights"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEANTIMETORECOVERINMILLISECONDS_DESCRIPTOR)
        field(PROACTIVEINSIGHTS_DESCRIPTOR)
        field(REACTIVEINSIGHTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MEANTIMETORECOVERINMILLISECONDS_DESCRIPTOR.index -> builder.meanTimeToRecoverInMilliseconds = deserializeLong()
                PROACTIVEINSIGHTS_DESCRIPTOR.index -> builder.proactiveInsights = deserializeInt()
                REACTIVEINSIGHTS_DESCRIPTOR.index -> builder.reactiveInsights = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
