// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.devopsguru.model.AccountHealth
import aws.sdk.kotlin.services.devopsguru.model.CloudFormationHealth
import aws.sdk.kotlin.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse
import aws.sdk.kotlin.services.devopsguru.model.DevOpsGuruException
import aws.sdk.kotlin.services.devopsguru.model.ServiceHealth
import aws.sdk.kotlin.services.devopsguru.model.TagHealth
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeOrganizationResourceCollectionHealthOperationDeserializer: HttpDeserialize<DescribeOrganizationResourceCollectionHealthResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeOrganizationResourceCollectionHealthResponse {
        if (!response.status.isSuccess()) {
            throwDescribeOrganizationResourceCollectionHealthError(context, response)
        }
        val builder = DescribeOrganizationResourceCollectionHealthResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOrganizationResourceCollectionHealthOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeOrganizationResourceCollectionHealthError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DevOpsGuruException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DevOpsGuruException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOrganizationResourceCollectionHealthOperationBody(builder: DescribeOrganizationResourceCollectionHealthResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Account"))
    val CLOUDFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CloudFormation"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SERVICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Service"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNT_DESCRIPTOR)
        field(CLOUDFORMATION_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SERVICE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNT_DESCRIPTOR.index -> builder.account =
                    deserializer.deserializeList(ACCOUNT_DESCRIPTOR) {
                        val col0 = mutableListOf<AccountHealth>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAccountHealthDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CLOUDFORMATION_DESCRIPTOR.index -> builder.cloudFormation =
                    deserializer.deserializeList(CLOUDFORMATION_DESCRIPTOR) {
                        val col0 = mutableListOf<CloudFormationHealth>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCloudFormationHealthDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SERVICE_DESCRIPTOR.index -> builder.service =
                    deserializer.deserializeList(SERVICE_DESCRIPTOR) {
                        val col0 = mutableListOf<ServiceHealth>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServiceHealthDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<TagHealth>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagHealthDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
