// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devopsguru.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.devopsguru.model.DevOpsGuruException
import aws.sdk.kotlin.services.devopsguru.model.ListAnomaliesForInsightResponse
import aws.sdk.kotlin.services.devopsguru.model.ProactiveAnomalySummary
import aws.sdk.kotlin.services.devopsguru.model.ReactiveAnomalySummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListAnomaliesForInsightOperationDeserializer: HttpDeserialize<ListAnomaliesForInsightResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListAnomaliesForInsightResponse {
        if (!response.status.isSuccess()) {
            throwListAnomaliesForInsightError(context, response)
        }
        val builder = ListAnomaliesForInsightResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAnomaliesForInsightOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListAnomaliesForInsightError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DevOpsGuruException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DevOpsGuruException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAnomaliesForInsightOperationBody(builder: ListAnomaliesForInsightResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val PROACTIVEANOMALIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProactiveAnomalies"))
    val REACTIVEANOMALIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ReactiveAnomalies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(PROACTIVEANOMALIES_DESCRIPTOR)
        field(REACTIVEANOMALIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PROACTIVEANOMALIES_DESCRIPTOR.index -> builder.proactiveAnomalies =
                    deserializer.deserializeList(PROACTIVEANOMALIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProactiveAnomalySummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProactiveAnomalySummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REACTIVEANOMALIES_DESCRIPTOR.index -> builder.reactiveAnomalies =
                    deserializer.deserializeList(REACTIVEANOMALIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ReactiveAnomalySummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReactiveAnomalySummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
