// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.directconnect.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.directconnect.model.*
import aws.sdk.kotlin.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
import aws.sdk.kotlin.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse
import aws.sdk.kotlin.services.directconnect.model.AllocateConnectionOnInterconnectRequest
import aws.sdk.kotlin.services.directconnect.model.AllocateConnectionOnInterconnectResponse
import aws.sdk.kotlin.services.directconnect.model.AllocateHostedConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.AllocateHostedConnectionResponse
import aws.sdk.kotlin.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.AllocatePublicVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.AllocatePublicVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.AllocateTransitVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.AllocateTransitVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.AssociateConnectionWithLagRequest
import aws.sdk.kotlin.services.directconnect.model.AssociateConnectionWithLagResponse
import aws.sdk.kotlin.services.directconnect.model.AssociateHostedConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.AssociateHostedConnectionResponse
import aws.sdk.kotlin.services.directconnect.model.AssociateMacSecKeyRequest
import aws.sdk.kotlin.services.directconnect.model.AssociateMacSecKeyResponse
import aws.sdk.kotlin.services.directconnect.model.AssociateVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.AssociateVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.ConfirmConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmConnectionResponse
import aws.sdk.kotlin.services.directconnect.model.ConfirmCustomerAgreementRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmCustomerAgreementResponse
import aws.sdk.kotlin.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.CreateBgpPeerRequest
import aws.sdk.kotlin.services.directconnect.model.CreateBgpPeerResponse
import aws.sdk.kotlin.services.directconnect.model.CreateConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.CreateConnectionResponse
import aws.sdk.kotlin.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
import aws.sdk.kotlin.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse
import aws.sdk.kotlin.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest
import aws.sdk.kotlin.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse
import aws.sdk.kotlin.services.directconnect.model.CreateDirectConnectGatewayRequest
import aws.sdk.kotlin.services.directconnect.model.CreateDirectConnectGatewayResponse
import aws.sdk.kotlin.services.directconnect.model.CreateInterconnectRequest
import aws.sdk.kotlin.services.directconnect.model.CreateInterconnectResponse
import aws.sdk.kotlin.services.directconnect.model.CreateLagRequest
import aws.sdk.kotlin.services.directconnect.model.CreateLagResponse
import aws.sdk.kotlin.services.directconnect.model.CreatePrivateVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.CreatePrivateVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.CreatePublicVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.CreatePublicVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.CreateTransitVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.CreateTransitVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.DeleteBgpPeerRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteBgpPeerResponse
import aws.sdk.kotlin.services.directconnect.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteConnectionResponse
import aws.sdk.kotlin.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse
import aws.sdk.kotlin.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse
import aws.sdk.kotlin.services.directconnect.model.DeleteDirectConnectGatewayRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteDirectConnectGatewayResponse
import aws.sdk.kotlin.services.directconnect.model.DeleteInterconnectRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteInterconnectResponse
import aws.sdk.kotlin.services.directconnect.model.DeleteLagRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteLagResponse
import aws.sdk.kotlin.services.directconnect.model.DeleteVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeConnectionLoaRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeConnectionLoaResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeConnectionsOnInterconnectRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeConnectionsOnInterconnectResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeConnectionsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeConnectionsResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeCustomerMetadataRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeCustomerMetadataResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewaysRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewaysResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeHostedConnectionsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeHostedConnectionsResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeInterconnectLoaRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeInterconnectLoaResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeInterconnectsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeInterconnectsResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeLagsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeLagsResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeLoaRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeLoaResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeLocationsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeLocationsResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeRouterConfigurationRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeRouterConfigurationResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeTagsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeTagsResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeVirtualGatewaysRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeVirtualGatewaysResponse
import aws.sdk.kotlin.services.directconnect.model.DescribeVirtualInterfacesRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeVirtualInterfacesResponse
import aws.sdk.kotlin.services.directconnect.model.DisassociateConnectionFromLagRequest
import aws.sdk.kotlin.services.directconnect.model.DisassociateConnectionFromLagResponse
import aws.sdk.kotlin.services.directconnect.model.DisassociateMacSecKeyRequest
import aws.sdk.kotlin.services.directconnect.model.DisassociateMacSecKeyResponse
import aws.sdk.kotlin.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
import aws.sdk.kotlin.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse
import aws.sdk.kotlin.services.directconnect.model.StartBgpFailoverTestRequest
import aws.sdk.kotlin.services.directconnect.model.StartBgpFailoverTestResponse
import aws.sdk.kotlin.services.directconnect.model.StopBgpFailoverTestRequest
import aws.sdk.kotlin.services.directconnect.model.StopBgpFailoverTestResponse
import aws.sdk.kotlin.services.directconnect.model.TagResourceRequest
import aws.sdk.kotlin.services.directconnect.model.TagResourceResponse
import aws.sdk.kotlin.services.directconnect.model.UntagResourceRequest
import aws.sdk.kotlin.services.directconnect.model.UntagResourceResponse
import aws.sdk.kotlin.services.directconnect.model.UpdateConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateConnectionResponse
import aws.sdk.kotlin.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse
import aws.sdk.kotlin.services.directconnect.model.UpdateDirectConnectGatewayRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateDirectConnectGatewayResponse
import aws.sdk.kotlin.services.directconnect.model.UpdateLagRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateLagResponse
import aws.sdk.kotlin.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Direct Connect links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end of the cable is connected to your router, the other to an Direct Connect router. With this connection in place, you can create virtual interfaces directly to the Amazon Web Services Cloud (for example, to Amazon EC2 and Amazon S3) and to Amazon VPC, bypassing Internet service providers in your network path. A connection provides access to all Amazon Web Services Regions except the China (Beijing) and (China) Ningxia Regions. Amazon Web Services resources in the China Regions can only be accessed through locations associated with those Regions.
 */
public interface DirectConnectClient : SdkClient {

    override val serviceName: String
        get() = "Direct Connect"
    /**
     * DirectConnectClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): DirectConnectClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDirectConnectClient(config)
        }

        public operator fun invoke(config: Config): DirectConnectClient = DefaultDirectConnectClient(config)

        /**
         * Construct a [DirectConnectClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DirectConnectClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultDirectConnectClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
     */
    public suspend fun acceptDirectConnectGatewayAssociationProposal(input: AcceptDirectConnectGatewayAssociationProposalRequest): AcceptDirectConnectGatewayAssociationProposalResponse

    /**
     * Deprecated. Use AllocateHostedConnection instead.
     *
     * Creates a hosted connection on an interconnect.
     *
     * Allocates a VLAN number and a specified amount of bandwidth for use by a hosted connection on the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun allocateConnectionOnInterconnect(input: AllocateConnectionOnInterconnectRequest): AllocateConnectionOnInterconnectResponse

    /**
     * Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
     *
     * Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the specified capacity and the Direct Connect Partner must also police the hosted connection for the specified capacity.
     *
     * Intended for use by Direct Connect Partners only.
     */
    public suspend fun allocateHostedConnection(input: AllocateHostedConnectionRequest): AllocateHostedConnectionResponse

    /**
     * Provisions a private virtual interface to be owned by the specified Amazon Web Services account.
     *
     * Virtual interfaces created using this action must be confirmed by the owner using ConfirmPrivateVirtualInterface. Until then, the virtual interface is in the `Confirming` state and is not available to handle traffic.
     */
    public suspend fun allocatePrivateVirtualInterface(input: AllocatePrivateVirtualInterfaceRequest): AllocatePrivateVirtualInterfaceResponse

    /**
     * Provisions a public virtual interface to be owned by the specified Amazon Web Services account.
     *
     * The owner of a connection calls this function to provision a public virtual interface to be owned by the specified Amazon Web Services account.
     *
     * Virtual interfaces created using this function must be confirmed by the owner using ConfirmPublicVirtualInterface. Until this step has been completed, the virtual interface is in the `confirming` state and is not available to handle traffic.
     *
     * When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     */
    public suspend fun allocatePublicVirtualInterface(input: AllocatePublicVirtualInterfaceRequest): AllocatePublicVirtualInterfaceResponse

    /**
     * Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of interface to connect a transit gateway to your Direct Connect gateway.
     *
     * The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services account.
     *
     * After you create a transit virtual interface, it must be confirmed by the owner using ConfirmTransitVirtualInterface. Until this step has been completed, the transit virtual interface is in the `requested` state and is not available to handle traffic.
     */
    public suspend fun allocateTransitVirtualInterface(input: AllocateTransitVirtualInterfaceRequest): AllocateTransitVirtualInterfaceResponse

    /**
     * Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG. You can re-associate a connection that's currently associated with a different LAG; however, if removing the connection would cause the original LAG to fall below its setting for minimum number of operational connections, the request fails.
     *
     * Any virtual interfaces that are directly associated with the connection are automatically re-associated with the LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated with the original LAG.
     *
     * For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was originally associated with a different LAG, the hosted connections remain associated with the original LAG.
     */
    public suspend fun associateConnectionWithLag(input: AssociateConnectionWithLagRequest): AssociateConnectionWithLagResponse

    /**
     * Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address, the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web Services as it is being migrated.
     *
     * Intended for use by Direct Connect Partners only.
     */
    public suspend fun associateHostedConnection(input: AssociateHostedConnectionRequest): AssociateHostedConnectionResponse

    /**
     * Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection.
     *
     * You must supply either the `secretARN,` or the CKN/CAK (`ckn` and `cak`) pair in the request.
     *
     * For information about MAC Security (MACsec) key considerations, see [MACsec pre-shared CKN/CAK key considerations ](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration) in the *Direct Connect User Guide*.
     */
    public suspend fun associateMacSecKey(input: AssociateMacSecKeyRequest): AssociateMacSecKeyResponse

    /**
     * Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address, the operation fails.
     *
     * Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must be migrated along with their virtual interfaces using AssociateHostedConnection.
     *
     * To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual interface itself or the connection to which the virtual interface is currently associated. Additionally, the requester must own the connection or LAG for the association.
     */
    public suspend fun associateVirtualInterface(input: AssociateVirtualInterfaceRequest): AssociateVirtualInterfaceResponse

    /**
     * Confirms the creation of the specified hosted connection on an interconnect.
     *
     * Upon creation, the hosted connection is initially in the `Ordering` state, and remains in this state until the owner confirms creation of the hosted connection.
     */
    public suspend fun confirmConnection(input: ConfirmConnectionRequest): ConfirmConnectionResponse

    /**
     * The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
     */
    public suspend fun confirmCustomerAgreement(input: ConfirmCustomerAgreementRequest = ConfirmCustomerAgreementRequest {}): ConfirmCustomerAgreementResponse

    /**
     * Accepts ownership of a private virtual interface created by another Amazon Web Services account.
     *
     * After the virtual interface owner makes this call, the virtual interface is created and attached to the specified virtual private gateway or Direct Connect gateway, and is made available to handle traffic.
     */
    public suspend fun confirmPrivateVirtualInterface(input: ConfirmPrivateVirtualInterfaceRequest): ConfirmPrivateVirtualInterfaceResponse

    /**
     * Accepts ownership of a public virtual interface created by another Amazon Web Services account.
     *
     * After the virtual interface owner makes this call, the specified virtual interface is created and made available to handle traffic.
     */
    public suspend fun confirmPublicVirtualInterface(input: ConfirmPublicVirtualInterfaceRequest): ConfirmPublicVirtualInterfaceResponse

    /**
     * Accepts ownership of a transit virtual interface created by another Amazon Web Services account.
     *
     *  After the owner of the transit virtual interface makes this call, the specified transit virtual interface is created and made available to handle traffic.
     */
    public suspend fun confirmTransitVirtualInterface(input: ConfirmTransitVirtualInterfaceRequest): ConfirmTransitVirtualInterfaceResponse

    /**
     * Creates a BGP peer on the specified virtual interface.
     *
     * You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web Services resources that also use that address family.
     *
     * If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the same address family as an existing BGP peer on the virtual interface.
     *
     * When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     *
     * For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list for the virtual interface.
     */
    public suspend fun createBgpPeer(input: CreateBgpPeerRequest = CreateBgpPeerRequest {}): CreateBgpPeerResponse

    /**
     * Creates a connection between a customer network and a specific Direct Connect location.
     *
     * A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end of the cable is connected to your router, the other to an Direct Connect router.
     *
     * To find the locations for your Region, use DescribeLocations.
     *
     * You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.
     */
    public suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse

    /**
     * Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web Services Region after it is created. The virtual interfaces and virtual private gateways that are connected through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic between them.
     */
    public suspend fun createDirectConnectGateway(input: CreateDirectConnectGatewayRequest): CreateDirectConnectGatewayResponse

    /**
     * Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
     */
    public suspend fun createDirectConnectGatewayAssociation(input: CreateDirectConnectGatewayAssociationRequest): CreateDirectConnectGatewayAssociationResponse

    /**
     * Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified Direct Connect gateway.
     *
     * You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any Amazon Web Services account.
     */
    public suspend fun createDirectConnectGatewayAssociationProposal(input: CreateDirectConnectGatewayAssociationProposalRequest): CreateDirectConnectGatewayAssociationProposalResponse

    /**
     * Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
     *
     * An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use an interconnect to provide Direct Connect hosted connections to customers through their own network services. Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect router.
     *
     * You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.
     *
     * For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling AllocateHostedConnection. The end customer can then connect to Amazon Web Services resources by creating a virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.
     *
     * Intended for use by Direct Connect Partners only.
     */
    public suspend fun createInterconnect(input: CreateInterconnectRequest): CreateInterconnectResponse

    /**
     * Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single interface.
     *
     * All connections in a LAG must use the same bandwidth (either 1Gbps or 10Gbps) and must terminate at the same Direct Connect endpoint.
     *
     * You can have up to 10 dedicated connections per LAG. Regardless of this limit, if you request more connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created.
     *
     * You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts towards the total number of connections). Doing so interrupts the current physical dedicated connection, and re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are automatically disassociated and re-associated with the LAG. The connection ID does not change.
     *
     * If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces cannot be directly configured.
     */
    public suspend fun createLag(input: CreateLagRequest): CreateLagResponse

    /**
     * Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW). Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface to a VGW only provides access to a single VPC within the same Region.
     *
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    public suspend fun createPrivateVirtualInterface(input: CreatePrivateVirtualInterfaceRequest): CreatePrivateVirtualInterfaceResponse

    /**
     * Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
     *
     * When creating an IPv6 public virtual interface (`addressFamily` is `ipv6`), leave the `customer` and `amazon` address fields blank to use auto-assigned IPv6 space. Custom IPv6 addresses are not supported.
     */
    public suspend fun createPublicVirtualInterface(input: CreatePublicVirtualInterfaceRequest): CreatePublicVirtualInterfaceResponse

    /**
     * Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple VPCs attached to a transit gateway to a Direct Connect gateway.
     *
     * If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.
     *
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    public suspend fun createTransitVirtualInterface(input: CreateTransitVirtualInterfaceRequest): CreateTransitVirtualInterfaceResponse

    /**
     * Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
     *
     * You cannot delete the last BGP peer from a virtual interface.
     */
    public suspend fun deleteBgpPeer(input: DeleteBgpPeerRequest = DeleteBgpPeerRequest {}): DeleteBgpPeerResponse

    /**
     * Deletes the specified connection.
     *
     * Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering with any third parties to connect with the Direct Connect location, you must cancel your service with them separately.
     */
    public suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect gateway.
     */
    public suspend fun deleteDirectConnectGateway(input: DeleteDirectConnectGatewayRequest): DeleteDirectConnectGatewayResponse

    /**
     * Deletes the association between the specified Direct Connect gateway and virtual private gateway.
     *
     * We recommend that you specify the `associationID` to delete the association. Alternatively, if you own virtual gateway and a Direct Connect gateway association, you can specify the `virtualGatewayId` and `directConnectGatewayId` to delete an association.
     */
    public suspend fun deleteDirectConnectGatewayAssociation(input: DeleteDirectConnectGatewayAssociationRequest = DeleteDirectConnectGatewayAssociationRequest {}): DeleteDirectConnectGatewayAssociationResponse

    /**
     * Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway or transit gateway.
     */
    public suspend fun deleteDirectConnectGatewayAssociationProposal(input: DeleteDirectConnectGatewayAssociationProposalRequest): DeleteDirectConnectGatewayAssociationProposalResponse

    /**
     * Deletes the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    public suspend fun deleteInterconnect(input: DeleteInterconnectRequest): DeleteInterconnectResponse

    /**
     * Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces or hosted connections.
     */
    public suspend fun deleteLag(input: DeleteLagRequest): DeleteLagResponse

    /**
     * Deletes a virtual interface.
     */
    public suspend fun deleteVirtualInterface(input: DeleteVirtualInterfaceRequest): DeleteVirtualInterfaceResponse

    /**
     * Deprecated. Use DescribeLoa instead.
     *
     * Gets the LOA-CFA for a connection.
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that your APN partner or service provider uses when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeConnectionLoa(input: DescribeConnectionLoaRequest): DescribeConnectionLoaResponse

    /**
     * Displays the specified connection or all connections in this Region.
     */
    public suspend fun describeConnections(input: DescribeConnectionsRequest = DescribeConnectionsRequest {}): DescribeConnectionsResponse

    /**
     * Deprecated. Use DescribeHostedConnections instead.
     *
     * Lists the connections that have been provisioned on the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeConnectionsOnInterconnect(input: DescribeConnectionsOnInterconnectRequest): DescribeConnectionsOnInterconnectResponse

    /**
     * Get and view a list of customer agreements, along with their signed status and whether the customer is an NNIPartner, NNIPartnerV2, or a nonPartner.
     */
    public suspend fun describeCustomerMetadata(input: DescribeCustomerMetadataRequest = DescribeCustomerMetadataRequest {}): DescribeCustomerMetadataResponse

    /**
     * Describes one or more association proposals for connection between a virtual private gateway or transit gateway and a Direct Connect gateway.
     */
    public suspend fun describeDirectConnectGatewayAssociationProposals(input: DescribeDirectConnectGatewayAssociationProposalsRequest = DescribeDirectConnectGatewayAssociationProposalsRequest {}): DescribeDirectConnectGatewayAssociationProposalsResponse

    /**
     * Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:
     * + A Direct Connect gatewayThe response contains all virtual private gateways and transit gateways associated with the Direct Connect gateway.
     * + A virtual private gatewayThe response contains the Direct Connect gateway.
     * + A transit gatewayThe response contains the Direct Connect gateway.
     * + A Direct Connect gateway and a virtual private gatewayThe response contains the association between the Direct Connect gateway and virtual private gateway.
     * + A Direct Connect gateway and a transit gatewayThe response contains the association between the Direct Connect gateway and transit gateway.
     */
    public suspend fun describeDirectConnectGatewayAssociations(input: DescribeDirectConnectGatewayAssociationsRequest = DescribeDirectConnectGatewayAssociationsRequest {}): DescribeDirectConnectGatewayAssociationsResponse

    /**
     * Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response contains the attachment between the Direct Connect gateway and the virtual interface.
     */
    public suspend fun describeDirectConnectGatewayAttachments(input: DescribeDirectConnectGatewayAttachmentsRequest = DescribeDirectConnectGatewayAttachmentsRequest {}): DescribeDirectConnectGatewayAttachmentsResponse

    /**
     * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect gateways are not returned.
     */
    public suspend fun describeDirectConnectGateways(input: DescribeDirectConnectGatewaysRequest = DescribeDirectConnectGatewaysRequest {}): DescribeDirectConnectGatewaysResponse

    /**
     * Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group (LAG).
     *
     * Intended for use by Direct Connect Partners only.
     */
    public suspend fun describeHostedConnections(input: DescribeHostedConnectionsRequest): DescribeHostedConnectionsResponse

    /**
     * Deprecated. Use DescribeLoa instead.
     *
     * Gets the LOA-CFA for the specified interconnect.
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeInterconnectLoa(input: DescribeInterconnectLoaRequest): DescribeInterconnectLoaResponse

    /**
     * Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
     */
    public suspend fun describeInterconnects(input: DescribeInterconnectsRequest = DescribeInterconnectsRequest {}): DescribeInterconnectsResponse

    /**
     * Describes all your link aggregation groups (LAG) or the specified LAG.
     */
    public suspend fun describeLags(input: DescribeLagsRequest = DescribeLagsRequest {}): DescribeLagsResponse

    /**
     * Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    public suspend fun describeLoa(input: DescribeLoaRequest): DescribeLoaResponse

    /**
     * Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be selected when calling CreateConnection or CreateInterconnect.
     */
    public suspend fun describeLocations(input: DescribeLocationsRequest = DescribeLocationsRequest {}): DescribeLocationsResponse

    /**
     * Details about the router.
     */
    public suspend fun describeRouterConfiguration(input: DescribeRouterConfigurationRequest): DescribeRouterConfigurationResponse

    /**
     * Describes the tags associated with the specified Direct Connect resources.
     */
    public suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Lists the virtual private gateways owned by the Amazon Web Services account.
     *
     * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
     */
    public suspend fun describeVirtualGateways(input: DescribeVirtualGatewaysRequest = DescribeVirtualGatewaysRequest {}): DescribeVirtualGatewaysResponse

    /**
     * Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15 minutes before you make the request are also returned. If you specify a connection ID, only the virtual interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single virtual interface is returned.
     *
     * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
     */
    public suspend fun describeVirtualInterfaces(input: DescribeVirtualInterfacesRequest = DescribeVirtualInterfacesRequest {}): DescribeVirtualInterfacesResponse

    /**
     * Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established as a standalone connection (the connection is not deleted; to delete the connection, use the DeleteConnection request). If the LAG has associated virtual interfaces or hosted connections, they remain associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted to an interconnect.
     *
     * If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational connections, the request fails, except when it's the last member of the LAG. If all connections are disassociated, the LAG continues to exist as an empty LAG with no physical connections.
     */
    public suspend fun disassociateConnectionFromLag(input: DisassociateConnectionFromLagRequest): DisassociateConnectionFromLagResponse

    /**
     * Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.
     */
    public suspend fun disassociateMacSecKey(input: DisassociateMacSecKeyRequest): DisassociateMacSecKeyResponse

    /**
     * Lists the virtual interface failover test history.
     */
    public suspend fun listVirtualInterfaceTestHistory(input: ListVirtualInterfaceTestHistoryRequest = ListVirtualInterfaceTestHistoryRequest {}): ListVirtualInterfaceTestHistoryResponse

    /**
     * Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
     *
     * You can run the test on public, private, transit, and hosted virtual interfaces.
     *
     * You can use [ListVirtualInterfaceTestHistory](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html) to view the virtual interface test history.
     *
     * If you need to stop the test before the test interval completes, use [StopBgpFailoverTest](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html).
     */
    public suspend fun startBgpFailoverTest(input: StartBgpFailoverTestRequest): StartBgpFailoverTestResponse

    /**
     * Stops the virtual interface failover test.
     */
    public suspend fun stopBgpFailoverTest(input: StopBgpFailoverTestRequest): StopBgpFailoverTestResponse

    /**
     * Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified Direct Connect resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the Direct Connect dedicated connection configuration.
     *
     * You can update the following parameters for a connection:
     * + The connection name
     * + The connection's MAC Security (MACsec) encryption mode.
     */
    public suspend fun updateConnection(input: UpdateConnectionRequest): UpdateConnectionResponse

    /**
     * Updates the name of a current Direct Connect gateway.
     */
    public suspend fun updateDirectConnectGateway(input: UpdateDirectConnectGatewayRequest): UpdateDirectConnectGatewayResponse

    /**
     * Updates the specified attributes of the Direct Connect gateway association.
     *
     * Add or remove prefixes from the association.
     */
    public suspend fun updateDirectConnectGatewayAssociation(input: UpdateDirectConnectGatewayAssociationRequest = UpdateDirectConnectGatewayAssociationRequest {}): UpdateDirectConnectGatewayAssociationResponse

    /**
     * Updates the attributes of the specified link aggregation group (LAG).
     *
     * You can update the following LAG attributes:
     * + The name of the LAG.
     * + The value for the minimum number of connections that must be operational for the LAG itself to be operational.
     * + The LAG's MACsec encryption mode.Amazon Web Services assigns this value to each connection which is part of the LAG.
     * + The tags
     *
     * If you adjust the threshold value for the minimum number of operational connections, ensure that the new value does not cause the LAG to fall below the threshold and become non-operational.
     */
    public suspend fun updateLag(input: UpdateLagRequest): UpdateLagResponse

    /**
     * Updates the specified attributes of the specified virtual private interface.
     *
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual q interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    public suspend fun updateVirtualInterfaceAttributes(input: UpdateVirtualInterfaceAttributesRequest): UpdateVirtualInterfaceAttributesResponse
}

/**
 * Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
 */
public suspend inline fun DirectConnectClient.acceptDirectConnectGatewayAssociationProposal(crossinline block: AcceptDirectConnectGatewayAssociationProposalRequest.Builder.() -> Unit): AcceptDirectConnectGatewayAssociationProposalResponse = acceptDirectConnectGatewayAssociationProposal(AcceptDirectConnectGatewayAssociationProposalRequest.Builder().apply(block).build())

/**
 * Deprecated. Use AllocateHostedConnection instead.
 *
 * Creates a hosted connection on an interconnect.
 *
 * Allocates a VLAN number and a specified amount of bandwidth for use by a hosted connection on the specified interconnect.
 *
 * Intended for use by Direct Connect Partners only.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun DirectConnectClient.allocateConnectionOnInterconnect(crossinline block: AllocateConnectionOnInterconnectRequest.Builder.() -> Unit): AllocateConnectionOnInterconnectResponse = allocateConnectionOnInterconnect(AllocateConnectionOnInterconnectRequest.Builder().apply(block).build())

/**
 * Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
 *
 * Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the specified capacity and the Direct Connect Partner must also police the hosted connection for the specified capacity.
 *
 * Intended for use by Direct Connect Partners only.
 */
public suspend inline fun DirectConnectClient.allocateHostedConnection(crossinline block: AllocateHostedConnectionRequest.Builder.() -> Unit): AllocateHostedConnectionResponse = allocateHostedConnection(AllocateHostedConnectionRequest.Builder().apply(block).build())

/**
 * Provisions a private virtual interface to be owned by the specified Amazon Web Services account.
 *
 * Virtual interfaces created using this action must be confirmed by the owner using ConfirmPrivateVirtualInterface. Until then, the virtual interface is in the `Confirming` state and is not available to handle traffic.
 */
public suspend inline fun DirectConnectClient.allocatePrivateVirtualInterface(crossinline block: AllocatePrivateVirtualInterfaceRequest.Builder.() -> Unit): AllocatePrivateVirtualInterfaceResponse = allocatePrivateVirtualInterface(AllocatePrivateVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Provisions a public virtual interface to be owned by the specified Amazon Web Services account.
 *
 * The owner of a connection calls this function to provision a public virtual interface to be owned by the specified Amazon Web Services account.
 *
 * Virtual interfaces created using this function must be confirmed by the owner using ConfirmPublicVirtualInterface. Until this step has been completed, the virtual interface is in the `confirming` state and is not available to handle traffic.
 *
 * When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
 */
public suspend inline fun DirectConnectClient.allocatePublicVirtualInterface(crossinline block: AllocatePublicVirtualInterfaceRequest.Builder.() -> Unit): AllocatePublicVirtualInterfaceResponse = allocatePublicVirtualInterface(AllocatePublicVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of interface to connect a transit gateway to your Direct Connect gateway.
 *
 * The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services account.
 *
 * After you create a transit virtual interface, it must be confirmed by the owner using ConfirmTransitVirtualInterface. Until this step has been completed, the transit virtual interface is in the `requested` state and is not available to handle traffic.
 */
public suspend inline fun DirectConnectClient.allocateTransitVirtualInterface(crossinline block: AllocateTransitVirtualInterfaceRequest.Builder.() -> Unit): AllocateTransitVirtualInterfaceResponse = allocateTransitVirtualInterface(AllocateTransitVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG. You can re-associate a connection that's currently associated with a different LAG; however, if removing the connection would cause the original LAG to fall below its setting for minimum number of operational connections, the request fails.
 *
 * Any virtual interfaces that are directly associated with the connection are automatically re-associated with the LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated with the original LAG.
 *
 * For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was originally associated with a different LAG, the hosted connections remain associated with the original LAG.
 */
public suspend inline fun DirectConnectClient.associateConnectionWithLag(crossinline block: AssociateConnectionWithLagRequest.Builder.() -> Unit): AssociateConnectionWithLagResponse = associateConnectionWithLag(AssociateConnectionWithLagRequest.Builder().apply(block).build())

/**
 * Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address, the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web Services as it is being migrated.
 *
 * Intended for use by Direct Connect Partners only.
 */
public suspend inline fun DirectConnectClient.associateHostedConnection(crossinline block: AssociateHostedConnectionRequest.Builder.() -> Unit): AssociateHostedConnectionResponse = associateHostedConnection(AssociateHostedConnectionRequest.Builder().apply(block).build())

/**
 * Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection.
 *
 * You must supply either the `secretARN,` or the CKN/CAK (`ckn` and `cak`) pair in the request.
 *
 * For information about MAC Security (MACsec) key considerations, see [MACsec pre-shared CKN/CAK key considerations ](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration) in the *Direct Connect User Guide*.
 */
public suspend inline fun DirectConnectClient.associateMacSecKey(crossinline block: AssociateMacSecKeyRequest.Builder.() -> Unit): AssociateMacSecKeyResponse = associateMacSecKey(AssociateMacSecKeyRequest.Builder().apply(block).build())

/**
 * Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address, the operation fails.
 *
 * Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must be migrated along with their virtual interfaces using AssociateHostedConnection.
 *
 * To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual interface itself or the connection to which the virtual interface is currently associated. Additionally, the requester must own the connection or LAG for the association.
 */
public suspend inline fun DirectConnectClient.associateVirtualInterface(crossinline block: AssociateVirtualInterfaceRequest.Builder.() -> Unit): AssociateVirtualInterfaceResponse = associateVirtualInterface(AssociateVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Confirms the creation of the specified hosted connection on an interconnect.
 *
 * Upon creation, the hosted connection is initially in the `Ordering` state, and remains in this state until the owner confirms creation of the hosted connection.
 */
public suspend inline fun DirectConnectClient.confirmConnection(crossinline block: ConfirmConnectionRequest.Builder.() -> Unit): ConfirmConnectionResponse = confirmConnection(ConfirmConnectionRequest.Builder().apply(block).build())

/**
 * The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
 */
public suspend inline fun DirectConnectClient.confirmCustomerAgreement(crossinline block: ConfirmCustomerAgreementRequest.Builder.() -> Unit): ConfirmCustomerAgreementResponse = confirmCustomerAgreement(ConfirmCustomerAgreementRequest.Builder().apply(block).build())

/**
 * Accepts ownership of a private virtual interface created by another Amazon Web Services account.
 *
 * After the virtual interface owner makes this call, the virtual interface is created and attached to the specified virtual private gateway or Direct Connect gateway, and is made available to handle traffic.
 */
public suspend inline fun DirectConnectClient.confirmPrivateVirtualInterface(crossinline block: ConfirmPrivateVirtualInterfaceRequest.Builder.() -> Unit): ConfirmPrivateVirtualInterfaceResponse = confirmPrivateVirtualInterface(ConfirmPrivateVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Accepts ownership of a public virtual interface created by another Amazon Web Services account.
 *
 * After the virtual interface owner makes this call, the specified virtual interface is created and made available to handle traffic.
 */
public suspend inline fun DirectConnectClient.confirmPublicVirtualInterface(crossinline block: ConfirmPublicVirtualInterfaceRequest.Builder.() -> Unit): ConfirmPublicVirtualInterfaceResponse = confirmPublicVirtualInterface(ConfirmPublicVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Accepts ownership of a transit virtual interface created by another Amazon Web Services account.
 *
 *  After the owner of the transit virtual interface makes this call, the specified transit virtual interface is created and made available to handle traffic.
 */
public suspend inline fun DirectConnectClient.confirmTransitVirtualInterface(crossinline block: ConfirmTransitVirtualInterfaceRequest.Builder.() -> Unit): ConfirmTransitVirtualInterfaceResponse = confirmTransitVirtualInterface(ConfirmTransitVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Creates a BGP peer on the specified virtual interface.
 *
 * You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web Services resources that also use that address family.
 *
 * If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the same address family as an existing BGP peer on the virtual interface.
 *
 * When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
 *
 * For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list for the virtual interface.
 */
public suspend inline fun DirectConnectClient.createBgpPeer(crossinline block: CreateBgpPeerRequest.Builder.() -> Unit): CreateBgpPeerResponse = createBgpPeer(CreateBgpPeerRequest.Builder().apply(block).build())

/**
 * Creates a connection between a customer network and a specific Direct Connect location.
 *
 * A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end of the cable is connected to your router, the other to an Direct Connect router.
 *
 * To find the locations for your Region, use DescribeLocations.
 *
 * You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.
 */
public suspend inline fun DirectConnectClient.createConnection(crossinline block: CreateConnectionRequest.Builder.() -> Unit): CreateConnectionResponse = createConnection(CreateConnectionRequest.Builder().apply(block).build())

/**
 * Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web Services Region after it is created. The virtual interfaces and virtual private gateways that are connected through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic between them.
 */
public suspend inline fun DirectConnectClient.createDirectConnectGateway(crossinline block: CreateDirectConnectGatewayRequest.Builder.() -> Unit): CreateDirectConnectGatewayResponse = createDirectConnectGateway(CreateDirectConnectGatewayRequest.Builder().apply(block).build())

/**
 * Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
 */
public suspend inline fun DirectConnectClient.createDirectConnectGatewayAssociation(crossinline block: CreateDirectConnectGatewayAssociationRequest.Builder.() -> Unit): CreateDirectConnectGatewayAssociationResponse = createDirectConnectGatewayAssociation(CreateDirectConnectGatewayAssociationRequest.Builder().apply(block).build())

/**
 * Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified Direct Connect gateway.
 *
 * You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any Amazon Web Services account.
 */
public suspend inline fun DirectConnectClient.createDirectConnectGatewayAssociationProposal(crossinline block: CreateDirectConnectGatewayAssociationProposalRequest.Builder.() -> Unit): CreateDirectConnectGatewayAssociationProposalResponse = createDirectConnectGatewayAssociationProposal(CreateDirectConnectGatewayAssociationProposalRequest.Builder().apply(block).build())

/**
 * Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
 *
 * An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use an interconnect to provide Direct Connect hosted connections to customers through their own network services. Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect router.
 *
 * You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.
 *
 * For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling AllocateHostedConnection. The end customer can then connect to Amazon Web Services resources by creating a virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.
 *
 * Intended for use by Direct Connect Partners only.
 */
public suspend inline fun DirectConnectClient.createInterconnect(crossinline block: CreateInterconnectRequest.Builder.() -> Unit): CreateInterconnectResponse = createInterconnect(CreateInterconnectRequest.Builder().apply(block).build())

/**
 * Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single interface.
 *
 * All connections in a LAG must use the same bandwidth (either 1Gbps or 10Gbps) and must terminate at the same Direct Connect endpoint.
 *
 * You can have up to 10 dedicated connections per LAG. Regardless of this limit, if you request more connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created.
 *
 * You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts towards the total number of connections). Doing so interrupts the current physical dedicated connection, and re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are automatically disassociated and re-associated with the LAG. The connection ID does not change.
 *
 * If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces cannot be directly configured.
 */
public suspend inline fun DirectConnectClient.createLag(crossinline block: CreateLagRequest.Builder.() -> Unit): CreateLagResponse = createLag(CreateLagRequest.Builder().apply(block).build())

/**
 * Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW). Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface to a VGW only provides access to a single VPC within the same Region.
 *
 * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
 */
public suspend inline fun DirectConnectClient.createPrivateVirtualInterface(crossinline block: CreatePrivateVirtualInterfaceRequest.Builder.() -> Unit): CreatePrivateVirtualInterfaceResponse = createPrivateVirtualInterface(CreatePrivateVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
 *
 * When creating an IPv6 public virtual interface (`addressFamily` is `ipv6`), leave the `customer` and `amazon` address fields blank to use auto-assigned IPv6 space. Custom IPv6 addresses are not supported.
 */
public suspend inline fun DirectConnectClient.createPublicVirtualInterface(crossinline block: CreatePublicVirtualInterfaceRequest.Builder.() -> Unit): CreatePublicVirtualInterfaceResponse = createPublicVirtualInterface(CreatePublicVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple VPCs attached to a transit gateway to a Direct Connect gateway.
 *
 * If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.
 *
 * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
 */
public suspend inline fun DirectConnectClient.createTransitVirtualInterface(crossinline block: CreateTransitVirtualInterfaceRequest.Builder.() -> Unit): CreateTransitVirtualInterfaceResponse = createTransitVirtualInterface(CreateTransitVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
 *
 * You cannot delete the last BGP peer from a virtual interface.
 */
public suspend inline fun DirectConnectClient.deleteBgpPeer(crossinline block: DeleteBgpPeerRequest.Builder.() -> Unit): DeleteBgpPeerResponse = deleteBgpPeer(DeleteBgpPeerRequest.Builder().apply(block).build())

/**
 * Deletes the specified connection.
 *
 * Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering with any third parties to connect with the Direct Connect location, you must cancel your service with them separately.
 */
public suspend inline fun DirectConnectClient.deleteConnection(crossinline block: DeleteConnectionRequest.Builder.() -> Unit): DeleteConnectionResponse = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

/**
 * Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect gateway.
 */
public suspend inline fun DirectConnectClient.deleteDirectConnectGateway(crossinline block: DeleteDirectConnectGatewayRequest.Builder.() -> Unit): DeleteDirectConnectGatewayResponse = deleteDirectConnectGateway(DeleteDirectConnectGatewayRequest.Builder().apply(block).build())

/**
 * Deletes the association between the specified Direct Connect gateway and virtual private gateway.
 *
 * We recommend that you specify the `associationID` to delete the association. Alternatively, if you own virtual gateway and a Direct Connect gateway association, you can specify the `virtualGatewayId` and `directConnectGatewayId` to delete an association.
 */
public suspend inline fun DirectConnectClient.deleteDirectConnectGatewayAssociation(crossinline block: DeleteDirectConnectGatewayAssociationRequest.Builder.() -> Unit): DeleteDirectConnectGatewayAssociationResponse = deleteDirectConnectGatewayAssociation(DeleteDirectConnectGatewayAssociationRequest.Builder().apply(block).build())

/**
 * Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway or transit gateway.
 */
public suspend inline fun DirectConnectClient.deleteDirectConnectGatewayAssociationProposal(crossinline block: DeleteDirectConnectGatewayAssociationProposalRequest.Builder.() -> Unit): DeleteDirectConnectGatewayAssociationProposalResponse = deleteDirectConnectGatewayAssociationProposal(DeleteDirectConnectGatewayAssociationProposalRequest.Builder().apply(block).build())

/**
 * Deletes the specified interconnect.
 *
 * Intended for use by Direct Connect Partners only.
 */
public suspend inline fun DirectConnectClient.deleteInterconnect(crossinline block: DeleteInterconnectRequest.Builder.() -> Unit): DeleteInterconnectResponse = deleteInterconnect(DeleteInterconnectRequest.Builder().apply(block).build())

/**
 * Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces or hosted connections.
 */
public suspend inline fun DirectConnectClient.deleteLag(crossinline block: DeleteLagRequest.Builder.() -> Unit): DeleteLagResponse = deleteLag(DeleteLagRequest.Builder().apply(block).build())

/**
 * Deletes a virtual interface.
 */
public suspend inline fun DirectConnectClient.deleteVirtualInterface(crossinline block: DeleteVirtualInterfaceRequest.Builder.() -> Unit): DeleteVirtualInterfaceResponse = deleteVirtualInterface(DeleteVirtualInterfaceRequest.Builder().apply(block).build())

/**
 * Deprecated. Use DescribeLoa instead.
 *
 * Gets the LOA-CFA for a connection.
 *
 * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that your APN partner or service provider uses when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun DirectConnectClient.describeConnectionLoa(crossinline block: DescribeConnectionLoaRequest.Builder.() -> Unit): DescribeConnectionLoaResponse = describeConnectionLoa(DescribeConnectionLoaRequest.Builder().apply(block).build())

/**
 * Displays the specified connection or all connections in this Region.
 */
public suspend inline fun DirectConnectClient.describeConnections(crossinline block: DescribeConnectionsRequest.Builder.() -> Unit): DescribeConnectionsResponse = describeConnections(DescribeConnectionsRequest.Builder().apply(block).build())

/**
 * Deprecated. Use DescribeHostedConnections instead.
 *
 * Lists the connections that have been provisioned on the specified interconnect.
 *
 * Intended for use by Direct Connect Partners only.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun DirectConnectClient.describeConnectionsOnInterconnect(crossinline block: DescribeConnectionsOnInterconnectRequest.Builder.() -> Unit): DescribeConnectionsOnInterconnectResponse = describeConnectionsOnInterconnect(DescribeConnectionsOnInterconnectRequest.Builder().apply(block).build())

/**
 * Get and view a list of customer agreements, along with their signed status and whether the customer is an NNIPartner, NNIPartnerV2, or a nonPartner.
 */
public suspend inline fun DirectConnectClient.describeCustomerMetadata(crossinline block: DescribeCustomerMetadataRequest.Builder.() -> Unit): DescribeCustomerMetadataResponse = describeCustomerMetadata(DescribeCustomerMetadataRequest.Builder().apply(block).build())

/**
 * Describes one or more association proposals for connection between a virtual private gateway or transit gateway and a Direct Connect gateway.
 */
public suspend inline fun DirectConnectClient.describeDirectConnectGatewayAssociationProposals(crossinline block: DescribeDirectConnectGatewayAssociationProposalsRequest.Builder.() -> Unit): DescribeDirectConnectGatewayAssociationProposalsResponse = describeDirectConnectGatewayAssociationProposals(DescribeDirectConnectGatewayAssociationProposalsRequest.Builder().apply(block).build())

/**
 * Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:
 * + A Direct Connect gatewayThe response contains all virtual private gateways and transit gateways associated with the Direct Connect gateway.
 * + A virtual private gatewayThe response contains the Direct Connect gateway.
 * + A transit gatewayThe response contains the Direct Connect gateway.
 * + A Direct Connect gateway and a virtual private gatewayThe response contains the association between the Direct Connect gateway and virtual private gateway.
 * + A Direct Connect gateway and a transit gatewayThe response contains the association between the Direct Connect gateway and transit gateway.
 */
public suspend inline fun DirectConnectClient.describeDirectConnectGatewayAssociations(crossinline block: DescribeDirectConnectGatewayAssociationsRequest.Builder.() -> Unit): DescribeDirectConnectGatewayAssociationsResponse = describeDirectConnectGatewayAssociations(DescribeDirectConnectGatewayAssociationsRequest.Builder().apply(block).build())

/**
 * Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response contains the attachment between the Direct Connect gateway and the virtual interface.
 */
public suspend inline fun DirectConnectClient.describeDirectConnectGatewayAttachments(crossinline block: DescribeDirectConnectGatewayAttachmentsRequest.Builder.() -> Unit): DescribeDirectConnectGatewayAttachmentsResponse = describeDirectConnectGatewayAttachments(DescribeDirectConnectGatewayAttachmentsRequest.Builder().apply(block).build())

/**
 * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect gateways are not returned.
 */
public suspend inline fun DirectConnectClient.describeDirectConnectGateways(crossinline block: DescribeDirectConnectGatewaysRequest.Builder.() -> Unit): DescribeDirectConnectGatewaysResponse = describeDirectConnectGateways(DescribeDirectConnectGatewaysRequest.Builder().apply(block).build())

/**
 * Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group (LAG).
 *
 * Intended for use by Direct Connect Partners only.
 */
public suspend inline fun DirectConnectClient.describeHostedConnections(crossinline block: DescribeHostedConnectionsRequest.Builder.() -> Unit): DescribeHostedConnectionsResponse = describeHostedConnections(DescribeHostedConnectionsRequest.Builder().apply(block).build())

/**
 * Deprecated. Use DescribeLoa instead.
 *
 * Gets the LOA-CFA for the specified interconnect.
 *
 * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun DirectConnectClient.describeInterconnectLoa(crossinline block: DescribeInterconnectLoaRequest.Builder.() -> Unit): DescribeInterconnectLoaResponse = describeInterconnectLoa(DescribeInterconnectLoaRequest.Builder().apply(block).build())

/**
 * Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
 */
public suspend inline fun DirectConnectClient.describeInterconnects(crossinline block: DescribeInterconnectsRequest.Builder.() -> Unit): DescribeInterconnectsResponse = describeInterconnects(DescribeInterconnectsRequest.Builder().apply(block).build())

/**
 * Describes all your link aggregation groups (LAG) or the specified LAG.
 */
public suspend inline fun DirectConnectClient.describeLags(crossinline block: DescribeLagsRequest.Builder.() -> Unit): DescribeLagsResponse = describeLags(DescribeLagsRequest.Builder().apply(block).build())

/**
 * Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
 *
 * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
 */
public suspend inline fun DirectConnectClient.describeLoa(crossinline block: DescribeLoaRequest.Builder.() -> Unit): DescribeLoaResponse = describeLoa(DescribeLoaRequest.Builder().apply(block).build())

/**
 * Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be selected when calling CreateConnection or CreateInterconnect.
 */
public suspend inline fun DirectConnectClient.describeLocations(crossinline block: DescribeLocationsRequest.Builder.() -> Unit): DescribeLocationsResponse = describeLocations(DescribeLocationsRequest.Builder().apply(block).build())

/**
 * Details about the router.
 */
public suspend inline fun DirectConnectClient.describeRouterConfiguration(crossinline block: DescribeRouterConfigurationRequest.Builder.() -> Unit): DescribeRouterConfigurationResponse = describeRouterConfiguration(DescribeRouterConfigurationRequest.Builder().apply(block).build())

/**
 * Describes the tags associated with the specified Direct Connect resources.
 */
public suspend inline fun DirectConnectClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Lists the virtual private gateways owned by the Amazon Web Services account.
 *
 * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
 */
public suspend inline fun DirectConnectClient.describeVirtualGateways(crossinline block: DescribeVirtualGatewaysRequest.Builder.() -> Unit): DescribeVirtualGatewaysResponse = describeVirtualGateways(DescribeVirtualGatewaysRequest.Builder().apply(block).build())

/**
 * Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15 minutes before you make the request are also returned. If you specify a connection ID, only the virtual interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single virtual interface is returned.
 *
 * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
 */
public suspend inline fun DirectConnectClient.describeVirtualInterfaces(crossinline block: DescribeVirtualInterfacesRequest.Builder.() -> Unit): DescribeVirtualInterfacesResponse = describeVirtualInterfaces(DescribeVirtualInterfacesRequest.Builder().apply(block).build())

/**
 * Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established as a standalone connection (the connection is not deleted; to delete the connection, use the DeleteConnection request). If the LAG has associated virtual interfaces or hosted connections, they remain associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted to an interconnect.
 *
 * If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational connections, the request fails, except when it's the last member of the LAG. If all connections are disassociated, the LAG continues to exist as an empty LAG with no physical connections.
 */
public suspend inline fun DirectConnectClient.disassociateConnectionFromLag(crossinline block: DisassociateConnectionFromLagRequest.Builder.() -> Unit): DisassociateConnectionFromLagResponse = disassociateConnectionFromLag(DisassociateConnectionFromLagRequest.Builder().apply(block).build())

/**
 * Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.
 */
public suspend inline fun DirectConnectClient.disassociateMacSecKey(crossinline block: DisassociateMacSecKeyRequest.Builder.() -> Unit): DisassociateMacSecKeyResponse = disassociateMacSecKey(DisassociateMacSecKeyRequest.Builder().apply(block).build())

/**
 * Lists the virtual interface failover test history.
 */
public suspend inline fun DirectConnectClient.listVirtualInterfaceTestHistory(crossinline block: ListVirtualInterfaceTestHistoryRequest.Builder.() -> Unit): ListVirtualInterfaceTestHistoryResponse = listVirtualInterfaceTestHistory(ListVirtualInterfaceTestHistoryRequest.Builder().apply(block).build())

/**
 * Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
 *
 * You can run the test on public, private, transit, and hosted virtual interfaces.
 *
 * You can use [ListVirtualInterfaceTestHistory](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html) to view the virtual interface test history.
 *
 * If you need to stop the test before the test interval completes, use [StopBgpFailoverTest](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html).
 */
public suspend inline fun DirectConnectClient.startBgpFailoverTest(crossinline block: StartBgpFailoverTestRequest.Builder.() -> Unit): StartBgpFailoverTestResponse = startBgpFailoverTest(StartBgpFailoverTestRequest.Builder().apply(block).build())

/**
 * Stops the virtual interface failover test.
 */
public suspend inline fun DirectConnectClient.stopBgpFailoverTest(crossinline block: StopBgpFailoverTestRequest.Builder.() -> Unit): StopBgpFailoverTestResponse = stopBgpFailoverTest(StopBgpFailoverTestRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
 *
 * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.
 */
public suspend inline fun DirectConnectClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified Direct Connect resource.
 */
public suspend inline fun DirectConnectClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the Direct Connect dedicated connection configuration.
 *
 * You can update the following parameters for a connection:
 * + The connection name
 * + The connection's MAC Security (MACsec) encryption mode.
 */
public suspend inline fun DirectConnectClient.updateConnection(crossinline block: UpdateConnectionRequest.Builder.() -> Unit): UpdateConnectionResponse = updateConnection(UpdateConnectionRequest.Builder().apply(block).build())

/**
 * Updates the name of a current Direct Connect gateway.
 */
public suspend inline fun DirectConnectClient.updateDirectConnectGateway(crossinline block: UpdateDirectConnectGatewayRequest.Builder.() -> Unit): UpdateDirectConnectGatewayResponse = updateDirectConnectGateway(UpdateDirectConnectGatewayRequest.Builder().apply(block).build())

/**
 * Updates the specified attributes of the Direct Connect gateway association.
 *
 * Add or remove prefixes from the association.
 */
public suspend inline fun DirectConnectClient.updateDirectConnectGatewayAssociation(crossinline block: UpdateDirectConnectGatewayAssociationRequest.Builder.() -> Unit): UpdateDirectConnectGatewayAssociationResponse = updateDirectConnectGatewayAssociation(UpdateDirectConnectGatewayAssociationRequest.Builder().apply(block).build())

/**
 * Updates the attributes of the specified link aggregation group (LAG).
 *
 * You can update the following LAG attributes:
 * + The name of the LAG.
 * + The value for the minimum number of connections that must be operational for the LAG itself to be operational.
 * + The LAG's MACsec encryption mode.Amazon Web Services assigns this value to each connection which is part of the LAG.
 * + The tags
 *
 * If you adjust the threshold value for the minimum number of operational connections, ensure that the new value does not cause the LAG to fall below the threshold and become non-operational.
 */
public suspend inline fun DirectConnectClient.updateLag(crossinline block: UpdateLagRequest.Builder.() -> Unit): UpdateLagResponse = updateLag(UpdateLagRequest.Builder().apply(block).build())

/**
 * Updates the specified attributes of the specified virtual private interface.
 *
 * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual q interface supports jumbo frames, call DescribeVirtualInterfaces.
 */
public suspend inline fun DirectConnectClient.updateVirtualInterfaceAttributes(crossinline block: UpdateVirtualInterfaceAttributesRequest.Builder.() -> Unit): UpdateVirtualInterfaceAttributesResponse = updateVirtualInterfaceAttributes(UpdateVirtualInterfaceAttributesRequest.Builder().apply(block).build())
