// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an Direct Connect connection.
 */
public class AssociateHostedConnectionResponse private constructor(builder: Builder) {
    /**
     * The Direct Connect endpoint on which the physical connection terminates.
     */
    public val awsDevice: kotlin.String? = builder.awsDevice
    /**
     * The Direct Connect endpoint that terminates the physical connection.
     */
    public val awsDeviceV2: kotlin.String? = builder.awsDeviceV2
    /**
     * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
     */
    public val awsLogicalDeviceId: kotlin.String? = builder.awsLogicalDeviceId
    /**
     * The bandwidth of the connection.
     */
    public val bandwidth: kotlin.String? = builder.bandwidth
    /**
     * The ID of the connection.
     */
    public val connectionId: kotlin.String? = builder.connectionId
    /**
     * The name of the connection.
     */
    public val connectionName: kotlin.String? = builder.connectionName
    /**
     * The state of the connection. The following are the possible values:
     * + `ordering`: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.
     * + `requested`: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.
     * + `pending`: The connection has been approved and is being initialized.
     * + `available`: The network link is up and the connection is ready for use.
     * + `down`: The network link is down.
     * + `deleting`: The connection is being deleted.
     * + `deleted`: The connection has been deleted.
     * + `rejected`: A hosted connection in the `ordering` state enters the `rejected` state if it is deleted by the customer.
     * + `unknown`: The state of the connection is not available.
     */
    public val connectionState: aws.sdk.kotlin.services.directconnect.model.ConnectionState? = builder.connectionState
    /**
     * The MAC Security (MACsec) connection encryption mode.
     *
     * The valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
     */
    public val encryptionMode: kotlin.String? = builder.encryptionMode
    /**
     * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
     */
    public val hasLogicalRedundancy: aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy? = builder.hasLogicalRedundancy
    /**
     * Indicates whether jumbo frames (9001 MTU) are supported.
     */
    public val jumboFrameCapable: kotlin.Boolean? = builder.jumboFrameCapable
    /**
     * The ID of the LAG.
     */
    public val lagId: kotlin.String? = builder.lagId
    /**
     * The time of the most recent call to DescribeLoa for this connection.
     */
    public val loaIssueTime: aws.smithy.kotlin.runtime.time.Instant? = builder.loaIssueTime
    /**
     * The location of the connection.
     */
    public val location: kotlin.String? = builder.location
    /**
     * Indicates whether the connection supports MAC Security (MACsec).
     */
    public val macSecCapable: kotlin.Boolean? = builder.macSecCapable
    /**
     * The MAC Security (MACsec) security keys associated with the connection.
     */
    public val macSecKeys: List<MacSecKey>? = builder.macSecKeys
    /**
     * The ID of the Amazon Web Services account that owns the connection.
     */
    public val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The name of the Direct Connect service provider associated with the connection.
     */
    public val partnerName: kotlin.String? = builder.partnerName
    /**
     * The MAC Security (MACsec) port link status of the connection.
     *
     * The valid values are `Encryption Up`, which means that there is an active Connection Key Name, or `Encryption Down`.
     */
    public val portEncryptionStatus: kotlin.String? = builder.portEncryptionStatus
    /**
     * The name of the service provider associated with the connection.
     */
    public val providerName: kotlin.String? = builder.providerName
    /**
     * The Amazon Web Services Region where the connection is located.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The tags associated with the connection.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VLAN.
     */
    public val vlan: kotlin.Int = builder.vlan

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.AssociateHostedConnectionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateHostedConnectionResponse(")
        append("awsDevice=$awsDevice,")
        append("awsDeviceV2=$awsDeviceV2,")
        append("awsLogicalDeviceId=$awsLogicalDeviceId,")
        append("bandwidth=$bandwidth,")
        append("connectionId=$connectionId,")
        append("connectionName=$connectionName,")
        append("connectionState=$connectionState,")
        append("encryptionMode=$encryptionMode,")
        append("hasLogicalRedundancy=$hasLogicalRedundancy,")
        append("jumboFrameCapable=$jumboFrameCapable,")
        append("lagId=$lagId,")
        append("loaIssueTime=$loaIssueTime,")
        append("location=$location,")
        append("macSecCapable=$macSecCapable,")
        append("macSecKeys=$macSecKeys,")
        append("ownerAccount=$ownerAccount,")
        append("partnerName=$partnerName,")
        append("portEncryptionStatus=$portEncryptionStatus,")
        append("providerName=$providerName,")
        append("region=$region,")
        append("tags=$tags,")
        append("vlan=$vlan)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsDevice?.hashCode() ?: 0
        result = 31 * result + (awsDeviceV2?.hashCode() ?: 0)
        result = 31 * result + (awsLogicalDeviceId?.hashCode() ?: 0)
        result = 31 * result + (bandwidth?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (connectionName?.hashCode() ?: 0)
        result = 31 * result + (connectionState?.hashCode() ?: 0)
        result = 31 * result + (encryptionMode?.hashCode() ?: 0)
        result = 31 * result + (hasLogicalRedundancy?.hashCode() ?: 0)
        result = 31 * result + (jumboFrameCapable?.hashCode() ?: 0)
        result = 31 * result + (lagId?.hashCode() ?: 0)
        result = 31 * result + (loaIssueTime?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (macSecCapable?.hashCode() ?: 0)
        result = 31 * result + (macSecKeys?.hashCode() ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (partnerName?.hashCode() ?: 0)
        result = 31 * result + (portEncryptionStatus?.hashCode() ?: 0)
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vlan)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateHostedConnectionResponse

        if (awsDevice != other.awsDevice) return false
        if (awsDeviceV2 != other.awsDeviceV2) return false
        if (awsLogicalDeviceId != other.awsLogicalDeviceId) return false
        if (bandwidth != other.bandwidth) return false
        if (connectionId != other.connectionId) return false
        if (connectionName != other.connectionName) return false
        if (connectionState != other.connectionState) return false
        if (encryptionMode != other.encryptionMode) return false
        if (hasLogicalRedundancy != other.hasLogicalRedundancy) return false
        if (jumboFrameCapable != other.jumboFrameCapable) return false
        if (lagId != other.lagId) return false
        if (loaIssueTime != other.loaIssueTime) return false
        if (location != other.location) return false
        if (macSecCapable != other.macSecCapable) return false
        if (macSecKeys != other.macSecKeys) return false
        if (ownerAccount != other.ownerAccount) return false
        if (partnerName != other.partnerName) return false
        if (portEncryptionStatus != other.portEncryptionStatus) return false
        if (providerName != other.providerName) return false
        if (region != other.region) return false
        if (tags != other.tags) return false
        if (vlan != other.vlan) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.AssociateHostedConnectionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Direct Connect endpoint on which the physical connection terminates.
         */
        public var awsDevice: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the physical connection.
         */
        public var awsDeviceV2: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
         */
        public var awsLogicalDeviceId: kotlin.String? = null
        /**
         * The bandwidth of the connection.
         */
        public var bandwidth: kotlin.String? = null
        /**
         * The ID of the connection.
         */
        public var connectionId: kotlin.String? = null
        /**
         * The name of the connection.
         */
        public var connectionName: kotlin.String? = null
        /**
         * The state of the connection. The following are the possible values:
         * + `ordering`: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.
         * + `requested`: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.
         * + `pending`: The connection has been approved and is being initialized.
         * + `available`: The network link is up and the connection is ready for use.
         * + `down`: The network link is down.
         * + `deleting`: The connection is being deleted.
         * + `deleted`: The connection has been deleted.
         * + `rejected`: A hosted connection in the `ordering` state enters the `rejected` state if it is deleted by the customer.
         * + `unknown`: The state of the connection is not available.
         */
        public var connectionState: aws.sdk.kotlin.services.directconnect.model.ConnectionState? = null
        /**
         * The MAC Security (MACsec) connection encryption mode.
         *
         * The valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
         */
        public var encryptionMode: kotlin.String? = null
        /**
         * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
         */
        public var hasLogicalRedundancy: aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy? = null
        /**
         * Indicates whether jumbo frames (9001 MTU) are supported.
         */
        public var jumboFrameCapable: kotlin.Boolean? = null
        /**
         * The ID of the LAG.
         */
        public var lagId: kotlin.String? = null
        /**
         * The time of the most recent call to DescribeLoa for this connection.
         */
        public var loaIssueTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the connection.
         */
        public var location: kotlin.String? = null
        /**
         * Indicates whether the connection supports MAC Security (MACsec).
         */
        public var macSecCapable: kotlin.Boolean? = null
        /**
         * The MAC Security (MACsec) security keys associated with the connection.
         */
        public var macSecKeys: List<MacSecKey>? = null
        /**
         * The ID of the Amazon Web Services account that owns the connection.
         */
        public var ownerAccount: kotlin.String? = null
        /**
         * The name of the Direct Connect service provider associated with the connection.
         */
        public var partnerName: kotlin.String? = null
        /**
         * The MAC Security (MACsec) port link status of the connection.
         *
         * The valid values are `Encryption Up`, which means that there is an active Connection Key Name, or `Encryption Down`.
         */
        public var portEncryptionStatus: kotlin.String? = null
        /**
         * The name of the service provider associated with the connection.
         */
        public var providerName: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the connection is located.
         */
        public var region: kotlin.String? = null
        /**
         * The tags associated with the connection.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of the VLAN.
         */
        public var vlan: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.AssociateHostedConnectionResponse) : this() {
            this.awsDevice = x.awsDevice
            this.awsDeviceV2 = x.awsDeviceV2
            this.awsLogicalDeviceId = x.awsLogicalDeviceId
            this.bandwidth = x.bandwidth
            this.connectionId = x.connectionId
            this.connectionName = x.connectionName
            this.connectionState = x.connectionState
            this.encryptionMode = x.encryptionMode
            this.hasLogicalRedundancy = x.hasLogicalRedundancy
            this.jumboFrameCapable = x.jumboFrameCapable
            this.lagId = x.lagId
            this.loaIssueTime = x.loaIssueTime
            this.location = x.location
            this.macSecCapable = x.macSecCapable
            this.macSecKeys = x.macSecKeys
            this.ownerAccount = x.ownerAccount
            this.partnerName = x.partnerName
            this.portEncryptionStatus = x.portEncryptionStatus
            this.providerName = x.providerName
            this.region = x.region
            this.tags = x.tags
            this.vlan = x.vlan
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.AssociateHostedConnectionResponse = AssociateHostedConnectionResponse(this)
    }
}
