// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about an association between a Direct Connect gateway and a virtual private gateway or transit gateway.
 */
public class DirectConnectGatewayAssociation private constructor(builder: Builder) {
    /**
     * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
     */
    public val allowedPrefixesToDirectConnectGateway: List<RouteFilterPrefix>? = builder.allowedPrefixesToDirectConnectGateway
    /**
     * Information about the associated gateway.
     */
    public val associatedGateway: aws.sdk.kotlin.services.directconnect.model.AssociatedGateway? = builder.associatedGateway
    /**
     * The ID of the Direct Connect gateway association.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The state of the association. The following are the possible values:
     * + `associating`: The initial state after calling CreateDirectConnectGatewayAssociation.
     * + `associated`: The Direct Connect gateway and virtual private gateway or transit gateway are successfully associated and ready to pass traffic.
     * + `disassociating`: The initial state after calling DeleteDirectConnectGatewayAssociation.
     * + `disassociated`: The virtual private gateway or transit gateway is disassociated from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit gateway is stopped.
     */
    public val associationState: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociationState? = builder.associationState
    /**
     * The ID of the Direct Connect gateway.
     */
    public val directConnectGatewayId: kotlin.String? = builder.directConnectGatewayId
    /**
     * The ID of the Amazon Web Services account that owns the associated gateway.
     */
    public val directConnectGatewayOwnerAccount: kotlin.String? = builder.directConnectGatewayOwnerAccount
    /**
     * The error message if the state of an object failed to advance.
     */
    public val stateChangeError: kotlin.String? = builder.stateChangeError
    /**
     * The ID of the virtual private gateway. Applies only to private virtual interfaces.
     */
    public val virtualGatewayId: kotlin.String? = builder.virtualGatewayId
    /**
     * The ID of the Amazon Web Services account that owns the virtual private gateway.
     */
    public val virtualGatewayOwnerAccount: kotlin.String? = builder.virtualGatewayOwnerAccount
    /**
     * The Amazon Web Services Region where the virtual private gateway is located.
     */
    public val virtualGatewayRegion: kotlin.String? = builder.virtualGatewayRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DirectConnectGatewayAssociation(")
        append("allowedPrefixesToDirectConnectGateway=$allowedPrefixesToDirectConnectGateway,")
        append("associatedGateway=$associatedGateway,")
        append("associationId=$associationId,")
        append("associationState=$associationState,")
        append("directConnectGatewayId=$directConnectGatewayId,")
        append("directConnectGatewayOwnerAccount=$directConnectGatewayOwnerAccount,")
        append("stateChangeError=$stateChangeError,")
        append("virtualGatewayId=$virtualGatewayId,")
        append("virtualGatewayOwnerAccount=$virtualGatewayOwnerAccount,")
        append("virtualGatewayRegion=$virtualGatewayRegion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedPrefixesToDirectConnectGateway?.hashCode() ?: 0
        result = 31 * result + (associatedGateway?.hashCode() ?: 0)
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (associationState?.hashCode() ?: 0)
        result = 31 * result + (directConnectGatewayId?.hashCode() ?: 0)
        result = 31 * result + (directConnectGatewayOwnerAccount?.hashCode() ?: 0)
        result = 31 * result + (stateChangeError?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayId?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayOwnerAccount?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DirectConnectGatewayAssociation

        if (allowedPrefixesToDirectConnectGateway != other.allowedPrefixesToDirectConnectGateway) return false
        if (associatedGateway != other.associatedGateway) return false
        if (associationId != other.associationId) return false
        if (associationState != other.associationState) return false
        if (directConnectGatewayId != other.directConnectGatewayId) return false
        if (directConnectGatewayOwnerAccount != other.directConnectGatewayOwnerAccount) return false
        if (stateChangeError != other.stateChangeError) return false
        if (virtualGatewayId != other.virtualGatewayId) return false
        if (virtualGatewayOwnerAccount != other.virtualGatewayOwnerAccount) return false
        if (virtualGatewayRegion != other.virtualGatewayRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         */
        public var allowedPrefixesToDirectConnectGateway: List<RouteFilterPrefix>? = null
        /**
         * Information about the associated gateway.
         */
        public var associatedGateway: aws.sdk.kotlin.services.directconnect.model.AssociatedGateway? = null
        /**
         * The ID of the Direct Connect gateway association.
         */
        public var associationId: kotlin.String? = null
        /**
         * The state of the association. The following are the possible values:
         * + `associating`: The initial state after calling CreateDirectConnectGatewayAssociation.
         * + `associated`: The Direct Connect gateway and virtual private gateway or transit gateway are successfully associated and ready to pass traffic.
         * + `disassociating`: The initial state after calling DeleteDirectConnectGatewayAssociation.
         * + `disassociated`: The virtual private gateway or transit gateway is disassociated from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual private gateway or transit gateway is stopped.
         */
        public var associationState: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociationState? = null
        /**
         * The ID of the Direct Connect gateway.
         */
        public var directConnectGatewayId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the associated gateway.
         */
        public var directConnectGatewayOwnerAccount: kotlin.String? = null
        /**
         * The error message if the state of an object failed to advance.
         */
        public var stateChangeError: kotlin.String? = null
        /**
         * The ID of the virtual private gateway. Applies only to private virtual interfaces.
         */
        public var virtualGatewayId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the virtual private gateway.
         */
        public var virtualGatewayOwnerAccount: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the virtual private gateway is located.
         */
        public var virtualGatewayRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociation) : this() {
            this.allowedPrefixesToDirectConnectGateway = x.allowedPrefixesToDirectConnectGateway
            this.associatedGateway = x.associatedGateway
            this.associationId = x.associationId
            this.associationState = x.associationState
            this.directConnectGatewayId = x.directConnectGatewayId
            this.directConnectGatewayOwnerAccount = x.directConnectGatewayOwnerAccount
            this.stateChangeError = x.stateChangeError
            this.virtualGatewayId = x.virtualGatewayId
            this.virtualGatewayOwnerAccount = x.virtualGatewayOwnerAccount
            this.virtualGatewayRegion = x.virtualGatewayRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociation = DirectConnectGatewayAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.directconnect.model.AssociatedGateway] inside the given [block]
         */
        public fun associatedGateway(block: aws.sdk.kotlin.services.directconnect.model.AssociatedGateway.Builder.() -> kotlin.Unit) {
            this.associatedGateway = aws.sdk.kotlin.services.directconnect.model.AssociatedGateway.invoke(block)
        }
    }
}
