// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about an attachment between a Direct Connect gateway and a virtual interface.
 */
public class DirectConnectGatewayAttachment private constructor(builder: Builder) {
    /**
     * The state of the attachment. The following are the possible values:
     * + `attaching`: The initial state after a virtual interface is created using the Direct Connect gateway.
     * + `attached`: The Direct Connect gateway and virtual interface are attached and ready to pass traffic.
     * + `detaching`: The initial state after calling DeleteVirtualInterface.
     * + `detached`: The virtual interface is detached from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual interface is stopped.
     */
    public val attachmentState: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAttachmentState? = builder.attachmentState
    /**
     * The type of attachment.
     */
    public val attachmentType: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAttachmentType? = builder.attachmentType
    /**
     * The ID of the Direct Connect gateway.
     */
    public val directConnectGatewayId: kotlin.String? = builder.directConnectGatewayId
    /**
     * The error message if the state of an object failed to advance.
     */
    public val stateChangeError: kotlin.String? = builder.stateChangeError
    /**
     * The ID of the virtual interface.
     */
    public val virtualInterfaceId: kotlin.String? = builder.virtualInterfaceId
    /**
     * The ID of the Amazon Web Services account that owns the virtual interface.
     */
    public val virtualInterfaceOwnerAccount: kotlin.String? = builder.virtualInterfaceOwnerAccount
    /**
     * The Amazon Web Services Region where the virtual interface is located.
     */
    public val virtualInterfaceRegion: kotlin.String? = builder.virtualInterfaceRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAttachment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DirectConnectGatewayAttachment(")
        append("attachmentState=$attachmentState,")
        append("attachmentType=$attachmentType,")
        append("directConnectGatewayId=$directConnectGatewayId,")
        append("stateChangeError=$stateChangeError,")
        append("virtualInterfaceId=$virtualInterfaceId,")
        append("virtualInterfaceOwnerAccount=$virtualInterfaceOwnerAccount,")
        append("virtualInterfaceRegion=$virtualInterfaceRegion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentState?.hashCode() ?: 0
        result = 31 * result + (attachmentType?.hashCode() ?: 0)
        result = 31 * result + (directConnectGatewayId?.hashCode() ?: 0)
        result = 31 * result + (stateChangeError?.hashCode() ?: 0)
        result = 31 * result + (virtualInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (virtualInterfaceOwnerAccount?.hashCode() ?: 0)
        result = 31 * result + (virtualInterfaceRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DirectConnectGatewayAttachment

        if (attachmentState != other.attachmentState) return false
        if (attachmentType != other.attachmentType) return false
        if (directConnectGatewayId != other.directConnectGatewayId) return false
        if (stateChangeError != other.stateChangeError) return false
        if (virtualInterfaceId != other.virtualInterfaceId) return false
        if (virtualInterfaceOwnerAccount != other.virtualInterfaceOwnerAccount) return false
        if (virtualInterfaceRegion != other.virtualInterfaceRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAttachment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The state of the attachment. The following are the possible values:
         * + `attaching`: The initial state after a virtual interface is created using the Direct Connect gateway.
         * + `attached`: The Direct Connect gateway and virtual interface are attached and ready to pass traffic.
         * + `detaching`: The initial state after calling DeleteVirtualInterface.
         * + `detached`: The virtual interface is detached from the Direct Connect gateway. Traffic flow between the Direct Connect gateway and virtual interface is stopped.
         */
        public var attachmentState: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAttachmentState? = null
        /**
         * The type of attachment.
         */
        public var attachmentType: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAttachmentType? = null
        /**
         * The ID of the Direct Connect gateway.
         */
        public var directConnectGatewayId: kotlin.String? = null
        /**
         * The error message if the state of an object failed to advance.
         */
        public var stateChangeError: kotlin.String? = null
        /**
         * The ID of the virtual interface.
         */
        public var virtualInterfaceId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the virtual interface.
         */
        public var virtualInterfaceOwnerAccount: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the virtual interface is located.
         */
        public var virtualInterfaceRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAttachment) : this() {
            this.attachmentState = x.attachmentState
            this.attachmentType = x.attachmentType
            this.directConnectGatewayId = x.directConnectGatewayId
            this.stateChangeError = x.stateChangeError
            this.virtualInterfaceId = x.virtualInterfaceId
            this.virtualInterfaceOwnerAccount = x.virtualInterfaceOwnerAccount
            this.virtualInterfaceRegion = x.virtualInterfaceRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAttachment = DirectConnectGatewayAttachment(this)
    }
}
