// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about the MAC Security (MACsec) secret key.
 */
public class MacSecKey private constructor(builder: Builder) {
    /**
     * The Connection Key Name (CKN) for the MAC Security secret key.
     */
    public val ckn: kotlin.String? = builder.ckn
    /**
     * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.
     */
    public val startOn: kotlin.String? = builder.startOn
    /**
     * The state of the MAC Security (MACsec) secret key.
     *
     * The possible values are:
     * + `associating`: The MAC Security (MACsec) secret key is being validated and not yet associated with the connection or LAG.
     * + `associated`: The MAC Security (MACsec) secret key is validated and associated with the connection or LAG.
     * + `disassociating`: The MAC Security (MACsec) secret key is being disassociated from the connection or LAG
     * + `disassociated`: The MAC Security (MACsec) secret key is no longer associated with the connection or LAG.
     */
    public val state: kotlin.String? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.MacSecKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MacSecKey(")
        append("ckn=$ckn,")
        append("secretArn=$secretArn,")
        append("startOn=$startOn,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ckn?.hashCode() ?: 0
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (startOn?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MacSecKey

        if (ckn != other.ckn) return false
        if (secretArn != other.secretArn) return false
        if (startOn != other.startOn) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.MacSecKey = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Connection Key Name (CKN) for the MAC Security secret key.
         */
        public var ckn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.
         */
        public var startOn: kotlin.String? = null
        /**
         * The state of the MAC Security (MACsec) secret key.
         *
         * The possible values are:
         * + `associating`: The MAC Security (MACsec) secret key is being validated and not yet associated with the connection or LAG.
         * + `associated`: The MAC Security (MACsec) secret key is validated and associated with the connection or LAG.
         * + `disassociating`: The MAC Security (MACsec) secret key is being disassociated from the connection or LAG
         * + `disassociated`: The MAC Security (MACsec) secret key is no longer associated with the connection or LAG.
         */
        public var state: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.MacSecKey) : this() {
            this.ckn = x.ckn
            this.secretArn = x.secretArn
            this.startOn = x.startOn
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.MacSecKey = MacSecKey(this)
    }
}
