// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.Connection
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy
import aws.sdk.kotlin.services.directconnect.model.LagState
import aws.sdk.kotlin.services.directconnect.model.MacSecKey
import aws.sdk.kotlin.services.directconnect.model.Tag
import aws.sdk.kotlin.services.directconnect.model.UpdateLagResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateLagOperationDeserializer: HttpDeserialize<UpdateLagResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateLagResponse {
        if (!response.status.isSuccess()) {
            throwUpdateLagError(context, response)
        }
        val builder = UpdateLagResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateLagOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateLagError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateLagOperationBody(builder: UpdateLagResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOWSHOSTEDCONNECTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("allowsHostedConnections"))
    val AWSDEVICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsDevice"))
    val AWSDEVICEV2_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsDeviceV2"))
    val AWSLOGICALDEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsLogicalDeviceId"))
    val CONNECTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("connections"))
    val CONNECTIONSBANDWIDTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionsBandwidth"))
    val ENCRYPTIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("encryptionMode"))
    val HASLOGICALREDUNDANCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("hasLogicalRedundancy"))
    val JUMBOFRAMECAPABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("jumboFrameCapable"))
    val LAGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lagId"))
    val LAGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lagName"))
    val LAGSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lagState"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("location"))
    val MACSECCAPABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("macSecCapable"))
    val MACSECKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("macSecKeys"))
    val MINIMUMLINKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("minimumLinks"))
    val NUMBEROFCONNECTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("numberOfConnections"))
    val OWNERACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownerAccount"))
    val PROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("providerName"))
    val REGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("region"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWSHOSTEDCONNECTIONS_DESCRIPTOR)
        field(AWSDEVICE_DESCRIPTOR)
        field(AWSDEVICEV2_DESCRIPTOR)
        field(AWSLOGICALDEVICEID_DESCRIPTOR)
        field(CONNECTIONS_DESCRIPTOR)
        field(CONNECTIONSBANDWIDTH_DESCRIPTOR)
        field(ENCRYPTIONMODE_DESCRIPTOR)
        field(HASLOGICALREDUNDANCY_DESCRIPTOR)
        field(JUMBOFRAMECAPABLE_DESCRIPTOR)
        field(LAGID_DESCRIPTOR)
        field(LAGNAME_DESCRIPTOR)
        field(LAGSTATE_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(MACSECCAPABLE_DESCRIPTOR)
        field(MACSECKEYS_DESCRIPTOR)
        field(MINIMUMLINKS_DESCRIPTOR)
        field(NUMBEROFCONNECTIONS_DESCRIPTOR)
        field(OWNERACCOUNT_DESCRIPTOR)
        field(PROVIDERNAME_DESCRIPTOR)
        field(REGION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWSHOSTEDCONNECTIONS_DESCRIPTOR.index -> builder.allowsHostedConnections = deserializeBoolean()
                AWSDEVICE_DESCRIPTOR.index -> builder.awsDevice = deserializeString()
                AWSDEVICEV2_DESCRIPTOR.index -> builder.awsDeviceV2 = deserializeString()
                AWSLOGICALDEVICEID_DESCRIPTOR.index -> builder.awsLogicalDeviceId = deserializeString()
                CONNECTIONS_DESCRIPTOR.index -> builder.connections =
                    deserializer.deserializeList(CONNECTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Connection>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConnectionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONNECTIONSBANDWIDTH_DESCRIPTOR.index -> builder.connectionsBandwidth = deserializeString()
                ENCRYPTIONMODE_DESCRIPTOR.index -> builder.encryptionMode = deserializeString()
                HASLOGICALREDUNDANCY_DESCRIPTOR.index -> builder.hasLogicalRedundancy = deserializeString().let { HasLogicalRedundancy.fromValue(it) }
                JUMBOFRAMECAPABLE_DESCRIPTOR.index -> builder.jumboFrameCapable = deserializeBoolean()
                LAGID_DESCRIPTOR.index -> builder.lagId = deserializeString()
                LAGNAME_DESCRIPTOR.index -> builder.lagName = deserializeString()
                LAGSTATE_DESCRIPTOR.index -> builder.lagState = deserializeString().let { LagState.fromValue(it) }
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeString()
                MACSECCAPABLE_DESCRIPTOR.index -> builder.macSecCapable = deserializeBoolean()
                MACSECKEYS_DESCRIPTOR.index -> builder.macSecKeys =
                    deserializer.deserializeList(MACSECKEYS_DESCRIPTOR) {
                        val col0 = mutableListOf<MacSecKey>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMacSecKeyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MINIMUMLINKS_DESCRIPTOR.index -> builder.minimumLinks = deserializeInt()
                NUMBEROFCONNECTIONS_DESCRIPTOR.index -> builder.numberOfConnections = deserializeInt()
                OWNERACCOUNT_DESCRIPTOR.index -> builder.ownerAccount = deserializeString()
                PROVIDERNAME_DESCRIPTOR.index -> builder.providerName = deserializeString()
                REGION_DESCRIPTOR.index -> builder.region = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
