// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about a link aggregation group (LAG).
 */
public class UpdateLagResponse private constructor(builder: Builder) {
    /**
     * Indicates whether the LAG can host other connections.
     */
    public val allowsHostedConnections: kotlin.Boolean = builder.allowsHostedConnections
    /**
     * The Direct Connect endpoint that hosts the LAG.
     */
    public val awsDevice: kotlin.String? = builder.awsDevice
    /**
     * The Direct Connect endpoint that hosts the LAG.
     */
    public val awsDeviceV2: kotlin.String? = builder.awsDeviceV2
    /**
     * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
     */
    public val awsLogicalDeviceId: kotlin.String? = builder.awsLogicalDeviceId
    /**
     * The connections bundled by the LAG.
     */
    public val connections: List<Connection>? = builder.connections
    /**
     * The individual bandwidth of the physical connections bundled by the LAG. The possible values are 1Gbps and 10Gbps.
     */
    public val connectionsBandwidth: kotlin.String? = builder.connectionsBandwidth
    /**
     * The LAG MAC Security (MACsec) encryption mode.
     *
     * The valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
     */
    public val encryptionMode: kotlin.String? = builder.encryptionMode
    /**
     * Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
     */
    public val hasLogicalRedundancy: aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy? = builder.hasLogicalRedundancy
    /**
     * Indicates whether jumbo frames (9001 MTU) are supported.
     */
    public val jumboFrameCapable: kotlin.Boolean? = builder.jumboFrameCapable
    /**
     * The ID of the LAG.
     */
    public val lagId: kotlin.String? = builder.lagId
    /**
     * The name of the LAG.
     */
    public val lagName: kotlin.String? = builder.lagName
    /**
     * The state of the LAG. The following are the possible values:
     * + `requested`: The initial state of a LAG. The LAG stays in the requested state until the Letter of Authorization (LOA) is available.
     * + `pending`: The LAG has been approved and is being initialized.
     * + `available`: The network link is established and the LAG is ready for use.
     * + `down`: The network link is down.
     * + `deleting`: The LAG is being deleted.
     * + `deleted`: The LAG is deleted.
     * + `unknown`: The state of the LAG is not available.
     */
    public val lagState: aws.sdk.kotlin.services.directconnect.model.LagState? = builder.lagState
    /**
     * The location of the LAG.
     */
    public val location: kotlin.String? = builder.location
    /**
     * Indicates whether the LAG supports MAC Security (MACsec).
     */
    public val macSecCapable: kotlin.Boolean? = builder.macSecCapable
    /**
     * The MAC Security (MACsec) security keys associated with the LAG.
     */
    public val macSecKeys: List<MacSecKey>? = builder.macSecKeys
    /**
     * The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.
     */
    public val minimumLinks: kotlin.Int = builder.minimumLinks
    /**
     * The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.
     */
    public val numberOfConnections: kotlin.Int = builder.numberOfConnections
    /**
     * The ID of the Amazon Web Services account that owns the LAG.
     */
    public val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The name of the service provider associated with the LAG.
     */
    public val providerName: kotlin.String? = builder.providerName
    /**
     * The Amazon Web Services Region where the connection is located.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The tags associated with the LAG.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.UpdateLagResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLagResponse(")
        append("allowsHostedConnections=$allowsHostedConnections,")
        append("awsDevice=$awsDevice,")
        append("awsDeviceV2=$awsDeviceV2,")
        append("awsLogicalDeviceId=$awsLogicalDeviceId,")
        append("connections=$connections,")
        append("connectionsBandwidth=$connectionsBandwidth,")
        append("encryptionMode=$encryptionMode,")
        append("hasLogicalRedundancy=$hasLogicalRedundancy,")
        append("jumboFrameCapable=$jumboFrameCapable,")
        append("lagId=$lagId,")
        append("lagName=$lagName,")
        append("lagState=$lagState,")
        append("location=$location,")
        append("macSecCapable=$macSecCapable,")
        append("macSecKeys=$macSecKeys,")
        append("minimumLinks=$minimumLinks,")
        append("numberOfConnections=$numberOfConnections,")
        append("ownerAccount=$ownerAccount,")
        append("providerName=$providerName,")
        append("region=$region,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowsHostedConnections.hashCode()
        result = 31 * result + (awsDevice?.hashCode() ?: 0)
        result = 31 * result + (awsDeviceV2?.hashCode() ?: 0)
        result = 31 * result + (awsLogicalDeviceId?.hashCode() ?: 0)
        result = 31 * result + (connections?.hashCode() ?: 0)
        result = 31 * result + (connectionsBandwidth?.hashCode() ?: 0)
        result = 31 * result + (encryptionMode?.hashCode() ?: 0)
        result = 31 * result + (hasLogicalRedundancy?.hashCode() ?: 0)
        result = 31 * result + (jumboFrameCapable?.hashCode() ?: 0)
        result = 31 * result + (lagId?.hashCode() ?: 0)
        result = 31 * result + (lagName?.hashCode() ?: 0)
        result = 31 * result + (lagState?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (macSecCapable?.hashCode() ?: 0)
        result = 31 * result + (macSecKeys?.hashCode() ?: 0)
        result = 31 * result + (minimumLinks)
        result = 31 * result + (numberOfConnections)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLagResponse

        if (allowsHostedConnections != other.allowsHostedConnections) return false
        if (awsDevice != other.awsDevice) return false
        if (awsDeviceV2 != other.awsDeviceV2) return false
        if (awsLogicalDeviceId != other.awsLogicalDeviceId) return false
        if (connections != other.connections) return false
        if (connectionsBandwidth != other.connectionsBandwidth) return false
        if (encryptionMode != other.encryptionMode) return false
        if (hasLogicalRedundancy != other.hasLogicalRedundancy) return false
        if (jumboFrameCapable != other.jumboFrameCapable) return false
        if (lagId != other.lagId) return false
        if (lagName != other.lagName) return false
        if (lagState != other.lagState) return false
        if (location != other.location) return false
        if (macSecCapable != other.macSecCapable) return false
        if (macSecKeys != other.macSecKeys) return false
        if (minimumLinks != other.minimumLinks) return false
        if (numberOfConnections != other.numberOfConnections) return false
        if (ownerAccount != other.ownerAccount) return false
        if (providerName != other.providerName) return false
        if (region != other.region) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.UpdateLagResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the LAG can host other connections.
         */
        public var allowsHostedConnections: kotlin.Boolean = false
        /**
         * The Direct Connect endpoint that hosts the LAG.
         */
        public var awsDevice: kotlin.String? = null
        /**
         * The Direct Connect endpoint that hosts the LAG.
         */
        public var awsDeviceV2: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
         */
        public var awsLogicalDeviceId: kotlin.String? = null
        /**
         * The connections bundled by the LAG.
         */
        public var connections: List<Connection>? = null
        /**
         * The individual bandwidth of the physical connections bundled by the LAG. The possible values are 1Gbps and 10Gbps.
         */
        public var connectionsBandwidth: kotlin.String? = null
        /**
         * The LAG MAC Security (MACsec) encryption mode.
         *
         * The valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
         */
        public var encryptionMode: kotlin.String? = null
        /**
         * Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
         */
        public var hasLogicalRedundancy: aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy? = null
        /**
         * Indicates whether jumbo frames (9001 MTU) are supported.
         */
        public var jumboFrameCapable: kotlin.Boolean? = null
        /**
         * The ID of the LAG.
         */
        public var lagId: kotlin.String? = null
        /**
         * The name of the LAG.
         */
        public var lagName: kotlin.String? = null
        /**
         * The state of the LAG. The following are the possible values:
         * + `requested`: The initial state of a LAG. The LAG stays in the requested state until the Letter of Authorization (LOA) is available.
         * + `pending`: The LAG has been approved and is being initialized.
         * + `available`: The network link is established and the LAG is ready for use.
         * + `down`: The network link is down.
         * + `deleting`: The LAG is being deleted.
         * + `deleted`: The LAG is deleted.
         * + `unknown`: The state of the LAG is not available.
         */
        public var lagState: aws.sdk.kotlin.services.directconnect.model.LagState? = null
        /**
         * The location of the LAG.
         */
        public var location: kotlin.String? = null
        /**
         * Indicates whether the LAG supports MAC Security (MACsec).
         */
        public var macSecCapable: kotlin.Boolean? = null
        /**
         * The MAC Security (MACsec) security keys associated with the LAG.
         */
        public var macSecKeys: List<MacSecKey>? = null
        /**
         * The minimum number of physical dedicated connections that must be operational for the LAG itself to be operational.
         */
        public var minimumLinks: kotlin.Int = 0
        /**
         * The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.
         */
        public var numberOfConnections: kotlin.Int = 0
        /**
         * The ID of the Amazon Web Services account that owns the LAG.
         */
        public var ownerAccount: kotlin.String? = null
        /**
         * The name of the service provider associated with the LAG.
         */
        public var providerName: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the connection is located.
         */
        public var region: kotlin.String? = null
        /**
         * The tags associated with the LAG.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.UpdateLagResponse) : this() {
            this.allowsHostedConnections = x.allowsHostedConnections
            this.awsDevice = x.awsDevice
            this.awsDeviceV2 = x.awsDeviceV2
            this.awsLogicalDeviceId = x.awsLogicalDeviceId
            this.connections = x.connections
            this.connectionsBandwidth = x.connectionsBandwidth
            this.encryptionMode = x.encryptionMode
            this.hasLogicalRedundancy = x.hasLogicalRedundancy
            this.jumboFrameCapable = x.jumboFrameCapable
            this.lagId = x.lagId
            this.lagName = x.lagName
            this.lagState = x.lagState
            this.location = x.location
            this.macSecCapable = x.macSecCapable
            this.macSecKeys = x.macSecKeys
            this.minimumLinks = x.minimumLinks
            this.numberOfConnections = x.numberOfConnections
            this.ownerAccount = x.ownerAccount
            this.providerName = x.providerName
            this.region = x.region
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.UpdateLagResponse = UpdateLagResponse(this)
    }
}
