// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.AddressFamily
import aws.sdk.kotlin.services.directconnect.model.AssociateVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.BgpPeer
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.RouteFilterPrefix
import aws.sdk.kotlin.services.directconnect.model.Tag
import aws.sdk.kotlin.services.directconnect.model.VirtualInterfaceState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AssociateVirtualInterfaceOperationDeserializer: HttpDeserialize<AssociateVirtualInterfaceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssociateVirtualInterfaceResponse {
        if (!response.status.isSuccess()) {
            throwAssociateVirtualInterfaceError(context, response)
        }
        val builder = AssociateVirtualInterfaceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssociateVirtualInterfaceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAssociateVirtualInterfaceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssociateVirtualInterfaceOperationBody(builder: AssociateVirtualInterfaceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDRESSFAMILY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("addressFamily"))
    val AMAZONADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("amazonAddress"))
    val AMAZONSIDEASN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("amazonSideAsn"))
    val ASN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("asn"))
    val AUTHKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authKey"))
    val AWSDEVICEV2_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsDeviceV2"))
    val AWSLOGICALDEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsLogicalDeviceId"))
    val BGPPEERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("bgpPeers"))
    val CONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionId"))
    val CUSTOMERADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customerAddress"))
    val CUSTOMERROUTERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customerRouterConfig"))
    val DIRECTCONNECTGATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("directConnectGatewayId"))
    val JUMBOFRAMECAPABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("jumboFrameCapable"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("location"))
    val MTU_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("mtu"))
    val OWNERACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownerAccount"))
    val REGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("region"))
    val ROUTEFILTERPREFIXES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("routeFilterPrefixes"))
    val SITELINKENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("siteLinkEnabled"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val VIRTUALGATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("virtualGatewayId"))
    val VIRTUALINTERFACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("virtualInterfaceId"))
    val VIRTUALINTERFACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("virtualInterfaceName"))
    val VIRTUALINTERFACESTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("virtualInterfaceState"))
    val VIRTUALINTERFACETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("virtualInterfaceType"))
    val VLAN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("vlan"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDRESSFAMILY_DESCRIPTOR)
        field(AMAZONADDRESS_DESCRIPTOR)
        field(AMAZONSIDEASN_DESCRIPTOR)
        field(ASN_DESCRIPTOR)
        field(AUTHKEY_DESCRIPTOR)
        field(AWSDEVICEV2_DESCRIPTOR)
        field(AWSLOGICALDEVICEID_DESCRIPTOR)
        field(BGPPEERS_DESCRIPTOR)
        field(CONNECTIONID_DESCRIPTOR)
        field(CUSTOMERADDRESS_DESCRIPTOR)
        field(CUSTOMERROUTERCONFIG_DESCRIPTOR)
        field(DIRECTCONNECTGATEWAYID_DESCRIPTOR)
        field(JUMBOFRAMECAPABLE_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(MTU_DESCRIPTOR)
        field(OWNERACCOUNT_DESCRIPTOR)
        field(REGION_DESCRIPTOR)
        field(ROUTEFILTERPREFIXES_DESCRIPTOR)
        field(SITELINKENABLED_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VIRTUALGATEWAYID_DESCRIPTOR)
        field(VIRTUALINTERFACEID_DESCRIPTOR)
        field(VIRTUALINTERFACENAME_DESCRIPTOR)
        field(VIRTUALINTERFACESTATE_DESCRIPTOR)
        field(VIRTUALINTERFACETYPE_DESCRIPTOR)
        field(VLAN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDRESSFAMILY_DESCRIPTOR.index -> builder.addressFamily = deserializeString().let { AddressFamily.fromValue(it) }
                AMAZONADDRESS_DESCRIPTOR.index -> builder.amazonAddress = deserializeString()
                AMAZONSIDEASN_DESCRIPTOR.index -> builder.amazonSideAsn = deserializeLong()
                ASN_DESCRIPTOR.index -> builder.asn = deserializeInt()
                AUTHKEY_DESCRIPTOR.index -> builder.authKey = deserializeString()
                AWSDEVICEV2_DESCRIPTOR.index -> builder.awsDeviceV2 = deserializeString()
                AWSLOGICALDEVICEID_DESCRIPTOR.index -> builder.awsLogicalDeviceId = deserializeString()
                BGPPEERS_DESCRIPTOR.index -> builder.bgpPeers =
                    deserializer.deserializeList(BGPPEERS_DESCRIPTOR) {
                        val col0 = mutableListOf<BgpPeer>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBgpPeerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONNECTIONID_DESCRIPTOR.index -> builder.connectionId = deserializeString()
                CUSTOMERADDRESS_DESCRIPTOR.index -> builder.customerAddress = deserializeString()
                CUSTOMERROUTERCONFIG_DESCRIPTOR.index -> builder.customerRouterConfig = deserializeString()
                DIRECTCONNECTGATEWAYID_DESCRIPTOR.index -> builder.directConnectGatewayId = deserializeString()
                JUMBOFRAMECAPABLE_DESCRIPTOR.index -> builder.jumboFrameCapable = deserializeBoolean()
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeString()
                MTU_DESCRIPTOR.index -> builder.mtu = deserializeInt()
                OWNERACCOUNT_DESCRIPTOR.index -> builder.ownerAccount = deserializeString()
                REGION_DESCRIPTOR.index -> builder.region = deserializeString()
                ROUTEFILTERPREFIXES_DESCRIPTOR.index -> builder.routeFilterPrefixes =
                    deserializer.deserializeList(ROUTEFILTERPREFIXES_DESCRIPTOR) {
                        val col0 = mutableListOf<RouteFilterPrefix>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRouteFilterPrefixDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SITELINKENABLED_DESCRIPTOR.index -> builder.siteLinkEnabled = deserializeBoolean()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VIRTUALGATEWAYID_DESCRIPTOR.index -> builder.virtualGatewayId = deserializeString()
                VIRTUALINTERFACEID_DESCRIPTOR.index -> builder.virtualInterfaceId = deserializeString()
                VIRTUALINTERFACENAME_DESCRIPTOR.index -> builder.virtualInterfaceName = deserializeString()
                VIRTUALINTERFACESTATE_DESCRIPTOR.index -> builder.virtualInterfaceState = deserializeString().let { VirtualInterfaceState.fromValue(it) }
                VIRTUALINTERFACETYPE_DESCRIPTOR.index -> builder.virtualInterfaceType = deserializeString()
                VLAN_DESCRIPTOR.index -> builder.vlan = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
