// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.Connection
import aws.sdk.kotlin.services.directconnect.model.DescribeHostedConnectionsResponse
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeHostedConnectionsOperationDeserializer: HttpDeserialize<DescribeHostedConnectionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeHostedConnectionsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeHostedConnectionsError(context, response)
        }
        val builder = DescribeHostedConnectionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeHostedConnectionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeHostedConnectionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeHostedConnectionsOperationBody(builder: DescribeHostedConnectionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("connections"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONS_DESCRIPTOR.index -> builder.connections =
                    deserializer.deserializeList(CONNECTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Connection>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConnectionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
