// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.DescribeInterconnectsResponse
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.Interconnect
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeInterconnectsOperationDeserializer: HttpDeserialize<DescribeInterconnectsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeInterconnectsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeInterconnectsError(context, response)
        }
        val builder = DescribeInterconnectsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeInterconnectsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeInterconnectsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeInterconnectsOperationBody(builder: DescribeInterconnectsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INTERCONNECTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("interconnects"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INTERCONNECTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INTERCONNECTS_DESCRIPTOR.index -> builder.interconnects =
                    deserializer.deserializeList(INTERCONNECTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Interconnect>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInterconnectDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
