// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an Direct Connect connection.
 */
class Connection private constructor(builder: Builder) {
    /**
     * The Direct Connect endpoint on which the physical connection terminates.
     */
    val awsDevice: kotlin.String? = builder.awsDevice
    /**
     * The Direct Connect endpoint that terminates the physical connection.
     */
    val awsDeviceV2: kotlin.String? = builder.awsDeviceV2
    /**
     * The Direct Connect endpoint that terminates the logical connection. This device might be
     * different than the device that terminates the physical connection.
     */
    val awsLogicalDeviceId: kotlin.String? = builder.awsLogicalDeviceId
    /**
     * The bandwidth of the connection.
     */
    val bandwidth: kotlin.String? = builder.bandwidth
    /**
     * The ID of the connection.
     */
    val connectionId: kotlin.String? = builder.connectionId
    /**
     * The name of the connection.
     */
    val connectionName: kotlin.String? = builder.connectionName
    /**
     * The state of the connection. The following are the possible values:
     * ordering: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.
     * requested: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.
     * pending: The connection has been approved and is being initialized.
     * available: The network link is up and the connection is ready for use.
     * down: The network link is down.
     * deleting: The connection is being deleted.
     * deleted: The connection has been deleted.
     * rejected: A hosted connection in the ordering state enters the rejected state if it is deleted by the customer.
     * unknown: The state of the connection is not available.
     */
    val connectionState: aws.sdk.kotlin.services.directconnect.model.ConnectionState? = builder.connectionState
    /**
     * The MAC Security (MACsec) connection encryption mode.
     * The valid values are no_encrypt, should_encrypt, and must_encrypt.
     */
    val encryptionMode: kotlin.String? = builder.encryptionMode
    /**
     * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
     */
    val hasLogicalRedundancy: aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy? = builder.hasLogicalRedundancy
    /**
     * Indicates whether jumbo frames (9001 MTU) are supported.
     */
    val jumboFrameCapable: kotlin.Boolean? = builder.jumboFrameCapable
    /**
     * The ID of the LAG.
     */
    val lagId: kotlin.String? = builder.lagId
    /**
     * The time of the most recent call to DescribeLoa for this connection.
     */
    val loaIssueTime: aws.smithy.kotlin.runtime.time.Instant? = builder.loaIssueTime
    /**
     * The location of the connection.
     */
    val location: kotlin.String? = builder.location
    /**
     * Indicates whether the connection supports MAC Security (MACsec).
     */
    val macSecCapable: kotlin.Boolean? = builder.macSecCapable
    /**
     * The MAC Security (MACsec) security keys associated with the connection.
     */
    val macSecKeys: List<MacSecKey>? = builder.macSecKeys
    /**
     * The ID of the Amazon Web Services account that owns the connection.
     */
    val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The name of the Direct Connect service provider associated with the connection.
     */
    val partnerName: kotlin.String? = builder.partnerName
    /**
     * The MAC Security (MACsec) port link status of the connection.
     * The valid values are Encryption Up, which means that there is an active Connection Key Name, or Encryption Down.
     */
    val portEncryptionStatus: kotlin.String? = builder.portEncryptionStatus
    /**
     * The name of the service provider associated with the connection.
     */
    val providerName: kotlin.String? = builder.providerName
    /**
     * The Amazon Web Services Region where the connection is located.
     */
    val region: kotlin.String? = builder.region
    /**
     * The tags associated with the connection.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VLAN.
     */
    val vlan: kotlin.Int = builder.vlan

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.Connection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Connection(")
        append("awsDevice=$awsDevice,")
        append("awsDeviceV2=$awsDeviceV2,")
        append("awsLogicalDeviceId=$awsLogicalDeviceId,")
        append("bandwidth=$bandwidth,")
        append("connectionId=$connectionId,")
        append("connectionName=$connectionName,")
        append("connectionState=$connectionState,")
        append("encryptionMode=$encryptionMode,")
        append("hasLogicalRedundancy=$hasLogicalRedundancy,")
        append("jumboFrameCapable=$jumboFrameCapable,")
        append("lagId=$lagId,")
        append("loaIssueTime=$loaIssueTime,")
        append("location=$location,")
        append("macSecCapable=$macSecCapable,")
        append("macSecKeys=$macSecKeys,")
        append("ownerAccount=$ownerAccount,")
        append("partnerName=$partnerName,")
        append("portEncryptionStatus=$portEncryptionStatus,")
        append("providerName=$providerName,")
        append("region=$region,")
        append("tags=$tags,")
        append("vlan=$vlan)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsDevice?.hashCode() ?: 0
        result = 31 * result + (awsDeviceV2?.hashCode() ?: 0)
        result = 31 * result + (awsLogicalDeviceId?.hashCode() ?: 0)
        result = 31 * result + (bandwidth?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (connectionName?.hashCode() ?: 0)
        result = 31 * result + (connectionState?.hashCode() ?: 0)
        result = 31 * result + (encryptionMode?.hashCode() ?: 0)
        result = 31 * result + (hasLogicalRedundancy?.hashCode() ?: 0)
        result = 31 * result + (jumboFrameCapable?.hashCode() ?: 0)
        result = 31 * result + (lagId?.hashCode() ?: 0)
        result = 31 * result + (loaIssueTime?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (macSecCapable?.hashCode() ?: 0)
        result = 31 * result + (macSecKeys?.hashCode() ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (partnerName?.hashCode() ?: 0)
        result = 31 * result + (portEncryptionStatus?.hashCode() ?: 0)
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vlan)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Connection

        if (awsDevice != other.awsDevice) return false
        if (awsDeviceV2 != other.awsDeviceV2) return false
        if (awsLogicalDeviceId != other.awsLogicalDeviceId) return false
        if (bandwidth != other.bandwidth) return false
        if (connectionId != other.connectionId) return false
        if (connectionName != other.connectionName) return false
        if (connectionState != other.connectionState) return false
        if (encryptionMode != other.encryptionMode) return false
        if (hasLogicalRedundancy != other.hasLogicalRedundancy) return false
        if (jumboFrameCapable != other.jumboFrameCapable) return false
        if (lagId != other.lagId) return false
        if (loaIssueTime != other.loaIssueTime) return false
        if (location != other.location) return false
        if (macSecCapable != other.macSecCapable) return false
        if (macSecKeys != other.macSecKeys) return false
        if (ownerAccount != other.ownerAccount) return false
        if (partnerName != other.partnerName) return false
        if (portEncryptionStatus != other.portEncryptionStatus) return false
        if (providerName != other.providerName) return false
        if (region != other.region) return false
        if (tags != other.tags) return false
        if (vlan != other.vlan) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.Connection = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Direct Connect endpoint on which the physical connection terminates.
         */
        var awsDevice: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the physical connection.
         */
        var awsDeviceV2: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the logical connection. This device might be
         * different than the device that terminates the physical connection.
         */
        var awsLogicalDeviceId: kotlin.String? = null
        /**
         * The bandwidth of the connection.
         */
        var bandwidth: kotlin.String? = null
        /**
         * The ID of the connection.
         */
        var connectionId: kotlin.String? = null
        /**
         * The name of the connection.
         */
        var connectionName: kotlin.String? = null
        /**
         * The state of the connection. The following are the possible values:
         * ordering: The initial state of a hosted connection provisioned on an interconnect. The connection stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.
         * requested: The initial state of a standard connection. The connection stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.
         * pending: The connection has been approved and is being initialized.
         * available: The network link is up and the connection is ready for use.
         * down: The network link is down.
         * deleting: The connection is being deleted.
         * deleted: The connection has been deleted.
         * rejected: A hosted connection in the ordering state enters the rejected state if it is deleted by the customer.
         * unknown: The state of the connection is not available.
         */
        var connectionState: aws.sdk.kotlin.services.directconnect.model.ConnectionState? = null
        /**
         * The MAC Security (MACsec) connection encryption mode.
         * The valid values are no_encrypt, should_encrypt, and must_encrypt.
         */
        var encryptionMode: kotlin.String? = null
        /**
         * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
         */
        var hasLogicalRedundancy: aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy? = null
        /**
         * Indicates whether jumbo frames (9001 MTU) are supported.
         */
        var jumboFrameCapable: kotlin.Boolean? = null
        /**
         * The ID of the LAG.
         */
        var lagId: kotlin.String? = null
        /**
         * The time of the most recent call to DescribeLoa for this connection.
         */
        var loaIssueTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the connection.
         */
        var location: kotlin.String? = null
        /**
         * Indicates whether the connection supports MAC Security (MACsec).
         */
        var macSecCapable: kotlin.Boolean? = null
        /**
         * The MAC Security (MACsec) security keys associated with the connection.
         */
        var macSecKeys: List<MacSecKey>? = null
        /**
         * The ID of the Amazon Web Services account that owns the connection.
         */
        var ownerAccount: kotlin.String? = null
        /**
         * The name of the Direct Connect service provider associated with the connection.
         */
        var partnerName: kotlin.String? = null
        /**
         * The MAC Security (MACsec) port link status of the connection.
         * The valid values are Encryption Up, which means that there is an active Connection Key Name, or Encryption Down.
         */
        var portEncryptionStatus: kotlin.String? = null
        /**
         * The name of the service provider associated with the connection.
         */
        var providerName: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the connection is located.
         */
        var region: kotlin.String? = null
        /**
         * The tags associated with the connection.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the VLAN.
         */
        var vlan: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.Connection) : this() {
            this.awsDevice = x.awsDevice
            this.awsDeviceV2 = x.awsDeviceV2
            this.awsLogicalDeviceId = x.awsLogicalDeviceId
            this.bandwidth = x.bandwidth
            this.connectionId = x.connectionId
            this.connectionName = x.connectionName
            this.connectionState = x.connectionState
            this.encryptionMode = x.encryptionMode
            this.hasLogicalRedundancy = x.hasLogicalRedundancy
            this.jumboFrameCapable = x.jumboFrameCapable
            this.lagId = x.lagId
            this.loaIssueTime = x.loaIssueTime
            this.location = x.location
            this.macSecCapable = x.macSecCapable
            this.macSecKeys = x.macSecKeys
            this.ownerAccount = x.ownerAccount
            this.partnerName = x.partnerName
            this.portEncryptionStatus = x.portEncryptionStatus
            this.providerName = x.providerName
            this.region = x.region
            this.tags = x.tags
            this.vlan = x.vlan
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.Connection = Connection(this)
    }
}
