// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.DescribeInterconnectLoaResponse
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.Loa
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeInterconnectLoaOperationDeserializer: HttpDeserialize<DescribeInterconnectLoaResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeInterconnectLoaResponse {
        if (!response.status.isSuccess()) {
            throwDescribeInterconnectLoaError(context, response)
        }
        val builder = DescribeInterconnectLoaResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeInterconnectLoaOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeInterconnectLoaOperationBody(builder: DescribeInterconnectLoaResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("loa"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOA_DESCRIPTOR.index -> builder.loa = deserializeLoaDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeInterconnectLoaError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer()
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer()
        else -> throw DirectConnectException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
