// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse
import aws.sdk.kotlin.services.directconnect.model.VirtualInterfaceTestHistory
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListVirtualInterfaceTestHistoryOperationDeserializer: HttpDeserialize<ListVirtualInterfaceTestHistoryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListVirtualInterfaceTestHistoryResponse {
        if (!response.status.isSuccess()) {
            throwListVirtualInterfaceTestHistoryError(context, response)
        }
        val builder = ListVirtualInterfaceTestHistoryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListVirtualInterfaceTestHistoryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeListVirtualInterfaceTestHistoryOperationBody(builder: ListVirtualInterfaceTestHistoryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val VIRTUALINTERFACETESTHISTORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("virtualInterfaceTestHistory"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(VIRTUALINTERFACETESTHISTORY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                VIRTUALINTERFACETESTHISTORY_DESCRIPTOR.index -> builder.virtualInterfaceTestHistory =
                    deserializer.deserializeList(VIRTUALINTERFACETESTHISTORY_DESCRIPTOR) {
                        val col0 = mutableListOf<VirtualInterfaceTestHistory>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVirtualInterfaceTestHistoryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListVirtualInterfaceTestHistoryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer()
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer()
        else -> throw DirectConnectException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
