// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.directconnect.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.directconnect.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Direct Connect links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end of the cable is connected to your router, the other to an Direct Connect router. With this connection in place, you can create virtual interfaces directly to the Amazon Web Services Cloud (for example, to Amazon EC2 and Amazon S3) and to Amazon VPC, bypassing Internet service providers in your network path. A connection provides access to all Amazon Web Services Regions except the China (Beijing) and (China) Ningxia Regions. Amazon Web Services resources in the China Regions can only be accessed through locations associated with those Regions.
 */
interface DirectConnectClient : SdkClient {

    override val serviceName: String
        get() = "Direct Connect"
    /**
     * DirectConnectClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): DirectConnectClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDirectConnectClient(config)
        }

        operator fun invoke(config: Config): DirectConnectClient = DefaultDirectConnectClient(config)

        /**
         * Construct a [DirectConnectClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DirectConnectClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultDirectConnectClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
     */
    suspend fun acceptDirectConnectGatewayAssociationProposal(input: AcceptDirectConnectGatewayAssociationProposalRequest): AcceptDirectConnectGatewayAssociationProposalResponse

    /**
     * Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
     */
    suspend fun acceptDirectConnectGatewayAssociationProposal(block: AcceptDirectConnectGatewayAssociationProposalRequest.Builder.() -> Unit) = acceptDirectConnectGatewayAssociationProposal(AcceptDirectConnectGatewayAssociationProposalRequest.Builder().apply(block).build())

    /**
     * Deprecated. Use AllocateHostedConnection instead.
     *
     * Creates a hosted connection on an interconnect.
     *
     * Allocates a VLAN number and a specified amount of bandwidth for use by a hosted connection on the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun allocateConnectionOnInterconnect(input: AllocateConnectionOnInterconnectRequest): AllocateConnectionOnInterconnectResponse

    /**
     * Deprecated. Use AllocateHostedConnection instead.
     *
     * Creates a hosted connection on an interconnect.
     *
     * Allocates a VLAN number and a specified amount of bandwidth for use by a hosted connection on the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun allocateConnectionOnInterconnect(block: AllocateConnectionOnInterconnectRequest.Builder.() -> Unit) = allocateConnectionOnInterconnect(AllocateConnectionOnInterconnectRequest.Builder().apply(block).build())

    /**
     * Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
     *
     * Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the specified capacity and the Direct Connect Partner must also police the hosted connection for the specified capacity.
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun allocateHostedConnection(input: AllocateHostedConnectionRequest): AllocateHostedConnectionResponse

    /**
     * Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
     *
     * Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the specified capacity and the Direct Connect Partner must also police the hosted connection for the specified capacity.
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun allocateHostedConnection(block: AllocateHostedConnectionRequest.Builder.() -> Unit) = allocateHostedConnection(AllocateHostedConnectionRequest.Builder().apply(block).build())

    /**
     * Provisions a private virtual interface to be owned by the specified Amazon Web Services account.
     *
     * Virtual interfaces created using this action must be confirmed by the owner using ConfirmPrivateVirtualInterface. Until then, the virtual interface is in the `Confirming` state and is not available to handle traffic.
     */
    suspend fun allocatePrivateVirtualInterface(input: AllocatePrivateVirtualInterfaceRequest): AllocatePrivateVirtualInterfaceResponse

    /**
     * Provisions a private virtual interface to be owned by the specified Amazon Web Services account.
     *
     * Virtual interfaces created using this action must be confirmed by the owner using ConfirmPrivateVirtualInterface. Until then, the virtual interface is in the `Confirming` state and is not available to handle traffic.
     */
    suspend fun allocatePrivateVirtualInterface(block: AllocatePrivateVirtualInterfaceRequest.Builder.() -> Unit) = allocatePrivateVirtualInterface(AllocatePrivateVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Provisions a public virtual interface to be owned by the specified Amazon Web Services account.
     *
     * The owner of a connection calls this function to provision a public virtual interface to be owned by the specified Amazon Web Services account.
     *
     * Virtual interfaces created using this function must be confirmed by the owner using ConfirmPublicVirtualInterface. Until this step has been completed, the virtual interface is in the `confirming` state and is not available to handle traffic.
     *
     * When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     */
    suspend fun allocatePublicVirtualInterface(input: AllocatePublicVirtualInterfaceRequest): AllocatePublicVirtualInterfaceResponse

    /**
     * Provisions a public virtual interface to be owned by the specified Amazon Web Services account.
     *
     * The owner of a connection calls this function to provision a public virtual interface to be owned by the specified Amazon Web Services account.
     *
     * Virtual interfaces created using this function must be confirmed by the owner using ConfirmPublicVirtualInterface. Until this step has been completed, the virtual interface is in the `confirming` state and is not available to handle traffic.
     *
     * When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     */
    suspend fun allocatePublicVirtualInterface(block: AllocatePublicVirtualInterfaceRequest.Builder.() -> Unit) = allocatePublicVirtualInterface(AllocatePublicVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of interface to connect a transit gateway to your Direct Connect gateway.
     *
     * The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services account.
     *
     * After you create a transit virtual interface, it must be confirmed by the owner using ConfirmTransitVirtualInterface. Until this step has been completed, the transit virtual interface is in the `requested` state and is not available to handle traffic.
     */
    suspend fun allocateTransitVirtualInterface(input: AllocateTransitVirtualInterfaceRequest): AllocateTransitVirtualInterfaceResponse

    /**
     * Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of interface to connect a transit gateway to your Direct Connect gateway.
     *
     * The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services account.
     *
     * After you create a transit virtual interface, it must be confirmed by the owner using ConfirmTransitVirtualInterface. Until this step has been completed, the transit virtual interface is in the `requested` state and is not available to handle traffic.
     */
    suspend fun allocateTransitVirtualInterface(block: AllocateTransitVirtualInterfaceRequest.Builder.() -> Unit) = allocateTransitVirtualInterface(AllocateTransitVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG. You can re-associate a connection that's currently associated with a different LAG; however, if removing the connection would cause the original LAG to fall below its setting for minimum number of operational connections, the request fails.
     *
     * Any virtual interfaces that are directly associated with the connection are automatically re-associated with the LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated with the original LAG.
     *
     * For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was originally associated with a different LAG, the hosted connections remain associated with the original LAG.
     */
    suspend fun associateConnectionWithLag(input: AssociateConnectionWithLagRequest): AssociateConnectionWithLagResponse

    /**
     * Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG. You can re-associate a connection that's currently associated with a different LAG; however, if removing the connection would cause the original LAG to fall below its setting for minimum number of operational connections, the request fails.
     *
     * Any virtual interfaces that are directly associated with the connection are automatically re-associated with the LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated with the original LAG.
     *
     * For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was originally associated with a different LAG, the hosted connections remain associated with the original LAG.
     */
    suspend fun associateConnectionWithLag(block: AssociateConnectionWithLagRequest.Builder.() -> Unit) = associateConnectionWithLag(AssociateConnectionWithLagRequest.Builder().apply(block).build())

    /**
     * Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address, the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web Services as it is being migrated.
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun associateHostedConnection(input: AssociateHostedConnectionRequest): AssociateHostedConnectionResponse

    /**
     * Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address, the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web Services as it is being migrated.
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun associateHostedConnection(block: AssociateHostedConnectionRequest.Builder.() -> Unit) = associateHostedConnection(AssociateHostedConnectionRequest.Builder().apply(block).build())

    /**
     * Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection.
     *
     * You must supply either the `secretARN,` or the CKN/CAK (`ckn` and `cak`) pair in the request.
     *
     * For information about MAC Security (MACsec) key considerations, see [MACsec pre-shared CKN/CAK key considerations ](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration) in the *Direct Connect User Guide*.
     */
    suspend fun associateMacSecKey(input: AssociateMacSecKeyRequest): AssociateMacSecKeyResponse

    /**
     * Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection.
     *
     * You must supply either the `secretARN,` or the CKN/CAK (`ckn` and `cak`) pair in the request.
     *
     * For information about MAC Security (MACsec) key considerations, see [MACsec pre-shared CKN/CAK key considerations ](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration) in the *Direct Connect User Guide*.
     */
    suspend fun associateMacSecKey(block: AssociateMacSecKeyRequest.Builder.() -> Unit) = associateMacSecKey(AssociateMacSecKeyRequest.Builder().apply(block).build())

    /**
     * Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address, the operation fails.
     *
     * Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must be migrated along with their virtual interfaces using AssociateHostedConnection.
     *
     * To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual interface itself or the connection to which the virtual interface is currently associated. Additionally, the requester must own the connection or LAG for the association.
     */
    suspend fun associateVirtualInterface(input: AssociateVirtualInterfaceRequest): AssociateVirtualInterfaceResponse

    /**
     * Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address, the operation fails.
     *
     * Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must be migrated along with their virtual interfaces using AssociateHostedConnection.
     *
     * To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual interface itself or the connection to which the virtual interface is currently associated. Additionally, the requester must own the connection or LAG for the association.
     */
    suspend fun associateVirtualInterface(block: AssociateVirtualInterfaceRequest.Builder.() -> Unit) = associateVirtualInterface(AssociateVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Confirms the creation of the specified hosted connection on an interconnect.
     *
     * Upon creation, the hosted connection is initially in the `Ordering` state, and remains in this state until the owner confirms creation of the hosted connection.
     */
    suspend fun confirmConnection(input: ConfirmConnectionRequest): ConfirmConnectionResponse

    /**
     * Confirms the creation of the specified hosted connection on an interconnect.
     *
     * Upon creation, the hosted connection is initially in the `Ordering` state, and remains in this state until the owner confirms creation of the hosted connection.
     */
    suspend fun confirmConnection(block: ConfirmConnectionRequest.Builder.() -> Unit) = confirmConnection(ConfirmConnectionRequest.Builder().apply(block).build())

    /**
     * The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
     */
    suspend fun confirmCustomerAgreement(input: ConfirmCustomerAgreementRequest = ConfirmCustomerAgreementRequest {}): ConfirmCustomerAgreementResponse

    /**
     * The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
     */
    suspend fun confirmCustomerAgreement(block: ConfirmCustomerAgreementRequest.Builder.() -> Unit) = confirmCustomerAgreement(ConfirmCustomerAgreementRequest.Builder().apply(block).build())

    /**
     * Accepts ownership of a private virtual interface created by another Amazon Web Services account.
     *
     * After the virtual interface owner makes this call, the virtual interface is created and attached to the specified virtual private gateway or Direct Connect gateway, and is made available to handle traffic.
     */
    suspend fun confirmPrivateVirtualInterface(input: ConfirmPrivateVirtualInterfaceRequest): ConfirmPrivateVirtualInterfaceResponse

    /**
     * Accepts ownership of a private virtual interface created by another Amazon Web Services account.
     *
     * After the virtual interface owner makes this call, the virtual interface is created and attached to the specified virtual private gateway or Direct Connect gateway, and is made available to handle traffic.
     */
    suspend fun confirmPrivateVirtualInterface(block: ConfirmPrivateVirtualInterfaceRequest.Builder.() -> Unit) = confirmPrivateVirtualInterface(ConfirmPrivateVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Accepts ownership of a public virtual interface created by another Amazon Web Services account.
     *
     * After the virtual interface owner makes this call, the specified virtual interface is created and made available to handle traffic.
     */
    suspend fun confirmPublicVirtualInterface(input: ConfirmPublicVirtualInterfaceRequest): ConfirmPublicVirtualInterfaceResponse

    /**
     * Accepts ownership of a public virtual interface created by another Amazon Web Services account.
     *
     * After the virtual interface owner makes this call, the specified virtual interface is created and made available to handle traffic.
     */
    suspend fun confirmPublicVirtualInterface(block: ConfirmPublicVirtualInterfaceRequest.Builder.() -> Unit) = confirmPublicVirtualInterface(ConfirmPublicVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Accepts ownership of a transit virtual interface created by another Amazon Web Services account.
     *
     *  After the owner of the transit virtual interface makes this call, the specified transit virtual interface is created and made available to handle traffic.
     */
    suspend fun confirmTransitVirtualInterface(input: ConfirmTransitVirtualInterfaceRequest): ConfirmTransitVirtualInterfaceResponse

    /**
     * Accepts ownership of a transit virtual interface created by another Amazon Web Services account.
     *
     *  After the owner of the transit virtual interface makes this call, the specified transit virtual interface is created and made available to handle traffic.
     */
    suspend fun confirmTransitVirtualInterface(block: ConfirmTransitVirtualInterfaceRequest.Builder.() -> Unit) = confirmTransitVirtualInterface(ConfirmTransitVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Creates a BGP peer on the specified virtual interface.
     *
     * You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web Services resources that also use that address family.
     *
     * If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the same address family as an existing BGP peer on the virtual interface.
     *
     * When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     *
     * For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list for the virtual interface.
     */
    suspend fun createBgpPeer(input: CreateBgpPeerRequest = CreateBgpPeerRequest {}): CreateBgpPeerResponse

    /**
     * Creates a BGP peer on the specified virtual interface.
     *
     * You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web Services resources that also use that address family.
     *
     * If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the same address family as an existing BGP peer on the virtual interface.
     *
     * When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     *
     * For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list for the virtual interface.
     */
    suspend fun createBgpPeer(block: CreateBgpPeerRequest.Builder.() -> Unit) = createBgpPeer(CreateBgpPeerRequest.Builder().apply(block).build())

    /**
     * Creates a connection between a customer network and a specific Direct Connect location.
     *
     * A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end of the cable is connected to your router, the other to an Direct Connect router.
     *
     * To find the locations for your Region, use DescribeLocations.
     *
     * You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.
     */
    suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse

    /**
     * Creates a connection between a customer network and a specific Direct Connect location.
     *
     * A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end of the cable is connected to your router, the other to an Direct Connect router.
     *
     * To find the locations for your Region, use DescribeLocations.
     *
     * You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.
     */
    suspend fun createConnection(block: CreateConnectionRequest.Builder.() -> Unit) = createConnection(CreateConnectionRequest.Builder().apply(block).build())

    /**
     * Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web Services Region after it is created. The virtual interfaces and virtual private gateways that are connected through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic between them.
     */
    suspend fun createDirectConnectGateway(input: CreateDirectConnectGatewayRequest): CreateDirectConnectGatewayResponse

    /**
     * Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web Services Region after it is created. The virtual interfaces and virtual private gateways that are connected through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic between them.
     */
    suspend fun createDirectConnectGateway(block: CreateDirectConnectGatewayRequest.Builder.() -> Unit) = createDirectConnectGateway(CreateDirectConnectGatewayRequest.Builder().apply(block).build())

    /**
     * Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
     */
    suspend fun createDirectConnectGatewayAssociation(input: CreateDirectConnectGatewayAssociationRequest): CreateDirectConnectGatewayAssociationResponse

    /**
     * Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
     */
    suspend fun createDirectConnectGatewayAssociation(block: CreateDirectConnectGatewayAssociationRequest.Builder.() -> Unit) = createDirectConnectGatewayAssociation(CreateDirectConnectGatewayAssociationRequest.Builder().apply(block).build())

    /**
     * Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified Direct Connect gateway.
     *
     * You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any Amazon Web Services account.
     */
    suspend fun createDirectConnectGatewayAssociationProposal(input: CreateDirectConnectGatewayAssociationProposalRequest): CreateDirectConnectGatewayAssociationProposalResponse

    /**
     * Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified Direct Connect gateway.
     *
     * You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any Amazon Web Services account.
     */
    suspend fun createDirectConnectGatewayAssociationProposal(block: CreateDirectConnectGatewayAssociationProposalRequest.Builder.() -> Unit) = createDirectConnectGatewayAssociationProposal(CreateDirectConnectGatewayAssociationProposalRequest.Builder().apply(block).build())

    /**
     * Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
     *
     * An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use an interconnect to provide Direct Connect hosted connections to customers through their own network services. Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect router.
     *
     * You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.
     *
     * For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling AllocateHostedConnection. The end customer can then connect to Amazon Web Services resources by creating a virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun createInterconnect(input: CreateInterconnectRequest): CreateInterconnectResponse

    /**
     * Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
     *
     * An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use an interconnect to provide Direct Connect hosted connections to customers through their own network services. Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect router.
     *
     * You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.
     *
     * For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling AllocateHostedConnection. The end customer can then connect to Amazon Web Services resources by creating a virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun createInterconnect(block: CreateInterconnectRequest.Builder.() -> Unit) = createInterconnect(CreateInterconnectRequest.Builder().apply(block).build())

    /**
     * Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single interface.
     *
     * All connections in a LAG must use the same bandwidth (either 1Gbps or 10Gbps) and must terminate at the same Direct Connect endpoint.
     *
     * You can have up to 10 dedicated connections per LAG. Regardless of this limit, if you request more connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created.
     *
     * You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts towards the total number of connections). Doing so interrupts the current physical dedicated connection, and re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are automatically disassociated and re-associated with the LAG. The connection ID does not change.
     *
     * If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces cannot be directly configured.
     */
    suspend fun createLag(input: CreateLagRequest): CreateLagResponse

    /**
     * Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single interface.
     *
     * All connections in a LAG must use the same bandwidth (either 1Gbps or 10Gbps) and must terminate at the same Direct Connect endpoint.
     *
     * You can have up to 10 dedicated connections per LAG. Regardless of this limit, if you request more connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created.
     *
     * You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts towards the total number of connections). Doing so interrupts the current physical dedicated connection, and re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are automatically disassociated and re-associated with the LAG. The connection ID does not change.
     *
     * If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces cannot be directly configured.
     */
    suspend fun createLag(block: CreateLagRequest.Builder.() -> Unit) = createLag(CreateLagRequest.Builder().apply(block).build())

    /**
     * Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW). Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface to a VGW only provides access to a single VPC within the same Region.
     *
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    suspend fun createPrivateVirtualInterface(input: CreatePrivateVirtualInterfaceRequest): CreatePrivateVirtualInterfaceResponse

    /**
     * Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW). Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface to a VGW only provides access to a single VPC within the same Region.
     *
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    suspend fun createPrivateVirtualInterface(block: CreatePrivateVirtualInterfaceRequest.Builder.() -> Unit) = createPrivateVirtualInterface(CreatePrivateVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
     *
     * When creating an IPv6 public virtual interface (`addressFamily` is `ipv6`), leave the `customer` and `amazon` address fields blank to use auto-assigned IPv6 space. Custom IPv6 addresses are not supported.
     */
    suspend fun createPublicVirtualInterface(input: CreatePublicVirtualInterfaceRequest): CreatePublicVirtualInterfaceResponse

    /**
     * Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
     *
     * When creating an IPv6 public virtual interface (`addressFamily` is `ipv6`), leave the `customer` and `amazon` address fields blank to use auto-assigned IPv6 space. Custom IPv6 addresses are not supported.
     */
    suspend fun createPublicVirtualInterface(block: CreatePublicVirtualInterfaceRequest.Builder.() -> Unit) = createPublicVirtualInterface(CreatePublicVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple VPCs attached to a transit gateway to a Direct Connect gateway.
     *
     * If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.
     *
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    suspend fun createTransitVirtualInterface(input: CreateTransitVirtualInterfaceRequest): CreateTransitVirtualInterfaceResponse

    /**
     * Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple VPCs attached to a transit gateway to a Direct Connect gateway.
     *
     * If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.
     *
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    suspend fun createTransitVirtualInterface(block: CreateTransitVirtualInterfaceRequest.Builder.() -> Unit) = createTransitVirtualInterface(CreateTransitVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
     *
     * You cannot delete the last BGP peer from a virtual interface.
     */
    suspend fun deleteBgpPeer(input: DeleteBgpPeerRequest = DeleteBgpPeerRequest {}): DeleteBgpPeerResponse

    /**
     * Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
     *
     * You cannot delete the last BGP peer from a virtual interface.
     */
    suspend fun deleteBgpPeer(block: DeleteBgpPeerRequest.Builder.() -> Unit) = deleteBgpPeer(DeleteBgpPeerRequest.Builder().apply(block).build())

    /**
     * Deletes the specified connection.
     *
     * Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering with any third parties to connect with the Direct Connect location, you must cancel your service with them separately.
     */
    suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * Deletes the specified connection.
     *
     * Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering with any third parties to connect with the Direct Connect location, you must cancel your service with them separately.
     */
    suspend fun deleteConnection(block: DeleteConnectionRequest.Builder.() -> Unit) = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect gateway.
     */
    suspend fun deleteDirectConnectGateway(input: DeleteDirectConnectGatewayRequest): DeleteDirectConnectGatewayResponse

    /**
     * Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect gateway.
     */
    suspend fun deleteDirectConnectGateway(block: DeleteDirectConnectGatewayRequest.Builder.() -> Unit) = deleteDirectConnectGateway(DeleteDirectConnectGatewayRequest.Builder().apply(block).build())

    /**
     * Deletes the association between the specified Direct Connect gateway and virtual private gateway.
     *
     * We recommend that you specify the `associationID` to delete the association. Alternatively, if you own virtual gateway and a Direct Connect gateway association, you can specify the `virtualGatewayId` and `directConnectGatewayId` to delete an association.
     */
    suspend fun deleteDirectConnectGatewayAssociation(input: DeleteDirectConnectGatewayAssociationRequest = DeleteDirectConnectGatewayAssociationRequest {}): DeleteDirectConnectGatewayAssociationResponse

    /**
     * Deletes the association between the specified Direct Connect gateway and virtual private gateway.
     *
     * We recommend that you specify the `associationID` to delete the association. Alternatively, if you own virtual gateway and a Direct Connect gateway association, you can specify the `virtualGatewayId` and `directConnectGatewayId` to delete an association.
     */
    suspend fun deleteDirectConnectGatewayAssociation(block: DeleteDirectConnectGatewayAssociationRequest.Builder.() -> Unit) = deleteDirectConnectGatewayAssociation(DeleteDirectConnectGatewayAssociationRequest.Builder().apply(block).build())

    /**
     * Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway or transit gateway.
     */
    suspend fun deleteDirectConnectGatewayAssociationProposal(input: DeleteDirectConnectGatewayAssociationProposalRequest): DeleteDirectConnectGatewayAssociationProposalResponse

    /**
     * Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway or transit gateway.
     */
    suspend fun deleteDirectConnectGatewayAssociationProposal(block: DeleteDirectConnectGatewayAssociationProposalRequest.Builder.() -> Unit) = deleteDirectConnectGatewayAssociationProposal(DeleteDirectConnectGatewayAssociationProposalRequest.Builder().apply(block).build())

    /**
     * Deletes the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun deleteInterconnect(input: DeleteInterconnectRequest): DeleteInterconnectResponse

    /**
     * Deletes the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun deleteInterconnect(block: DeleteInterconnectRequest.Builder.() -> Unit) = deleteInterconnect(DeleteInterconnectRequest.Builder().apply(block).build())

    /**
     * Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces or hosted connections.
     */
    suspend fun deleteLag(input: DeleteLagRequest): DeleteLagResponse

    /**
     * Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces or hosted connections.
     */
    suspend fun deleteLag(block: DeleteLagRequest.Builder.() -> Unit) = deleteLag(DeleteLagRequest.Builder().apply(block).build())

    /**
     * Deletes a virtual interface.
     */
    suspend fun deleteVirtualInterface(input: DeleteVirtualInterfaceRequest): DeleteVirtualInterfaceResponse

    /**
     * Deletes a virtual interface.
     */
    suspend fun deleteVirtualInterface(block: DeleteVirtualInterfaceRequest.Builder.() -> Unit) = deleteVirtualInterface(DeleteVirtualInterfaceRequest.Builder().apply(block).build())

    /**
     * Deprecated. Use DescribeLoa instead.
     *
     * Gets the LOA-CFA for a connection.
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that your APN partner or service provider uses when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeConnectionLoa(input: DescribeConnectionLoaRequest): DescribeConnectionLoaResponse

    /**
     * Deprecated. Use DescribeLoa instead.
     *
     * Gets the LOA-CFA for a connection.
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that your APN partner or service provider uses when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeConnectionLoa(block: DescribeConnectionLoaRequest.Builder.() -> Unit) = describeConnectionLoa(DescribeConnectionLoaRequest.Builder().apply(block).build())

    /**
     * Displays the specified connection or all connections in this Region.
     */
    suspend fun describeConnections(input: DescribeConnectionsRequest = DescribeConnectionsRequest {}): DescribeConnectionsResponse

    /**
     * Displays the specified connection or all connections in this Region.
     */
    suspend fun describeConnections(block: DescribeConnectionsRequest.Builder.() -> Unit) = describeConnections(DescribeConnectionsRequest.Builder().apply(block).build())

    /**
     * Deprecated. Use DescribeHostedConnections instead.
     *
     * Lists the connections that have been provisioned on the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeConnectionsOnInterconnect(input: DescribeConnectionsOnInterconnectRequest): DescribeConnectionsOnInterconnectResponse

    /**
     * Deprecated. Use DescribeHostedConnections instead.
     *
     * Lists the connections that have been provisioned on the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeConnectionsOnInterconnect(block: DescribeConnectionsOnInterconnectRequest.Builder.() -> Unit) = describeConnectionsOnInterconnect(DescribeConnectionsOnInterconnectRequest.Builder().apply(block).build())

    /**
     * Get and view a list of customer agreements, along with their signed status and whether the customer is an NNIPartner, NNIPartnerV2, or a nonPartner.
     */
    suspend fun describeCustomerMetadata(input: DescribeCustomerMetadataRequest = DescribeCustomerMetadataRequest {}): DescribeCustomerMetadataResponse

    /**
     * Get and view a list of customer agreements, along with their signed status and whether the customer is an NNIPartner, NNIPartnerV2, or a nonPartner.
     */
    suspend fun describeCustomerMetadata(block: DescribeCustomerMetadataRequest.Builder.() -> Unit) = describeCustomerMetadata(DescribeCustomerMetadataRequest.Builder().apply(block).build())

    /**
     * Describes one or more association proposals for connection between a virtual private gateway or transit gateway and a Direct Connect gateway.
     */
    suspend fun describeDirectConnectGatewayAssociationProposals(input: DescribeDirectConnectGatewayAssociationProposalsRequest = DescribeDirectConnectGatewayAssociationProposalsRequest {}): DescribeDirectConnectGatewayAssociationProposalsResponse

    /**
     * Describes one or more association proposals for connection between a virtual private gateway or transit gateway and a Direct Connect gateway.
     */
    suspend fun describeDirectConnectGatewayAssociationProposals(block: DescribeDirectConnectGatewayAssociationProposalsRequest.Builder.() -> Unit) = describeDirectConnectGatewayAssociationProposals(DescribeDirectConnectGatewayAssociationProposalsRequest.Builder().apply(block).build())

    /**
     * Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:
     * + A Direct Connect gatewayThe response contains all virtual private gateways and transit gateways associated with the Direct Connect gateway.
     * + A virtual private gatewayThe response contains the Direct Connect gateway.
     * + A transit gatewayThe response contains the Direct Connect gateway.
     * + A Direct Connect gateway and a virtual private gatewayThe response contains the association between the Direct Connect gateway and virtual private gateway.
     * + A Direct Connect gateway and a transit gatewayThe response contains the association between the Direct Connect gateway and transit gateway.
     */
    suspend fun describeDirectConnectGatewayAssociations(input: DescribeDirectConnectGatewayAssociationsRequest = DescribeDirectConnectGatewayAssociationsRequest {}): DescribeDirectConnectGatewayAssociationsResponse

    /**
     * Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:
     * + A Direct Connect gatewayThe response contains all virtual private gateways and transit gateways associated with the Direct Connect gateway.
     * + A virtual private gatewayThe response contains the Direct Connect gateway.
     * + A transit gatewayThe response contains the Direct Connect gateway.
     * + A Direct Connect gateway and a virtual private gatewayThe response contains the association between the Direct Connect gateway and virtual private gateway.
     * + A Direct Connect gateway and a transit gatewayThe response contains the association between the Direct Connect gateway and transit gateway.
     */
    suspend fun describeDirectConnectGatewayAssociations(block: DescribeDirectConnectGatewayAssociationsRequest.Builder.() -> Unit) = describeDirectConnectGatewayAssociations(DescribeDirectConnectGatewayAssociationsRequest.Builder().apply(block).build())

    /**
     * Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response contains the attachment between the Direct Connect gateway and the virtual interface.
     */
    suspend fun describeDirectConnectGatewayAttachments(input: DescribeDirectConnectGatewayAttachmentsRequest = DescribeDirectConnectGatewayAttachmentsRequest {}): DescribeDirectConnectGatewayAttachmentsResponse

    /**
     * Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response contains the attachment between the Direct Connect gateway and the virtual interface.
     */
    suspend fun describeDirectConnectGatewayAttachments(block: DescribeDirectConnectGatewayAttachmentsRequest.Builder.() -> Unit) = describeDirectConnectGatewayAttachments(DescribeDirectConnectGatewayAttachmentsRequest.Builder().apply(block).build())

    /**
     * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect gateways are not returned.
     */
    suspend fun describeDirectConnectGateways(input: DescribeDirectConnectGatewaysRequest = DescribeDirectConnectGatewaysRequest {}): DescribeDirectConnectGatewaysResponse

    /**
     * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect gateways are not returned.
     */
    suspend fun describeDirectConnectGateways(block: DescribeDirectConnectGatewaysRequest.Builder.() -> Unit) = describeDirectConnectGateways(DescribeDirectConnectGatewaysRequest.Builder().apply(block).build())

    /**
     * Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group (LAG).
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun describeHostedConnections(input: DescribeHostedConnectionsRequest): DescribeHostedConnectionsResponse

    /**
     * Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group (LAG).
     *
     * Intended for use by Direct Connect Partners only.
     */
    suspend fun describeHostedConnections(block: DescribeHostedConnectionsRequest.Builder.() -> Unit) = describeHostedConnections(DescribeHostedConnectionsRequest.Builder().apply(block).build())

    /**
     * Deprecated. Use DescribeLoa instead.
     *
     * Gets the LOA-CFA for the specified interconnect.
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeInterconnectLoa(input: DescribeInterconnectLoaRequest): DescribeInterconnectLoaResponse

    /**
     * Deprecated. Use DescribeLoa instead.
     *
     * Gets the LOA-CFA for the specified interconnect.
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeInterconnectLoa(block: DescribeInterconnectLoaRequest.Builder.() -> Unit) = describeInterconnectLoa(DescribeInterconnectLoaRequest.Builder().apply(block).build())

    /**
     * Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
     */
    suspend fun describeInterconnects(input: DescribeInterconnectsRequest = DescribeInterconnectsRequest {}): DescribeInterconnectsResponse

    /**
     * Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
     */
    suspend fun describeInterconnects(block: DescribeInterconnectsRequest.Builder.() -> Unit) = describeInterconnects(DescribeInterconnectsRequest.Builder().apply(block).build())

    /**
     * Describes all your link aggregation groups (LAG) or the specified LAG.
     */
    suspend fun describeLags(input: DescribeLagsRequest = DescribeLagsRequest {}): DescribeLagsResponse

    /**
     * Describes all your link aggregation groups (LAG) or the specified LAG.
     */
    suspend fun describeLags(block: DescribeLagsRequest.Builder.() -> Unit) = describeLags(DescribeLagsRequest.Builder().apply(block).build())

    /**
     * Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    suspend fun describeLoa(input: DescribeLoaRequest): DescribeLoaResponse

    /**
     * Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    suspend fun describeLoa(block: DescribeLoaRequest.Builder.() -> Unit) = describeLoa(DescribeLoaRequest.Builder().apply(block).build())

    /**
     * Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be selected when calling CreateConnection or CreateInterconnect.
     */
    suspend fun describeLocations(input: DescribeLocationsRequest = DescribeLocationsRequest {}): DescribeLocationsResponse

    /**
     * Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be selected when calling CreateConnection or CreateInterconnect.
     */
    suspend fun describeLocations(block: DescribeLocationsRequest.Builder.() -> Unit) = describeLocations(DescribeLocationsRequest.Builder().apply(block).build())

    /**
     * Details about the router.
     */
    suspend fun describeRouterConfiguration(input: DescribeRouterConfigurationRequest): DescribeRouterConfigurationResponse

    /**
     * Details about the router.
     */
    suspend fun describeRouterConfiguration(block: DescribeRouterConfigurationRequest.Builder.() -> Unit) = describeRouterConfiguration(DescribeRouterConfigurationRequest.Builder().apply(block).build())

    /**
     * Describes the tags associated with the specified Direct Connect resources.
     */
    suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Describes the tags associated with the specified Direct Connect resources.
     */
    suspend fun describeTags(block: DescribeTagsRequest.Builder.() -> Unit) = describeTags(DescribeTagsRequest.Builder().apply(block).build())

    /**
     * Lists the virtual private gateways owned by the Amazon Web Services account.
     *
     * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
     */
    suspend fun describeVirtualGateways(input: DescribeVirtualGatewaysRequest = DescribeVirtualGatewaysRequest {}): DescribeVirtualGatewaysResponse

    /**
     * Lists the virtual private gateways owned by the Amazon Web Services account.
     *
     * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
     */
    suspend fun describeVirtualGateways(block: DescribeVirtualGatewaysRequest.Builder.() -> Unit) = describeVirtualGateways(DescribeVirtualGatewaysRequest.Builder().apply(block).build())

    /**
     * Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15 minutes before you make the request are also returned. If you specify a connection ID, only the virtual interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single virtual interface is returned.
     *
     * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
     */
    suspend fun describeVirtualInterfaces(input: DescribeVirtualInterfacesRequest = DescribeVirtualInterfacesRequest {}): DescribeVirtualInterfacesResponse

    /**
     * Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15 minutes before you make the request are also returned. If you specify a connection ID, only the virtual interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single virtual interface is returned.
     *
     * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
     */
    suspend fun describeVirtualInterfaces(block: DescribeVirtualInterfacesRequest.Builder.() -> Unit) = describeVirtualInterfaces(DescribeVirtualInterfacesRequest.Builder().apply(block).build())

    /**
     * Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established as a standalone connection (the connection is not deleted; to delete the connection, use the DeleteConnection request). If the LAG has associated virtual interfaces or hosted connections, they remain associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted to an interconnect.
     *
     * If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational connections, the request fails, except when it's the last member of the LAG. If all connections are disassociated, the LAG continues to exist as an empty LAG with no physical connections.
     */
    suspend fun disassociateConnectionFromLag(input: DisassociateConnectionFromLagRequest): DisassociateConnectionFromLagResponse

    /**
     * Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established as a standalone connection (the connection is not deleted; to delete the connection, use the DeleteConnection request). If the LAG has associated virtual interfaces or hosted connections, they remain associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted to an interconnect.
     *
     * If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational connections, the request fails, except when it's the last member of the LAG. If all connections are disassociated, the LAG continues to exist as an empty LAG with no physical connections.
     */
    suspend fun disassociateConnectionFromLag(block: DisassociateConnectionFromLagRequest.Builder.() -> Unit) = disassociateConnectionFromLag(DisassociateConnectionFromLagRequest.Builder().apply(block).build())

    /**
     * Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.
     */
    suspend fun disassociateMacSecKey(input: DisassociateMacSecKeyRequest): DisassociateMacSecKeyResponse

    /**
     * Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.
     */
    suspend fun disassociateMacSecKey(block: DisassociateMacSecKeyRequest.Builder.() -> Unit) = disassociateMacSecKey(DisassociateMacSecKeyRequest.Builder().apply(block).build())

    /**
     * Lists the virtual interface failover test history.
     */
    suspend fun listVirtualInterfaceTestHistory(input: ListVirtualInterfaceTestHistoryRequest = ListVirtualInterfaceTestHistoryRequest {}): ListVirtualInterfaceTestHistoryResponse

    /**
     * Lists the virtual interface failover test history.
     */
    suspend fun listVirtualInterfaceTestHistory(block: ListVirtualInterfaceTestHistoryRequest.Builder.() -> Unit) = listVirtualInterfaceTestHistory(ListVirtualInterfaceTestHistoryRequest.Builder().apply(block).build())

    /**
     * Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
     *
     * You can run the test on public, private, transit, and hosted virtual interfaces.
     *
     * You can use [ListVirtualInterfaceTestHistory](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html) to view the virtual interface test history.
     *
     * If you need to stop the test before the test interval completes, use [StopBgpFailoverTest](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html).
     */
    suspend fun startBgpFailoverTest(input: StartBgpFailoverTestRequest): StartBgpFailoverTestResponse

    /**
     * Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
     *
     * You can run the test on public, private, transit, and hosted virtual interfaces.
     *
     * You can use [ListVirtualInterfaceTestHistory](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html) to view the virtual interface test history.
     *
     * If you need to stop the test before the test interval completes, use [StopBgpFailoverTest](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html).
     */
    suspend fun startBgpFailoverTest(block: StartBgpFailoverTestRequest.Builder.() -> Unit) = startBgpFailoverTest(StartBgpFailoverTestRequest.Builder().apply(block).build())

    /**
     * Stops the virtual interface failover test.
     */
    suspend fun stopBgpFailoverTest(input: StopBgpFailoverTestRequest): StopBgpFailoverTestResponse

    /**
     * Stops the virtual interface failover test.
     */
    suspend fun stopBgpFailoverTest(block: StopBgpFailoverTestRequest.Builder.() -> Unit) = stopBgpFailoverTest(StopBgpFailoverTestRequest.Builder().apply(block).build())

    /**
     * Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from the specified Direct Connect resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from the specified Direct Connect resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the Direct Connect dedicated connection configuration.
     *
     * You can update the following parameters for a connection:
     * + The connection name
     * + The connection's MAC Security (MACsec) encryption mode.
     */
    suspend fun updateConnection(input: UpdateConnectionRequest): UpdateConnectionResponse

    /**
     * Updates the Direct Connect dedicated connection configuration.
     *
     * You can update the following parameters for a connection:
     * + The connection name
     * + The connection's MAC Security (MACsec) encryption mode.
     */
    suspend fun updateConnection(block: UpdateConnectionRequest.Builder.() -> Unit) = updateConnection(UpdateConnectionRequest.Builder().apply(block).build())

    /**
     * Updates the name of a current Direct Connect gateway.
     */
    suspend fun updateDirectConnectGateway(input: UpdateDirectConnectGatewayRequest): UpdateDirectConnectGatewayResponse

    /**
     * Updates the name of a current Direct Connect gateway.
     */
    suspend fun updateDirectConnectGateway(block: UpdateDirectConnectGatewayRequest.Builder.() -> Unit) = updateDirectConnectGateway(UpdateDirectConnectGatewayRequest.Builder().apply(block).build())

    /**
     * Updates the specified attributes of the Direct Connect gateway association.
     *
     * Add or remove prefixes from the association.
     */
    suspend fun updateDirectConnectGatewayAssociation(input: UpdateDirectConnectGatewayAssociationRequest = UpdateDirectConnectGatewayAssociationRequest {}): UpdateDirectConnectGatewayAssociationResponse

    /**
     * Updates the specified attributes of the Direct Connect gateway association.
     *
     * Add or remove prefixes from the association.
     */
    suspend fun updateDirectConnectGatewayAssociation(block: UpdateDirectConnectGatewayAssociationRequest.Builder.() -> Unit) = updateDirectConnectGatewayAssociation(UpdateDirectConnectGatewayAssociationRequest.Builder().apply(block).build())

    /**
     * Updates the attributes of the specified link aggregation group (LAG).
     *
     * You can update the following LAG attributes:
     * + The name of the LAG.
     * + The value for the minimum number of connections that must be operational for the LAG itself to be operational.
     * + The LAG's MACsec encryption mode.Amazon Web Services assigns this value to each connection which is part of the LAG.
     * + The tags
     *
     * If you adjust the threshold value for the minimum number of operational connections, ensure that the new value does not cause the LAG to fall below the threshold and become non-operational.
     */
    suspend fun updateLag(input: UpdateLagRequest): UpdateLagResponse

    /**
     * Updates the attributes of the specified link aggregation group (LAG).
     *
     * You can update the following LAG attributes:
     * + The name of the LAG.
     * + The value for the minimum number of connections that must be operational for the LAG itself to be operational.
     * + The LAG's MACsec encryption mode.Amazon Web Services assigns this value to each connection which is part of the LAG.
     * + The tags
     *
     * If you adjust the threshold value for the minimum number of operational connections, ensure that the new value does not cause the LAG to fall below the threshold and become non-operational.
     */
    suspend fun updateLag(block: UpdateLagRequest.Builder.() -> Unit) = updateLag(UpdateLagRequest.Builder().apply(block).build())

    /**
     * Updates the specified attributes of the specified virtual private interface.
     *
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual q interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    suspend fun updateVirtualInterfaceAttributes(input: UpdateVirtualInterfaceAttributesRequest): UpdateVirtualInterfaceAttributesResponse

    /**
     * Updates the specified attributes of the specified virtual private interface.
     *
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual q interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    suspend fun updateVirtualInterfaceAttributes(block: UpdateVirtualInterfaceAttributesRequest.Builder.() -> Unit) = updateVirtualInterfaceAttributes(UpdateVirtualInterfaceAttributesRequest.Builder().apply(block).build())
}
