// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



class AssociateMacSecKeyRequest private constructor(builder: Builder) {
    /**
     * The MAC Security (MACsec) CAK to associate with the dedicated connection.
     *
     * You can create the CKN/CAK pair using an industry standard tool.
     *
     *  The valid values are 64 hexadecimal characters (0-9, A-E).
     *
     * If you use this request parameter, you must use the `ckn` request parameter and not use the `secretARN` request parameter.
     */
    val cak: kotlin.String? = builder.cak
    /**
     * The MAC Security (MACsec) CKN to associate with the dedicated connection.
     *
     * You can create the CKN/CAK pair using an industry standard tool.
     *
     *  The valid values are 64 hexadecimal characters (0-9, A-E).
     *
     * If you use this request parameter, you must use the `cak` request parameter and not use the `secretARN` request parameter.
     */
    val ckn: kotlin.String? = builder.ckn
    /**
     * The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
     *
     * You can use DescribeConnections or DescribeLags to retrieve connection ID.
     */
    val connectionId: kotlin.String? = builder.connectionId
    /**
     * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.
     *
     * You can use DescribeConnections or DescribeLags to retrieve the MAC Security (MACsec) secret key.
     *
     * If you use this request parameter, you do not use the `ckn` and `cak` request parameters.
     */
    val secretArn: kotlin.String? = builder.secretArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.AssociateMacSecKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateMacSecKeyRequest(")
        append("cak=$cak,")
        append("ckn=$ckn,")
        append("connectionId=$connectionId,")
        append("secretArn=$secretArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cak?.hashCode() ?: 0
        result = 31 * result + (ckn?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateMacSecKeyRequest

        if (cak != other.cak) return false
        if (ckn != other.ckn) return false
        if (connectionId != other.connectionId) return false
        if (secretArn != other.secretArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.AssociateMacSecKeyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The MAC Security (MACsec) CAK to associate with the dedicated connection.
         *
         * You can create the CKN/CAK pair using an industry standard tool.
         *
         *  The valid values are 64 hexadecimal characters (0-9, A-E).
         *
         * If you use this request parameter, you must use the `ckn` request parameter and not use the `secretARN` request parameter.
         */
        var cak: kotlin.String? = null
        /**
         * The MAC Security (MACsec) CKN to associate with the dedicated connection.
         *
         * You can create the CKN/CAK pair using an industry standard tool.
         *
         *  The valid values are 64 hexadecimal characters (0-9, A-E).
         *
         * If you use this request parameter, you must use the `cak` request parameter and not use the `secretARN` request parameter.
         */
        var ckn: kotlin.String? = null
        /**
         * The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
         *
         * You can use DescribeConnections or DescribeLags to retrieve connection ID.
         */
        var connectionId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key to associate with the dedicated connection.
         *
         * You can use DescribeConnections or DescribeLags to retrieve the MAC Security (MACsec) secret key.
         *
         * If you use this request parameter, you do not use the `ckn` and `cak` request parameters.
         */
        var secretArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.AssociateMacSecKeyRequest) : this() {
            this.cak = x.cak
            this.ckn = x.ckn
            this.connectionId = x.connectionId
            this.secretArn = x.secretArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.AssociateMacSecKeyRequest = AssociateMacSecKeyRequest(this)
    }
}
