// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



class CreateConnectionRequest private constructor(builder: Builder) {
    /**
     * The bandwidth of the connection.
     */
    val bandwidth: kotlin.String? = builder.bandwidth
    /**
     * The name of the connection.
     */
    val connectionName: kotlin.String? = builder.connectionName
    /**
     * The ID of the LAG.
     */
    val lagId: kotlin.String? = builder.lagId
    /**
     * The location of the connection.
     */
    val location: kotlin.String? = builder.location
    /**
     * The name of the service provider associated with the requested connection.
     */
    val providerName: kotlin.String? = builder.providerName
    /**
     * Indicates whether you want the connection to support MAC Security (MACsec).
     *
     * MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see [MACsec prerequisties](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) in the *Direct Connect User Guide*.
     */
    val requestMacSec: kotlin.Boolean? = builder.requestMacSec
    /**
     * The tags to associate with the lag.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.CreateConnectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConnectionRequest(")
        append("bandwidth=$bandwidth,")
        append("connectionName=$connectionName,")
        append("lagId=$lagId,")
        append("location=$location,")
        append("providerName=$providerName,")
        append("requestMacSec=$requestMacSec,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bandwidth?.hashCode() ?: 0
        result = 31 * result + (connectionName?.hashCode() ?: 0)
        result = 31 * result + (lagId?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (requestMacSec?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConnectionRequest

        if (bandwidth != other.bandwidth) return false
        if (connectionName != other.connectionName) return false
        if (lagId != other.lagId) return false
        if (location != other.location) return false
        if (providerName != other.providerName) return false
        if (requestMacSec != other.requestMacSec) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.CreateConnectionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The bandwidth of the connection.
         */
        var bandwidth: kotlin.String? = null
        /**
         * The name of the connection.
         */
        var connectionName: kotlin.String? = null
        /**
         * The ID of the LAG.
         */
        var lagId: kotlin.String? = null
        /**
         * The location of the connection.
         */
        var location: kotlin.String? = null
        /**
         * The name of the service provider associated with the requested connection.
         */
        var providerName: kotlin.String? = null
        /**
         * Indicates whether you want the connection to support MAC Security (MACsec).
         *
         * MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec) prerequisties, see [MACsec prerequisties](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) in the *Direct Connect User Guide*.
         */
        var requestMacSec: kotlin.Boolean? = null
        /**
         * The tags to associate with the lag.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.CreateConnectionRequest) : this() {
            this.bandwidth = x.bandwidth
            this.connectionName = x.connectionName
            this.lagId = x.lagId
            this.location = x.location
            this.providerName = x.providerName
            this.requestMacSec = x.requestMacSec
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.CreateConnectionRequest = CreateConnectionRequest(this)
    }
}
