// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



class CreateLagRequest private constructor(builder: Builder) {
    /**
     * The tags to associate with the automtically created LAGs.
     */
    val childConnectionTags: List<Tag>? = builder.childConnectionTags
    /**
     * The ID of an existing dedicated connection to migrate to the LAG.
     */
    val connectionId: kotlin.String? = builder.connectionId
    /**
     * The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values are 1Gbps and 10Gbps.
     */
    val connectionsBandwidth: kotlin.String? = builder.connectionsBandwidth
    /**
     * The name of the LAG.
     */
    val lagName: kotlin.String? = builder.lagName
    /**
     * The location for the LAG.
     */
    val location: kotlin.String? = builder.location
    /**
     * The number of physical dedicated connections initially provisioned and bundled by the LAG.
     */
    val numberOfConnections: kotlin.Int = builder.numberOfConnections
    /**
     * The name of the service provider associated with the LAG.
     */
    val providerName: kotlin.String? = builder.providerName
    /**
     * Indicates whether the connection will support MAC Security (MACsec).
     *
     * All connections in the LAG must be capable of supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see [MACsec prerequisties](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) in the *Direct Connect User Guide*.
     */
    val requestMacSec: kotlin.Boolean? = builder.requestMacSec
    /**
     * The tags to associate with the LAG.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.CreateLagRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLagRequest(")
        append("childConnectionTags=$childConnectionTags,")
        append("connectionId=$connectionId,")
        append("connectionsBandwidth=$connectionsBandwidth,")
        append("lagName=$lagName,")
        append("location=$location,")
        append("numberOfConnections=$numberOfConnections,")
        append("providerName=$providerName,")
        append("requestMacSec=$requestMacSec,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = childConnectionTags?.hashCode() ?: 0
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (connectionsBandwidth?.hashCode() ?: 0)
        result = 31 * result + (lagName?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (numberOfConnections)
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (requestMacSec?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLagRequest

        if (childConnectionTags != other.childConnectionTags) return false
        if (connectionId != other.connectionId) return false
        if (connectionsBandwidth != other.connectionsBandwidth) return false
        if (lagName != other.lagName) return false
        if (location != other.location) return false
        if (numberOfConnections != other.numberOfConnections) return false
        if (providerName != other.providerName) return false
        if (requestMacSec != other.requestMacSec) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.CreateLagRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The tags to associate with the automtically created LAGs.
         */
        var childConnectionTags: List<Tag>? = null
        /**
         * The ID of an existing dedicated connection to migrate to the LAG.
         */
        var connectionId: kotlin.String? = null
        /**
         * The bandwidth of the individual physical dedicated connections bundled by the LAG. The possible values are 1Gbps and 10Gbps.
         */
        var connectionsBandwidth: kotlin.String? = null
        /**
         * The name of the LAG.
         */
        var lagName: kotlin.String? = null
        /**
         * The location for the LAG.
         */
        var location: kotlin.String? = null
        /**
         * The number of physical dedicated connections initially provisioned and bundled by the LAG.
         */
        var numberOfConnections: kotlin.Int = 0
        /**
         * The name of the service provider associated with the LAG.
         */
        var providerName: kotlin.String? = null
        /**
         * Indicates whether the connection will support MAC Security (MACsec).
         *
         * All connections in the LAG must be capable of supporting MAC Security (MACsec). For information about MAC Security (MACsec) prerequisties, see [MACsec prerequisties](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) in the *Direct Connect User Guide*.
         */
        var requestMacSec: kotlin.Boolean? = null
        /**
         * The tags to associate with the LAG.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.CreateLagRequest) : this() {
            this.childConnectionTags = x.childConnectionTags
            this.connectionId = x.connectionId
            this.connectionsBandwidth = x.connectionsBandwidth
            this.lagName = x.lagName
            this.location = x.location
            this.numberOfConnections = x.numberOfConnections
            this.providerName = x.providerName
            this.requestMacSec = x.requestMacSec
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.CreateLagRequest = CreateLagRequest(this)
    }
}
