// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an interconnect.
 */
class Interconnect private constructor(builder: Builder) {
    /**
     * The Direct Connect endpoint on which the physical connection terminates.
     */
    val awsDevice: kotlin.String? = builder.awsDevice
    /**
     * The Direct Connect endpoint that terminates the physical connection.
     */
    val awsDeviceV2: kotlin.String? = builder.awsDeviceV2
    /**
     * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
     */
    val awsLogicalDeviceId: kotlin.String? = builder.awsLogicalDeviceId
    /**
     * The bandwidth of the connection.
     */
    val bandwidth: kotlin.String? = builder.bandwidth
    /**
     * Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).
     */
    val hasLogicalRedundancy: aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy? = builder.hasLogicalRedundancy
    /**
     * The ID of the interconnect.
     */
    val interconnectId: kotlin.String? = builder.interconnectId
    /**
     * The name of the interconnect.
     */
    val interconnectName: kotlin.String? = builder.interconnectName
    /**
     * The state of the interconnect. The following are the possible values:
     * + `requested`: The initial state of an interconnect. The interconnect stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.
     * + `pending`: The interconnect is approved, and is being initialized.
     * + `available`: The network link is up, and the interconnect is ready for use.
     * + `down`: The network link is down.
     * + `deleting`: The interconnect is being deleted.
     * + `deleted`: The interconnect is deleted.
     * + `unknown`: The state of the interconnect is not available.
     */
    val interconnectState: aws.sdk.kotlin.services.directconnect.model.InterconnectState? = builder.interconnectState
    /**
     * Indicates whether jumbo frames (9001 MTU) are supported.
     */
    val jumboFrameCapable: kotlin.Boolean? = builder.jumboFrameCapable
    /**
     * The ID of the LAG.
     */
    val lagId: kotlin.String? = builder.lagId
    /**
     * The time of the most recent call to DescribeLoa for this connection.
     */
    val loaIssueTime: aws.smithy.kotlin.runtime.time.Instant? = builder.loaIssueTime
    /**
     * The location of the connection.
     */
    val location: kotlin.String? = builder.location
    /**
     * The name of the service provider associated with the interconnect.
     */
    val providerName: kotlin.String? = builder.providerName
    /**
     * The Amazon Web Services Region where the connection is located.
     */
    val region: kotlin.String? = builder.region
    /**
     * The tags associated with the interconnect.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.Interconnect = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Interconnect(")
        append("awsDevice=$awsDevice,")
        append("awsDeviceV2=$awsDeviceV2,")
        append("awsLogicalDeviceId=$awsLogicalDeviceId,")
        append("bandwidth=$bandwidth,")
        append("hasLogicalRedundancy=$hasLogicalRedundancy,")
        append("interconnectId=$interconnectId,")
        append("interconnectName=$interconnectName,")
        append("interconnectState=$interconnectState,")
        append("jumboFrameCapable=$jumboFrameCapable,")
        append("lagId=$lagId,")
        append("loaIssueTime=$loaIssueTime,")
        append("location=$location,")
        append("providerName=$providerName,")
        append("region=$region,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsDevice?.hashCode() ?: 0
        result = 31 * result + (awsDeviceV2?.hashCode() ?: 0)
        result = 31 * result + (awsLogicalDeviceId?.hashCode() ?: 0)
        result = 31 * result + (bandwidth?.hashCode() ?: 0)
        result = 31 * result + (hasLogicalRedundancy?.hashCode() ?: 0)
        result = 31 * result + (interconnectId?.hashCode() ?: 0)
        result = 31 * result + (interconnectName?.hashCode() ?: 0)
        result = 31 * result + (interconnectState?.hashCode() ?: 0)
        result = 31 * result + (jumboFrameCapable?.hashCode() ?: 0)
        result = 31 * result + (lagId?.hashCode() ?: 0)
        result = 31 * result + (loaIssueTime?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Interconnect

        if (awsDevice != other.awsDevice) return false
        if (awsDeviceV2 != other.awsDeviceV2) return false
        if (awsLogicalDeviceId != other.awsLogicalDeviceId) return false
        if (bandwidth != other.bandwidth) return false
        if (hasLogicalRedundancy != other.hasLogicalRedundancy) return false
        if (interconnectId != other.interconnectId) return false
        if (interconnectName != other.interconnectName) return false
        if (interconnectState != other.interconnectState) return false
        if (jumboFrameCapable != other.jumboFrameCapable) return false
        if (lagId != other.lagId) return false
        if (loaIssueTime != other.loaIssueTime) return false
        if (location != other.location) return false
        if (providerName != other.providerName) return false
        if (region != other.region) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.Interconnect = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Direct Connect endpoint on which the physical connection terminates.
         */
        var awsDevice: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the physical connection.
         */
        var awsDeviceV2: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
         */
        var awsLogicalDeviceId: kotlin.String? = null
        /**
         * The bandwidth of the connection.
         */
        var bandwidth: kotlin.String? = null
        /**
         * Indicates whether the interconnect supports a secondary BGP in the same address family (IPv4/IPv6).
         */
        var hasLogicalRedundancy: aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy? = null
        /**
         * The ID of the interconnect.
         */
        var interconnectId: kotlin.String? = null
        /**
         * The name of the interconnect.
         */
        var interconnectName: kotlin.String? = null
        /**
         * The state of the interconnect. The following are the possible values:
         * + `requested`: The initial state of an interconnect. The interconnect stays in the requested state until the Letter of Authorization (LOA) is sent to the customer.
         * + `pending`: The interconnect is approved, and is being initialized.
         * + `available`: The network link is up, and the interconnect is ready for use.
         * + `down`: The network link is down.
         * + `deleting`: The interconnect is being deleted.
         * + `deleted`: The interconnect is deleted.
         * + `unknown`: The state of the interconnect is not available.
         */
        var interconnectState: aws.sdk.kotlin.services.directconnect.model.InterconnectState? = null
        /**
         * Indicates whether jumbo frames (9001 MTU) are supported.
         */
        var jumboFrameCapable: kotlin.Boolean? = null
        /**
         * The ID of the LAG.
         */
        var lagId: kotlin.String? = null
        /**
         * The time of the most recent call to DescribeLoa for this connection.
         */
        var loaIssueTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the connection.
         */
        var location: kotlin.String? = null
        /**
         * The name of the service provider associated with the interconnect.
         */
        var providerName: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the connection is located.
         */
        var region: kotlin.String? = null
        /**
         * The tags associated with the interconnect.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.Interconnect) : this() {
            this.awsDevice = x.awsDevice
            this.awsDeviceV2 = x.awsDeviceV2
            this.awsLogicalDeviceId = x.awsLogicalDeviceId
            this.bandwidth = x.bandwidth
            this.hasLogicalRedundancy = x.hasLogicalRedundancy
            this.interconnectId = x.interconnectId
            this.interconnectName = x.interconnectName
            this.interconnectState = x.interconnectState
            this.jumboFrameCapable = x.jumboFrameCapable
            this.lagId = x.lagId
            this.loaIssueTime = x.loaIssueTime
            this.location = x.location
            this.providerName = x.providerName
            this.region = x.region
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.Interconnect = Interconnect(this)
    }
}
