// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about a private virtual interface.
 */
class NewPrivateVirtualInterface private constructor(builder: Builder) {
    /**
     * The address family for the BGP peer.
     */
    val addressFamily: aws.sdk.kotlin.services.directconnect.model.AddressFamily? = builder.addressFamily
    /**
     * The IP address assigned to the Amazon interface.
     */
    val amazonAddress: kotlin.String? = builder.amazonAddress
    /**
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     *
     * The valid values are 1-2147483647.
     */
    val asn: kotlin.Int = builder.asn
    /**
     * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.
     */
    val authKey: kotlin.String? = builder.authKey
    /**
     * The IP address assigned to the customer interface.
     */
    val customerAddress: kotlin.String? = builder.customerAddress
    /**
     * The ID of the Direct Connect gateway.
     */
    val directConnectGatewayId: kotlin.String? = builder.directConnectGatewayId
    /**
     * Indicates whether to enable or disable SiteLink.
     */
    val enableSiteLink: kotlin.Boolean? = builder.enableSiteLink
    /**
     * The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.
     */
    val mtu: kotlin.Int? = builder.mtu
    /**
     * The tags associated with the private virtual interface.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the virtual private gateway.
     */
    val virtualGatewayId: kotlin.String? = builder.virtualGatewayId
    /**
     * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
     */
    val virtualInterfaceName: kotlin.String? = builder.virtualInterfaceName
    /**
     * The ID of the VLAN.
     */
    val vlan: kotlin.Int = builder.vlan

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.NewPrivateVirtualInterface = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NewPrivateVirtualInterface(")
        append("addressFamily=$addressFamily,")
        append("amazonAddress=$amazonAddress,")
        append("asn=$asn,")
        append("authKey=$authKey,")
        append("customerAddress=$customerAddress,")
        append("directConnectGatewayId=$directConnectGatewayId,")
        append("enableSiteLink=$enableSiteLink,")
        append("mtu=$mtu,")
        append("tags=$tags,")
        append("virtualGatewayId=$virtualGatewayId,")
        append("virtualInterfaceName=$virtualInterfaceName,")
        append("vlan=$vlan)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFamily?.hashCode() ?: 0
        result = 31 * result + (amazonAddress?.hashCode() ?: 0)
        result = 31 * result + (asn)
        result = 31 * result + (authKey?.hashCode() ?: 0)
        result = 31 * result + (customerAddress?.hashCode() ?: 0)
        result = 31 * result + (directConnectGatewayId?.hashCode() ?: 0)
        result = 31 * result + (enableSiteLink?.hashCode() ?: 0)
        result = 31 * result + (mtu ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayId?.hashCode() ?: 0)
        result = 31 * result + (virtualInterfaceName?.hashCode() ?: 0)
        result = 31 * result + (vlan)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NewPrivateVirtualInterface

        if (addressFamily != other.addressFamily) return false
        if (amazonAddress != other.amazonAddress) return false
        if (asn != other.asn) return false
        if (authKey != other.authKey) return false
        if (customerAddress != other.customerAddress) return false
        if (directConnectGatewayId != other.directConnectGatewayId) return false
        if (enableSiteLink != other.enableSiteLink) return false
        if (mtu != other.mtu) return false
        if (tags != other.tags) return false
        if (virtualGatewayId != other.virtualGatewayId) return false
        if (virtualInterfaceName != other.virtualInterfaceName) return false
        if (vlan != other.vlan) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.NewPrivateVirtualInterface = Builder(this).apply(block).build()

    class Builder {
        /**
         * The address family for the BGP peer.
         */
        var addressFamily: aws.sdk.kotlin.services.directconnect.model.AddressFamily? = null
        /**
         * The IP address assigned to the Amazon interface.
         */
        var amazonAddress: kotlin.String? = null
        /**
         * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         *
         * The valid values are 1-2147483647.
         */
        var asn: kotlin.Int = 0
        /**
         * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.
         */
        var authKey: kotlin.String? = null
        /**
         * The IP address assigned to the customer interface.
         */
        var customerAddress: kotlin.String? = null
        /**
         * The ID of the Direct Connect gateway.
         */
        var directConnectGatewayId: kotlin.String? = null
        /**
         * Indicates whether to enable or disable SiteLink.
         */
        var enableSiteLink: kotlin.Boolean? = null
        /**
         * The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.
         */
        var mtu: kotlin.Int? = null
        /**
         * The tags associated with the private virtual interface.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the virtual private gateway.
         */
        var virtualGatewayId: kotlin.String? = null
        /**
         * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
         */
        var virtualInterfaceName: kotlin.String? = null
        /**
         * The ID of the VLAN.
         */
        var vlan: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.NewPrivateVirtualInterface) : this() {
            this.addressFamily = x.addressFamily
            this.amazonAddress = x.amazonAddress
            this.asn = x.asn
            this.authKey = x.authKey
            this.customerAddress = x.customerAddress
            this.directConnectGatewayId = x.directConnectGatewayId
            this.enableSiteLink = x.enableSiteLink
            this.mtu = x.mtu
            this.tags = x.tags
            this.virtualGatewayId = x.virtualGatewayId
            this.virtualInterfaceName = x.virtualInterfaceName
            this.vlan = x.vlan
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.NewPrivateVirtualInterface = NewPrivateVirtualInterface(this)
    }
}
