// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about a virtual private gateway for a private virtual interface.
 */
class VirtualGateway private constructor(builder: Builder) {
    /**
     * The ID of the virtual private gateway.
     */
    val virtualGatewayId: kotlin.String? = builder.virtualGatewayId
    /**
     * The state of the virtual private gateway. The following are the possible values:
     * + `pending`: Initial state after creating the virtual private gateway.
     * + `available`: Ready for use by a private virtual interface.
     * + `deleting`: Initial state after deleting the virtual private gateway.
     * + `deleted`: The virtual private gateway is deleted. The private virtual interface is unable to send traffic over this gateway.
     */
    val virtualGatewayState: kotlin.String? = builder.virtualGatewayState

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.VirtualGateway = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualGateway(")
        append("virtualGatewayId=$virtualGatewayId,")
        append("virtualGatewayState=$virtualGatewayState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = virtualGatewayId?.hashCode() ?: 0
        result = 31 * result + (virtualGatewayState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VirtualGateway

        if (virtualGatewayId != other.virtualGatewayId) return false
        if (virtualGatewayState != other.virtualGatewayState) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.VirtualGateway = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the virtual private gateway.
         */
        var virtualGatewayId: kotlin.String? = null
        /**
         * The state of the virtual private gateway. The following are the possible values:
         * + `pending`: Initial state after creating the virtual private gateway.
         * + `available`: Ready for use by a private virtual interface.
         * + `deleting`: Initial state after deleting the virtual private gateway.
         * + `deleted`: The virtual private gateway is deleted. The private virtual interface is unable to send traffic over this gateway.
         */
        var virtualGatewayState: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.VirtualGateway) : this() {
            this.virtualGatewayId = x.virtualGatewayId
            this.virtualGatewayState = x.virtualGatewayState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.VirtualGateway = VirtualGateway(this)
    }
}
