// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about a virtual interface.
 */
class VirtualInterface private constructor(builder: Builder) {
    /**
     * The address family for the BGP peer.
     */
    val addressFamily: aws.sdk.kotlin.services.directconnect.model.AddressFamily? = builder.addressFamily
    /**
     * The IP address assigned to the Amazon interface.
     */
    val amazonAddress: kotlin.String? = builder.amazonAddress
    /**
     * The autonomous system number (ASN) for the Amazon side of the connection.
     */
    val amazonSideAsn: kotlin.Long? = builder.amazonSideAsn
    /**
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     *
     * The valid values are 1-2147483647.
     */
    val asn: kotlin.Int = builder.asn
    /**
     * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.
     */
    val authKey: kotlin.String? = builder.authKey
    /**
     * The Direct Connect endpoint that terminates the physical connection.
     */
    val awsDeviceV2: kotlin.String? = builder.awsDeviceV2
    /**
     * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
     */
    val awsLogicalDeviceId: kotlin.String? = builder.awsLogicalDeviceId
    /**
     * The BGP peers configured on this virtual interface.
     */
    val bgpPeers: List<BgpPeer>? = builder.bgpPeers
    /**
     * The ID of the connection.
     */
    val connectionId: kotlin.String? = builder.connectionId
    /**
     * The IP address assigned to the customer interface.
     */
    val customerAddress: kotlin.String? = builder.customerAddress
    /**
     * The customer router configuration.
     */
    val customerRouterConfig: kotlin.String? = builder.customerRouterConfig
    /**
     * The ID of the Direct Connect gateway.
     */
    val directConnectGatewayId: kotlin.String? = builder.directConnectGatewayId
    /**
     * Indicates whether jumbo frames (9001 MTU) are supported.
     */
    val jumboFrameCapable: kotlin.Boolean? = builder.jumboFrameCapable
    /**
     * The location of the connection.
     */
    val location: kotlin.String? = builder.location
    /**
     * The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.
     */
    val mtu: kotlin.Int? = builder.mtu
    /**
     * The ID of the Amazon Web Services account that owns the virtual interface.
     */
    val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The Amazon Web Services Region where the virtual interface is located.
     */
    val region: kotlin.String? = builder.region
    /**
     * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.
     */
    val routeFilterPrefixes: List<RouteFilterPrefix>? = builder.routeFilterPrefixes
    /**
     * Indicates whether SiteLink is enabled.
     */
    val siteLinkEnabled: kotlin.Boolean? = builder.siteLinkEnabled
    /**
     * The tags associated with the virtual interface.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the virtual private gateway. Applies only to private virtual interfaces.
     */
    val virtualGatewayId: kotlin.String? = builder.virtualGatewayId
    /**
     * The ID of the virtual interface.
     */
    val virtualInterfaceId: kotlin.String? = builder.virtualInterfaceId
    /**
     * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
     */
    val virtualInterfaceName: kotlin.String? = builder.virtualInterfaceName
    /**
     * The state of the virtual interface. The following are the possible values:
     * + `confirming`: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.
     * + `verifying`: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.
     * + `pending`: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.
     * + `available`: A virtual interface that is able to forward traffic.
     * + `down`: A virtual interface that is BGP down.
     * + `deleting`: A virtual interface is in this state immediately after calling DeleteVirtualInterface until it can no longer forward traffic.
     * + `deleted`: A virtual interface that cannot forward traffic.
     * + `rejected`: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the `Confirming` state is deleted by the virtual interface owner, the virtual interface enters the `Rejected` state.
     * + `unknown`: The state of the virtual interface is not available.
     */
    val virtualInterfaceState: aws.sdk.kotlin.services.directconnect.model.VirtualInterfaceState? = builder.virtualInterfaceState
    /**
     * The type of virtual interface. The possible values are `private` and `public`.
     */
    val virtualInterfaceType: kotlin.String? = builder.virtualInterfaceType
    /**
     * The ID of the VLAN.
     */
    val vlan: kotlin.Int = builder.vlan

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.VirtualInterface = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualInterface(")
        append("addressFamily=$addressFamily,")
        append("amazonAddress=$amazonAddress,")
        append("amazonSideAsn=$amazonSideAsn,")
        append("asn=$asn,")
        append("authKey=$authKey,")
        append("awsDeviceV2=$awsDeviceV2,")
        append("awsLogicalDeviceId=$awsLogicalDeviceId,")
        append("bgpPeers=$bgpPeers,")
        append("connectionId=$connectionId,")
        append("customerAddress=$customerAddress,")
        append("customerRouterConfig=$customerRouterConfig,")
        append("directConnectGatewayId=$directConnectGatewayId,")
        append("jumboFrameCapable=$jumboFrameCapable,")
        append("location=$location,")
        append("mtu=$mtu,")
        append("ownerAccount=$ownerAccount,")
        append("region=$region,")
        append("routeFilterPrefixes=$routeFilterPrefixes,")
        append("siteLinkEnabled=$siteLinkEnabled,")
        append("tags=$tags,")
        append("virtualGatewayId=$virtualGatewayId,")
        append("virtualInterfaceId=$virtualInterfaceId,")
        append("virtualInterfaceName=$virtualInterfaceName,")
        append("virtualInterfaceState=$virtualInterfaceState,")
        append("virtualInterfaceType=$virtualInterfaceType,")
        append("vlan=$vlan)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFamily?.hashCode() ?: 0
        result = 31 * result + (amazonAddress?.hashCode() ?: 0)
        result = 31 * result + (amazonSideAsn?.hashCode() ?: 0)
        result = 31 * result + (asn)
        result = 31 * result + (authKey?.hashCode() ?: 0)
        result = 31 * result + (awsDeviceV2?.hashCode() ?: 0)
        result = 31 * result + (awsLogicalDeviceId?.hashCode() ?: 0)
        result = 31 * result + (bgpPeers?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (customerAddress?.hashCode() ?: 0)
        result = 31 * result + (customerRouterConfig?.hashCode() ?: 0)
        result = 31 * result + (directConnectGatewayId?.hashCode() ?: 0)
        result = 31 * result + (jumboFrameCapable?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (mtu ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (routeFilterPrefixes?.hashCode() ?: 0)
        result = 31 * result + (siteLinkEnabled?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (virtualGatewayId?.hashCode() ?: 0)
        result = 31 * result + (virtualInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (virtualInterfaceName?.hashCode() ?: 0)
        result = 31 * result + (virtualInterfaceState?.hashCode() ?: 0)
        result = 31 * result + (virtualInterfaceType?.hashCode() ?: 0)
        result = 31 * result + (vlan)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VirtualInterface

        if (addressFamily != other.addressFamily) return false
        if (amazonAddress != other.amazonAddress) return false
        if (amazonSideAsn != other.amazonSideAsn) return false
        if (asn != other.asn) return false
        if (authKey != other.authKey) return false
        if (awsDeviceV2 != other.awsDeviceV2) return false
        if (awsLogicalDeviceId != other.awsLogicalDeviceId) return false
        if (bgpPeers != other.bgpPeers) return false
        if (connectionId != other.connectionId) return false
        if (customerAddress != other.customerAddress) return false
        if (customerRouterConfig != other.customerRouterConfig) return false
        if (directConnectGatewayId != other.directConnectGatewayId) return false
        if (jumboFrameCapable != other.jumboFrameCapable) return false
        if (location != other.location) return false
        if (mtu != other.mtu) return false
        if (ownerAccount != other.ownerAccount) return false
        if (region != other.region) return false
        if (routeFilterPrefixes != other.routeFilterPrefixes) return false
        if (siteLinkEnabled != other.siteLinkEnabled) return false
        if (tags != other.tags) return false
        if (virtualGatewayId != other.virtualGatewayId) return false
        if (virtualInterfaceId != other.virtualInterfaceId) return false
        if (virtualInterfaceName != other.virtualInterfaceName) return false
        if (virtualInterfaceState != other.virtualInterfaceState) return false
        if (virtualInterfaceType != other.virtualInterfaceType) return false
        if (vlan != other.vlan) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.VirtualInterface = Builder(this).apply(block).build()

    class Builder {
        /**
         * The address family for the BGP peer.
         */
        var addressFamily: aws.sdk.kotlin.services.directconnect.model.AddressFamily? = null
        /**
         * The IP address assigned to the Amazon interface.
         */
        var amazonAddress: kotlin.String? = null
        /**
         * The autonomous system number (ASN) for the Amazon side of the connection.
         */
        var amazonSideAsn: kotlin.Long? = null
        /**
         * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         *
         * The valid values are 1-2147483647.
         */
        var asn: kotlin.Int = 0
        /**
         * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.
         */
        var authKey: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the physical connection.
         */
        var awsDeviceV2: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
         */
        var awsLogicalDeviceId: kotlin.String? = null
        /**
         * The BGP peers configured on this virtual interface.
         */
        var bgpPeers: List<BgpPeer>? = null
        /**
         * The ID of the connection.
         */
        var connectionId: kotlin.String? = null
        /**
         * The IP address assigned to the customer interface.
         */
        var customerAddress: kotlin.String? = null
        /**
         * The customer router configuration.
         */
        var customerRouterConfig: kotlin.String? = null
        /**
         * The ID of the Direct Connect gateway.
         */
        var directConnectGatewayId: kotlin.String? = null
        /**
         * Indicates whether jumbo frames (9001 MTU) are supported.
         */
        var jumboFrameCapable: kotlin.Boolean? = null
        /**
         * The location of the connection.
         */
        var location: kotlin.String? = null
        /**
         * The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.
         */
        var mtu: kotlin.Int? = null
        /**
         * The ID of the Amazon Web Services account that owns the virtual interface.
         */
        var ownerAccount: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the virtual interface is located.
         */
        var region: kotlin.String? = null
        /**
         * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual interfaces.
         */
        var routeFilterPrefixes: List<RouteFilterPrefix>? = null
        /**
         * Indicates whether SiteLink is enabled.
         */
        var siteLinkEnabled: kotlin.Boolean? = null
        /**
         * The tags associated with the virtual interface.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the virtual private gateway. Applies only to private virtual interfaces.
         */
        var virtualGatewayId: kotlin.String? = null
        /**
         * The ID of the virtual interface.
         */
        var virtualInterfaceId: kotlin.String? = null
        /**
         * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
         */
        var virtualInterfaceName: kotlin.String? = null
        /**
         * The state of the virtual interface. The following are the possible values:
         * + `confirming`: The creation of the virtual interface is pending confirmation from the virtual interface owner. If the owner of the virtual interface is different from the owner of the connection on which it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface owner.
         * + `verifying`: This state only applies to public virtual interfaces. Each public virtual interface needs validation before the virtual interface can be created.
         * + `pending`: A virtual interface is in this state from the time that it is created until the virtual interface is ready to forward traffic.
         * + `available`: A virtual interface that is able to forward traffic.
         * + `down`: A virtual interface that is BGP down.
         * + `deleting`: A virtual interface is in this state immediately after calling DeleteVirtualInterface until it can no longer forward traffic.
         * + `deleted`: A virtual interface that cannot forward traffic.
         * + `rejected`: The virtual interface owner has declined creation of the virtual interface. If a virtual interface in the `Confirming` state is deleted by the virtual interface owner, the virtual interface enters the `Rejected` state.
         * + `unknown`: The state of the virtual interface is not available.
         */
        var virtualInterfaceState: aws.sdk.kotlin.services.directconnect.model.VirtualInterfaceState? = null
        /**
         * The type of virtual interface. The possible values are `private` and `public`.
         */
        var virtualInterfaceType: kotlin.String? = null
        /**
         * The ID of the VLAN.
         */
        var vlan: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.VirtualInterface) : this() {
            this.addressFamily = x.addressFamily
            this.amazonAddress = x.amazonAddress
            this.amazonSideAsn = x.amazonSideAsn
            this.asn = x.asn
            this.authKey = x.authKey
            this.awsDeviceV2 = x.awsDeviceV2
            this.awsLogicalDeviceId = x.awsLogicalDeviceId
            this.bgpPeers = x.bgpPeers
            this.connectionId = x.connectionId
            this.customerAddress = x.customerAddress
            this.customerRouterConfig = x.customerRouterConfig
            this.directConnectGatewayId = x.directConnectGatewayId
            this.jumboFrameCapable = x.jumboFrameCapable
            this.location = x.location
            this.mtu = x.mtu
            this.ownerAccount = x.ownerAccount
            this.region = x.region
            this.routeFilterPrefixes = x.routeFilterPrefixes
            this.siteLinkEnabled = x.siteLinkEnabled
            this.tags = x.tags
            this.virtualGatewayId = x.virtualGatewayId
            this.virtualInterfaceId = x.virtualInterfaceId
            this.virtualInterfaceName = x.virtualInterfaceName
            this.virtualInterfaceState = x.virtualInterfaceState
            this.virtualInterfaceType = x.virtualInterfaceType
            this.vlan = x.vlan
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.VirtualInterface = VirtualInterface(this)
    }
}
