// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.CreateInterconnectResponse
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy
import aws.sdk.kotlin.services.directconnect.model.InterconnectState
import aws.sdk.kotlin.services.directconnect.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateInterconnectOperationDeserializer: HttpDeserialize<CreateInterconnectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateInterconnectResponse {
        if (!response.status.isSuccess()) {
            throwCreateInterconnectError(context, response)
        }
        val builder = CreateInterconnectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateInterconnectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateInterconnectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "DuplicateTagKeysException" -> DuplicateTagKeysExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyTagsException" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateInterconnectOperationBody(builder: CreateInterconnectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AWSDEVICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsDevice"))
    val AWSDEVICEV2_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsDeviceV2"))
    val AWSLOGICALDEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsLogicalDeviceId"))
    val BANDWIDTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bandwidth"))
    val HASLOGICALREDUNDANCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("hasLogicalRedundancy"))
    val INTERCONNECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("interconnectId"))
    val INTERCONNECTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("interconnectName"))
    val INTERCONNECTSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("interconnectState"))
    val JUMBOFRAMECAPABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("jumboFrameCapable"))
    val LAGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lagId"))
    val LOAISSUETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("loaIssueTime"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("location"))
    val PROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("providerName"))
    val REGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("region"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSDEVICE_DESCRIPTOR)
        field(AWSDEVICEV2_DESCRIPTOR)
        field(AWSLOGICALDEVICEID_DESCRIPTOR)
        field(BANDWIDTH_DESCRIPTOR)
        field(HASLOGICALREDUNDANCY_DESCRIPTOR)
        field(INTERCONNECTID_DESCRIPTOR)
        field(INTERCONNECTNAME_DESCRIPTOR)
        field(INTERCONNECTSTATE_DESCRIPTOR)
        field(JUMBOFRAMECAPABLE_DESCRIPTOR)
        field(LAGID_DESCRIPTOR)
        field(LOAISSUETIME_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(PROVIDERNAME_DESCRIPTOR)
        field(REGION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AWSDEVICE_DESCRIPTOR.index -> builder.awsDevice = deserializeString()
                AWSDEVICEV2_DESCRIPTOR.index -> builder.awsDeviceV2 = deserializeString()
                AWSLOGICALDEVICEID_DESCRIPTOR.index -> builder.awsLogicalDeviceId = deserializeString()
                BANDWIDTH_DESCRIPTOR.index -> builder.bandwidth = deserializeString()
                HASLOGICALREDUNDANCY_DESCRIPTOR.index -> builder.hasLogicalRedundancy = deserializeString().let { HasLogicalRedundancy.fromValue(it) }
                INTERCONNECTID_DESCRIPTOR.index -> builder.interconnectId = deserializeString()
                INTERCONNECTNAME_DESCRIPTOR.index -> builder.interconnectName = deserializeString()
                INTERCONNECTSTATE_DESCRIPTOR.index -> builder.interconnectState = deserializeString().let { InterconnectState.fromValue(it) }
                JUMBOFRAMECAPABLE_DESCRIPTOR.index -> builder.jumboFrameCapable = deserializeBoolean()
                LAGID_DESCRIPTOR.index -> builder.lagId = deserializeString()
                LOAISSUETIME_DESCRIPTOR.index -> builder.loaIssueTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeString()
                PROVIDERNAME_DESCRIPTOR.index -> builder.providerName = deserializeString()
                REGION_DESCRIPTOR.index -> builder.region = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
