// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.DeleteVirtualInterfaceResponse
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.VirtualInterfaceState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteVirtualInterfaceOperationDeserializer: HttpDeserialize<DeleteVirtualInterfaceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteVirtualInterfaceResponse {
        if (!response.status.isSuccess()) {
            throwDeleteVirtualInterfaceError(context, response)
        }
        val builder = DeleteVirtualInterfaceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteVirtualInterfaceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteVirtualInterfaceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteVirtualInterfaceOperationBody(builder: DeleteVirtualInterfaceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VIRTUALINTERFACESTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("virtualInterfaceState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VIRTUALINTERFACESTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VIRTUALINTERFACESTATE_DESCRIPTOR.index -> builder.virtualInterfaceState = deserializeString().let { VirtualInterfaceState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
