// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.DescribeRouterConfigurationResponse
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.RouterType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeRouterConfigurationOperationDeserializer: HttpDeserialize<DescribeRouterConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeRouterConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeRouterConfigurationError(context, response)
        }
        val builder = DescribeRouterConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeRouterConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeRouterConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeRouterConfigurationOperationBody(builder: DescribeRouterConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMERROUTERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customerRouterConfig"))
    val ROUTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("router"))
    val VIRTUALINTERFACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("virtualInterfaceId"))
    val VIRTUALINTERFACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("virtualInterfaceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMERROUTERCONFIG_DESCRIPTOR)
        field(ROUTER_DESCRIPTOR)
        field(VIRTUALINTERFACEID_DESCRIPTOR)
        field(VIRTUALINTERFACENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMERROUTERCONFIG_DESCRIPTOR.index -> builder.customerRouterConfig = deserializeString()
                ROUTER_DESCRIPTOR.index -> builder.router = deserializeRouterTypeDocument(deserializer)
                VIRTUALINTERFACEID_DESCRIPTOR.index -> builder.virtualInterfaceId = deserializeString()
                VIRTUALINTERFACENAME_DESCRIPTOR.index -> builder.virtualInterfaceName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
