// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.dlm.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.dlm.model.*
import aws.sdk.kotlin.services.dlm.model.CreateLifecyclePolicyRequest
import aws.sdk.kotlin.services.dlm.model.CreateLifecyclePolicyResponse
import aws.sdk.kotlin.services.dlm.model.DeleteLifecyclePolicyRequest
import aws.sdk.kotlin.services.dlm.model.DeleteLifecyclePolicyResponse
import aws.sdk.kotlin.services.dlm.model.GetLifecyclePoliciesRequest
import aws.sdk.kotlin.services.dlm.model.GetLifecyclePoliciesResponse
import aws.sdk.kotlin.services.dlm.model.GetLifecyclePolicyRequest
import aws.sdk.kotlin.services.dlm.model.GetLifecyclePolicyResponse
import aws.sdk.kotlin.services.dlm.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.dlm.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.dlm.model.TagResourceRequest
import aws.sdk.kotlin.services.dlm.model.TagResourceResponse
import aws.sdk.kotlin.services.dlm.model.UntagResourceRequest
import aws.sdk.kotlin.services.dlm.model.UntagResourceResponse
import aws.sdk.kotlin.services.dlm.model.UpdateLifecyclePolicyRequest
import aws.sdk.kotlin.services.dlm.model.UpdateLifecyclePolicyResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon Data Lifecycle Manager
 * With Amazon Data Lifecycle Manager, you can manage the lifecycle of your Amazon Web Services resources. You create lifecycle policies, which are used to automate operations on the specified resources.
 *
 * Amazon DLM supports Amazon EBS volumes and snapshots. For information about using Amazon DLM with Amazon EBS, see [Automating the Amazon EBS Snapshot Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-lifecycle.html) in the *Amazon EC2 User Guide*.
 */
public interface DlmClient : SdkClient {

    override val serviceName: String
        get() = "DLM"
    /**
     * DlmClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): DlmClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDlmClient(config)
        }

        public operator fun invoke(config: Config): DlmClient = DefaultDlmClient(config)

        /**
         * Construct a [DlmClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DlmClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultDlmClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a policy to manage the lifecycle of the specified Amazon Web Services resources. You can create up to 100 lifecycle policies.
     */
    public suspend fun createLifecyclePolicy(input: CreateLifecyclePolicyRequest): CreateLifecyclePolicyResponse

    /**
     * Deletes the specified lifecycle policy and halts the automated operations that the policy specified.
     */
    public suspend fun deleteLifecyclePolicy(input: DeleteLifecyclePolicyRequest): DeleteLifecyclePolicyResponse

    /**
     * Gets summary information about all or the specified data lifecycle policies.
     *
     * To get complete information about a policy, use GetLifecyclePolicy.
     */
    public suspend fun getLifecyclePolicies(input: GetLifecyclePoliciesRequest = GetLifecyclePoliciesRequest {}): GetLifecyclePoliciesResponse

    /**
     * Gets detailed information about the specified lifecycle policy.
     */
    public suspend fun getLifecyclePolicy(input: GetLifecyclePolicyRequest): GetLifecyclePolicyResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds the specified tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified lifecycle policy.
     */
    public suspend fun updateLifecyclePolicy(input: UpdateLifecyclePolicyRequest): UpdateLifecyclePolicyResponse
}

/**
 * Creates a policy to manage the lifecycle of the specified Amazon Web Services resources. You can create up to 100 lifecycle policies.
 */
public suspend inline fun DlmClient.createLifecyclePolicy(crossinline block: CreateLifecyclePolicyRequest.Builder.() -> Unit): CreateLifecyclePolicyResponse = createLifecyclePolicy(CreateLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified lifecycle policy and halts the automated operations that the policy specified.
 */
public suspend inline fun DlmClient.deleteLifecyclePolicy(crossinline block: DeleteLifecyclePolicyRequest.Builder.() -> Unit): DeleteLifecyclePolicyResponse = deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Gets summary information about all or the specified data lifecycle policies.
 *
 * To get complete information about a policy, use GetLifecyclePolicy.
 */
public suspend inline fun DlmClient.getLifecyclePolicies(crossinline block: GetLifecyclePoliciesRequest.Builder.() -> Unit): GetLifecyclePoliciesResponse = getLifecyclePolicies(GetLifecyclePoliciesRequest.Builder().apply(block).build())

/**
 * Gets detailed information about the specified lifecycle policy.
 */
public suspend inline fun DlmClient.getLifecyclePolicy(crossinline block: GetLifecyclePolicyRequest.Builder.() -> Unit): GetLifecyclePolicyResponse = getLifecyclePolicy(GetLifecyclePolicyRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun DlmClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified resource.
 */
public suspend inline fun DlmClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified resource.
 */
public suspend inline fun DlmClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified lifecycle policy.
 */
public suspend inline fun DlmClient.updateLifecyclePolicy(crossinline block: UpdateLifecyclePolicyRequest.Builder.() -> Unit): UpdateLifecyclePolicyResponse = updateLifecyclePolicy(UpdateLifecyclePolicyRequest.Builder().apply(block).build())
