// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * **&#91;AMI policies only&#93;** Specifies an AMI deprecation rule for AMIs created by an AMI lifecycle policy.
 *
 * For age-based schedules, you must specify **Interval** and **IntervalUnit**. For count-based schedules, you must specify **Count**.
 */
public class DeprecateRule private constructor(builder: Builder) {
    /**
     * If the schedule has a count-based retention rule, this parameter specifies the number of oldest AMIs to deprecate. The count must be less than or equal to the schedule's retention count, and it can't be greater than 1000.
     */
    public val count: kotlin.Int = builder.count
    /**
     * If the schedule has an age-based retention rule, this parameter specifies the period after which to deprecate AMIs created by the schedule. The period must be less than or equal to the schedule's retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
     */
    public val interval: kotlin.Int = builder.interval
    /**
     * The unit of time in which to measure the **Interval**.
     */
    public val intervalUnit: aws.sdk.kotlin.services.dlm.model.RetentionIntervalUnitValues? = builder.intervalUnit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.DeprecateRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeprecateRule(")
        append("count=$count,")
        append("interval=$interval,")
        append("intervalUnit=$intervalUnit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = count
        result = 31 * result + (interval)
        result = 31 * result + (intervalUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeprecateRule

        if (count != other.count) return false
        if (interval != other.interval) return false
        if (intervalUnit != other.intervalUnit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.DeprecateRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If the schedule has a count-based retention rule, this parameter specifies the number of oldest AMIs to deprecate. The count must be less than or equal to the schedule's retention count, and it can't be greater than 1000.
         */
        public var count: kotlin.Int = 0
        /**
         * If the schedule has an age-based retention rule, this parameter specifies the period after which to deprecate AMIs created by the schedule. The period must be less than or equal to the schedule's retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
         */
        public var interval: kotlin.Int = 0
        /**
         * The unit of time in which to measure the **Interval**.
         */
        public var intervalUnit: aws.sdk.kotlin.services.dlm.model.RetentionIntervalUnitValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.DeprecateRule) : this() {
            this.count = x.count
            this.interval = x.interval
            this.intervalUnit = x.intervalUnit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.DeprecateRule = DeprecateRule(this)
    }
}
