// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * Summary information about a lifecycle policy.
 */
public class LifecyclePolicySummary private constructor(builder: Builder) {
    /**
     * The description of the lifecycle policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the lifecycle policy.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The type of policy. `EBS_SNAPSHOT_MANAGEMENT` indicates that the policy manages the lifecycle of Amazon EBS snapshots. `IMAGE_MANAGEMENT` indicates that the policy manages the lifecycle of EBS-backed AMIs. `EVENT_BASED_POLICY` indicates that the policy automates cross-account snapshot copies for snapshots that are shared with your account.
     */
    public val policyType: aws.sdk.kotlin.services.dlm.model.PolicyTypeValues? = builder.policyType
    /**
     * The activation state of the lifecycle policy.
     */
    public val state: aws.sdk.kotlin.services.dlm.model.GettablePolicyStateValues? = builder.state
    /**
     * The tags.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.LifecyclePolicySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecyclePolicySummary(")
        append("description=$description,")
        append("policyId=$policyId,")
        append("policyType=$policyType,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecyclePolicySummary

        if (description != other.description) return false
        if (policyId != other.policyId) return false
        if (policyType != other.policyType) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.LifecyclePolicySummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the lifecycle policy.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the lifecycle policy.
         */
        public var policyId: kotlin.String? = null
        /**
         * The type of policy. `EBS_SNAPSHOT_MANAGEMENT` indicates that the policy manages the lifecycle of Amazon EBS snapshots. `IMAGE_MANAGEMENT` indicates that the policy manages the lifecycle of EBS-backed AMIs. `EVENT_BASED_POLICY` indicates that the policy automates cross-account snapshot copies for snapshots that are shared with your account.
         */
        public var policyType: aws.sdk.kotlin.services.dlm.model.PolicyTypeValues? = null
        /**
         * The activation state of the lifecycle policy.
         */
        public var state: aws.sdk.kotlin.services.dlm.model.GettablePolicyStateValues? = null
        /**
         * The tags.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.LifecyclePolicySummary) : this() {
            this.description = x.description
            this.policyId = x.policyId
            this.policyType = x.policyType
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.LifecyclePolicySummary = LifecyclePolicySummary(this)
    }
}
