// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * **&#91;Snapshot and AMI policies only&#93;** Specifies optional parameters for snapshot and AMI policies. The set of valid parameters depends on the combination of policy type and target resource type.
 *
 * If you choose to exclude boot volumes and you specify tags that consequently exclude all of the additional data volumes attached to an instance, then Amazon DLM will not create any snapshots for the affected instance, and it will emit a `SnapshotsCreateFailed` Amazon CloudWatch metric. For more information, see [Monitor your policies using Amazon CloudWatch](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitor-dlm-cw-metrics.html).
 */
public class Parameters private constructor(builder: Builder) {
    /**
     * **&#91;Snapshot policies that target instances only&#93;** Indicates whether to exclude the root volume from multi-volume snapshot sets. The default is `false`. If you specify `true`, then the root volumes attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
     */
    public val excludeBootVolume: kotlin.Boolean? = builder.excludeBootVolume
    /**
     * **&#91;Snapshot policies that target instances only&#93;** The tags used to identify data (non-root) volumes to exclude from multi-volume snapshot sets.
     *
     * If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter, then data volumes with the specified tags that are attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
     */
    public val excludeDataVolumeTags: List<Tag>? = builder.excludeDataVolumeTags
    /**
     * **&#91;AMI policies only&#93;** Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
     */
    public val noReboot: kotlin.Boolean? = builder.noReboot

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.Parameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Parameters(")
        append("excludeBootVolume=$excludeBootVolume,")
        append("excludeDataVolumeTags=$excludeDataVolumeTags,")
        append("noReboot=$noReboot)")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludeBootVolume?.hashCode() ?: 0
        result = 31 * result + (excludeDataVolumeTags?.hashCode() ?: 0)
        result = 31 * result + (noReboot?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Parameters

        if (excludeBootVolume != other.excludeBootVolume) return false
        if (excludeDataVolumeTags != other.excludeDataVolumeTags) return false
        if (noReboot != other.noReboot) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.Parameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * **&#91;Snapshot policies that target instances only&#93;** Indicates whether to exclude the root volume from multi-volume snapshot sets. The default is `false`. If you specify `true`, then the root volumes attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
         */
        public var excludeBootVolume: kotlin.Boolean? = null
        /**
         * **&#91;Snapshot policies that target instances only&#93;** The tags used to identify data (non-root) volumes to exclude from multi-volume snapshot sets.
         *
         * If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter, then data volumes with the specified tags that are attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
         */
        public var excludeDataVolumeTags: List<Tag>? = null
        /**
         * **&#91;AMI policies only&#93;** Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
         */
        public var noReboot: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.Parameters) : this() {
            this.excludeBootVolume = x.excludeBootVolume
            this.excludeDataVolumeTags = x.excludeDataVolumeTags
            this.noReboot = x.noReboot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.Parameters = Parameters(this)
    }
}
