// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * **&#91;All policy types&#93;** Specifies the configuration of a lifecycle policy.
 */
public class PolicyDetails private constructor(builder: Builder) {
    /**
     * **&#91;Event-based policies only&#93;** The actions to be performed when the event-based policy is activated. You can specify only one action per policy.
     */
    public val actions: List<Action>? = builder.actions
    /**
     * **&#91;Event-based policies only&#93;** The event that activates the event-based policy.
     */
    public val eventSource: aws.sdk.kotlin.services.dlm.model.EventSource? = builder.eventSource
    /**
     * **&#91;Snapshot and AMI policies only&#93;** A set of optional parameters for snapshot and AMI lifecycle policies.
     *
     * If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
     */
    public val parameters: aws.sdk.kotlin.services.dlm.model.Parameters? = builder.parameters
    /**
     * **&#91;All policy types&#93;** The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY ` to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.
     *
     * The default is `EBS_SNAPSHOT_MANAGEMENT`.
     */
    public val policyType: aws.sdk.kotlin.services.dlm.model.PolicyTypeValues? = builder.policyType
    /**
     * **&#91;Snapshot and AMI policies only&#93;** The location of the resources to backup. If the source resources are located in an Amazon Web Services Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`.
     *
     * If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account.
     */
    public val resourceLocations: List<ResourceLocationValues>? = builder.resourceLocations
    /**
     * **&#91;Snapshot policies only&#93;** The target resource type for snapshot and AMI lifecycle policies. Use `VOLUME `to create snapshots of individual volumes or use `INSTANCE` to create multi-volume snapshots from the volumes for an instance.
     */
    public val resourceTypes: List<ResourceTypeValues>? = builder.resourceTypes
    /**
     * **&#91;Snapshot and AMI policies only&#93;** The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
     */
    public val schedules: List<Schedule>? = builder.schedules
    /**
     * **&#91;Snapshot and AMI policies only&#93;** The single tag that identifies targeted resources for this policy.
     */
    public val targetTags: List<Tag>? = builder.targetTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.PolicyDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyDetails(")
        append("actions=$actions,")
        append("eventSource=$eventSource,")
        append("parameters=$parameters,")
        append("policyType=$policyType,")
        append("resourceLocations=$resourceLocations,")
        append("resourceTypes=$resourceTypes,")
        append("schedules=$schedules,")
        append("targetTags=$targetTags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (resourceLocations?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (schedules?.hashCode() ?: 0)
        result = 31 * result + (targetTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyDetails

        if (actions != other.actions) return false
        if (eventSource != other.eventSource) return false
        if (parameters != other.parameters) return false
        if (policyType != other.policyType) return false
        if (resourceLocations != other.resourceLocations) return false
        if (resourceTypes != other.resourceTypes) return false
        if (schedules != other.schedules) return false
        if (targetTags != other.targetTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.PolicyDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * **&#91;Event-based policies only&#93;** The actions to be performed when the event-based policy is activated. You can specify only one action per policy.
         */
        public var actions: List<Action>? = null
        /**
         * **&#91;Event-based policies only&#93;** The event that activates the event-based policy.
         */
        public var eventSource: aws.sdk.kotlin.services.dlm.model.EventSource? = null
        /**
         * **&#91;Snapshot and AMI policies only&#93;** A set of optional parameters for snapshot and AMI lifecycle policies.
         *
         * If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
         */
        public var parameters: aws.sdk.kotlin.services.dlm.model.Parameters? = null
        /**
         * **&#91;All policy types&#93;** The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY ` to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.
         *
         * The default is `EBS_SNAPSHOT_MANAGEMENT`.
         */
        public var policyType: aws.sdk.kotlin.services.dlm.model.PolicyTypeValues? = null
        /**
         * **&#91;Snapshot and AMI policies only&#93;** The location of the resources to backup. If the source resources are located in an Amazon Web Services Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`.
         *
         * If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account.
         */
        public var resourceLocations: List<ResourceLocationValues>? = null
        /**
         * **&#91;Snapshot policies only&#93;** The target resource type for snapshot and AMI lifecycle policies. Use `VOLUME `to create snapshots of individual volumes or use `INSTANCE` to create multi-volume snapshots from the volumes for an instance.
         */
        public var resourceTypes: List<ResourceTypeValues>? = null
        /**
         * **&#91;Snapshot and AMI policies only&#93;** The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
         */
        public var schedules: List<Schedule>? = null
        /**
         * **&#91;Snapshot and AMI policies only&#93;** The single tag that identifies targeted resources for this policy.
         */
        public var targetTags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.PolicyDetails) : this() {
            this.actions = x.actions
            this.eventSource = x.eventSource
            this.parameters = x.parameters
            this.policyType = x.policyType
            this.resourceLocations = x.resourceLocations
            this.resourceTypes = x.resourceTypes
            this.schedules = x.schedules
            this.targetTags = x.targetTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.PolicyDetails = PolicyDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.EventSource] inside the given [block]
         */
        public fun eventSource(block: aws.sdk.kotlin.services.dlm.model.EventSource.Builder.() -> kotlin.Unit) {
            this.eventSource = aws.sdk.kotlin.services.dlm.model.EventSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.Parameters] inside the given [block]
         */
        public fun parameters(block: aws.sdk.kotlin.services.dlm.model.Parameters.Builder.() -> kotlin.Unit) {
            this.parameters = aws.sdk.kotlin.services.dlm.model.Parameters.invoke(block)
        }
    }
}
