// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.docdb.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.docdb.model.*
import aws.sdk.kotlin.services.docdb.model.AddSourceIdentifierToSubscriptionRequest
import aws.sdk.kotlin.services.docdb.model.AddSourceIdentifierToSubscriptionResponse
import aws.sdk.kotlin.services.docdb.model.AddTagsToResourceRequest
import aws.sdk.kotlin.services.docdb.model.AddTagsToResourceResponse
import aws.sdk.kotlin.services.docdb.model.ApplyPendingMaintenanceActionRequest
import aws.sdk.kotlin.services.docdb.model.ApplyPendingMaintenanceActionResponse
import aws.sdk.kotlin.services.docdb.model.CopyDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.docdb.model.CopyDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.docdb.model.CopyDbClusterSnapshotRequest
import aws.sdk.kotlin.services.docdb.model.CopyDbClusterSnapshotResponse
import aws.sdk.kotlin.services.docdb.model.CreateDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.docdb.model.CreateDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.docdb.model.CreateDbClusterRequest
import aws.sdk.kotlin.services.docdb.model.CreateDbClusterResponse
import aws.sdk.kotlin.services.docdb.model.CreateDbClusterSnapshotRequest
import aws.sdk.kotlin.services.docdb.model.CreateDbClusterSnapshotResponse
import aws.sdk.kotlin.services.docdb.model.CreateDbInstanceRequest
import aws.sdk.kotlin.services.docdb.model.CreateDbInstanceResponse
import aws.sdk.kotlin.services.docdb.model.CreateDbSubnetGroupRequest
import aws.sdk.kotlin.services.docdb.model.CreateDbSubnetGroupResponse
import aws.sdk.kotlin.services.docdb.model.CreateEventSubscriptionRequest
import aws.sdk.kotlin.services.docdb.model.CreateEventSubscriptionResponse
import aws.sdk.kotlin.services.docdb.model.CreateGlobalClusterRequest
import aws.sdk.kotlin.services.docdb.model.CreateGlobalClusterResponse
import aws.sdk.kotlin.services.docdb.model.DeleteDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.docdb.model.DeleteDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.docdb.model.DeleteDbClusterRequest
import aws.sdk.kotlin.services.docdb.model.DeleteDbClusterResponse
import aws.sdk.kotlin.services.docdb.model.DeleteDbClusterSnapshotRequest
import aws.sdk.kotlin.services.docdb.model.DeleteDbClusterSnapshotResponse
import aws.sdk.kotlin.services.docdb.model.DeleteDbInstanceRequest
import aws.sdk.kotlin.services.docdb.model.DeleteDbInstanceResponse
import aws.sdk.kotlin.services.docdb.model.DeleteDbSubnetGroupRequest
import aws.sdk.kotlin.services.docdb.model.DeleteDbSubnetGroupResponse
import aws.sdk.kotlin.services.docdb.model.DeleteEventSubscriptionRequest
import aws.sdk.kotlin.services.docdb.model.DeleteEventSubscriptionResponse
import aws.sdk.kotlin.services.docdb.model.DeleteGlobalClusterRequest
import aws.sdk.kotlin.services.docdb.model.DeleteGlobalClusterResponse
import aws.sdk.kotlin.services.docdb.model.DescribeCertificatesRequest
import aws.sdk.kotlin.services.docdb.model.DescribeCertificatesResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParameterGroupsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParameterGroupsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParametersRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParametersResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbClustersRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbClustersResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbEngineVersionsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbEngineVersionsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbInstancesRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbInstancesResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbSubnetGroupsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbSubnetGroupsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeEngineDefaultClusterParametersRequest
import aws.sdk.kotlin.services.docdb.model.DescribeEngineDefaultClusterParametersResponse
import aws.sdk.kotlin.services.docdb.model.DescribeEventCategoriesRequest
import aws.sdk.kotlin.services.docdb.model.DescribeEventCategoriesResponse
import aws.sdk.kotlin.services.docdb.model.DescribeEventSubscriptionsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeEventSubscriptionsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeEventsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeEventsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeGlobalClustersRequest
import aws.sdk.kotlin.services.docdb.model.DescribeGlobalClustersResponse
import aws.sdk.kotlin.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse
import aws.sdk.kotlin.services.docdb.model.DescribePendingMaintenanceActionsRequest
import aws.sdk.kotlin.services.docdb.model.DescribePendingMaintenanceActionsResponse
import aws.sdk.kotlin.services.docdb.model.FailoverDbClusterRequest
import aws.sdk.kotlin.services.docdb.model.FailoverDbClusterResponse
import aws.sdk.kotlin.services.docdb.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.docdb.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.docdb.model.ModifyDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.docdb.model.ModifyDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.docdb.model.ModifyDbClusterRequest
import aws.sdk.kotlin.services.docdb.model.ModifyDbClusterResponse
import aws.sdk.kotlin.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest
import aws.sdk.kotlin.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse
import aws.sdk.kotlin.services.docdb.model.ModifyDbInstanceRequest
import aws.sdk.kotlin.services.docdb.model.ModifyDbInstanceResponse
import aws.sdk.kotlin.services.docdb.model.ModifyDbSubnetGroupRequest
import aws.sdk.kotlin.services.docdb.model.ModifyDbSubnetGroupResponse
import aws.sdk.kotlin.services.docdb.model.ModifyEventSubscriptionRequest
import aws.sdk.kotlin.services.docdb.model.ModifyEventSubscriptionResponse
import aws.sdk.kotlin.services.docdb.model.ModifyGlobalClusterRequest
import aws.sdk.kotlin.services.docdb.model.ModifyGlobalClusterResponse
import aws.sdk.kotlin.services.docdb.model.RebootDbInstanceRequest
import aws.sdk.kotlin.services.docdb.model.RebootDbInstanceResponse
import aws.sdk.kotlin.services.docdb.model.RemoveFromGlobalClusterRequest
import aws.sdk.kotlin.services.docdb.model.RemoveFromGlobalClusterResponse
import aws.sdk.kotlin.services.docdb.model.RemoveSourceIdentifierFromSubscriptionRequest
import aws.sdk.kotlin.services.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse
import aws.sdk.kotlin.services.docdb.model.RemoveTagsFromResourceRequest
import aws.sdk.kotlin.services.docdb.model.RemoveTagsFromResourceResponse
import aws.sdk.kotlin.services.docdb.model.ResetDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.docdb.model.ResetDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.docdb.model.RestoreDbClusterFromSnapshotRequest
import aws.sdk.kotlin.services.docdb.model.RestoreDbClusterFromSnapshotResponse
import aws.sdk.kotlin.services.docdb.model.RestoreDbClusterToPointInTimeRequest
import aws.sdk.kotlin.services.docdb.model.RestoreDbClusterToPointInTimeResponse
import aws.sdk.kotlin.services.docdb.model.StartDbClusterRequest
import aws.sdk.kotlin.services.docdb.model.StartDbClusterResponse
import aws.sdk.kotlin.services.docdb.model.StopDbClusterRequest
import aws.sdk.kotlin.services.docdb.model.StopDbClusterResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon DocumentDB API documentation
 */
public interface DocDbClient : SdkClient {

    override val serviceName: String
        get() = "DocDB"
    /**
     * DocDbClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): DocDbClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDocDbClient(config)
        }

        public operator fun invoke(config: Config): DocDbClient = DefaultDocDbClient(config)

        /**
         * Construct a [DocDbClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DocDbClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultDocDbClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a source identifier to an existing event notification subscription.
     */
    public suspend fun addSourceIdentifierToSubscription(input: AddSourceIdentifierToSubscriptionRequest): AddSourceIdentifierToSubscriptionResponse

    /**
     * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to track costs that are associated with Amazon DocumentDB resources or in a `Condition` statement in an Identity and Access Management (IAM) policy for Amazon DocumentDB.
     */
    public suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Applies a pending maintenance action to a resource (for example, to an Amazon DocumentDB instance).
     */
    public suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse

    /**
     * Copies the specified cluster parameter group.
     */
    public suspend fun copyDbClusterParameterGroup(input: CopyDbClusterParameterGroupRequest): CopyDbClusterParameterGroupResponse

    /**
     * Copies a snapshot of a cluster.
     *
     * To copy a cluster snapshot from a shared manual cluster snapshot, `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name (ARN) of the shared cluster snapshot. You can only copy a shared DB cluster snapshot, whether encrypted or not, in the same Amazon Web Services Region.
     *
     * To cancel the copy operation after it is in progress, delete the target cluster snapshot identified by `TargetDBClusterSnapshotIdentifier` while that cluster snapshot is in the *copying* status.
     */
    public suspend fun copyDbClusterSnapshot(input: CopyDbClusterSnapshotRequest): CopyDbClusterSnapshotResponse

    /**
     * Creates a new Amazon DocumentDB cluster.
     */
    public suspend fun createDbCluster(input: CreateDbClusterRequest): CreateDbClusterResponse

    /**
     * Creates a new cluster parameter group.
     *
     * Parameters in a cluster parameter group apply to all of the instances in a cluster.
     *
     * A cluster parameter group is initially created with the default parameters for the database engine used by instances in the cluster. In Amazon DocumentDB, you cannot make modifications directly to the `default.docdb3.6` cluster parameter group. If your Amazon DocumentDB cluster is using the default cluster parameter group and you want to modify a value in it, you must first [ create a new parameter group](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html) or [ copy an existing parameter group](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html), modify it, and then apply the modified parameter group to your cluster. For the new cluster parameter group and associated settings to take effect, you must then reboot the instances in the cluster without failover. For more information, see [ Modifying Amazon DocumentDB Cluster Parameter Groups](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html).
     */
    public suspend fun createDbClusterParameterGroup(input: CreateDbClusterParameterGroupRequest): CreateDbClusterParameterGroupResponse

    /**
     * Creates a snapshot of a cluster.
     */
    public suspend fun createDbClusterSnapshot(input: CreateDbClusterSnapshotRequest): CreateDbClusterSnapshotResponse

    /**
     * Creates a new instance.
     */
    public suspend fun createDbInstance(input: CreateDbInstanceRequest): CreateDbInstanceResponse

    /**
     * Creates a new subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
     */
    public suspend fun createDbSubnetGroup(input: CreateDbSubnetGroupRequest): CreateDbSubnetGroupResponse

    /**
     * Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.
     *
     * You can specify the type of source (`SourceType`) that you want to be notified of. You can also provide a list of Amazon DocumentDB sources (`SourceIds`) that trigger the events, and you can provide a list of event categories (`EventCategories`) for events that you want to be notified of. For example, you can specify `SourceType = db-instance`, `SourceIds = mydbinstance1, mydbinstance2` and `EventCategories = Availability, Backup`.
     *
     * If you specify both the `SourceType` and `SourceIds` (such as `SourceType = db-instance` and `SourceIdentifier = myDBInstance1`), you are notified of all the `db-instance` events for the specified source. If you specify a `SourceType` but do not specify a `SourceIdentifier`, you receive notice of the events for that source type for all your Amazon DocumentDB sources. If you do not specify either the `SourceType` or the `SourceIdentifier`, you are notified of events generated from all Amazon DocumentDB sources belonging to your customer account.
     */
    public suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse

    /**
     * Creates an Amazon DocumentDB global cluster that can span multiple multiple Amazon Web Services Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.
     *
     * You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    public suspend fun createGlobalCluster(input: CreateGlobalClusterRequest): CreateGlobalClusterResponse

    /**
     * Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
     */
    public suspend fun deleteDbCluster(input: DeleteDbClusterRequest): DeleteDbClusterResponse

    /**
     * Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.
     */
    public suspend fun deleteDbClusterParameterGroup(input: DeleteDbClusterParameterGroupRequest): DeleteDbClusterParameterGroupResponse

    /**
     * Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     *
     * The cluster snapshot must be in the `available` state to be deleted.
     */
    public suspend fun deleteDbClusterSnapshot(input: DeleteDbClusterSnapshotRequest): DeleteDbClusterSnapshotResponse

    /**
     * Deletes a previously provisioned instance.
     */
    public suspend fun deleteDbInstance(input: DeleteDbInstanceRequest): DeleteDbInstanceResponse

    /**
     * Deletes a subnet group.
     *
     * The specified database subnet group must not be associated with any DB instances.
     */
    public suspend fun deleteDbSubnetGroup(input: DeleteDbSubnetGroupRequest): DeleteDbSubnetGroupResponse

    /**
     * Deletes an Amazon DocumentDB event notification subscription.
     */
    public suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse

    /**
     * Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    public suspend fun deleteGlobalCluster(input: DeleteGlobalClusterRequest): DeleteGlobalClusterResponse

    /**
     * Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this Amazon Web Services account.
     */
    public suspend fun describeCertificates(input: DescribeCertificatesRequest = DescribeCertificatesRequest {}): DescribeCertificatesResponse

    /**
     * Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list contains only the description of the specified cluster parameter group.
     */
    public suspend fun describeDbClusterParameterGroups(input: DescribeDbClusterParameterGroupsRequest = DescribeDbClusterParameterGroupsRequest {}): DescribeDbClusterParameterGroupsResponse

    /**
     * Returns the detailed parameter list for a particular cluster parameter group.
     */
    public suspend fun describeDbClusterParameters(input: DescribeDbClusterParametersRequest): DescribeDbClusterParametersResponse

    /**
     * Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot.
     *
     * When you share snapshots with other Amazon Web Services accounts, `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute and a list of IDs for the Amazon Web Services accounts that are authorized to copy or restore the manual cluster snapshot. If `all` is included in the list of values for the `restore` attribute, then the manual cluster snapshot is public and can be copied or restored by all Amazon Web Services accounts.
     */
    public suspend fun describeDbClusterSnapshotAttributes(input: DescribeDbClusterSnapshotAttributesRequest): DescribeDbClusterSnapshotAttributesResponse

    /**
     * Returns information about cluster snapshots. This API operation supports pagination.
     */
    public suspend fun describeDbClusterSnapshots(input: DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest {}): DescribeDbClusterSnapshotsResponse

    /**
     * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages operational technology that is shared with Amazon RDS and Amazon Neptune. Use the `filterName=engine,Values=docdb` filter parameter to return only Amazon DocumentDB clusters.
     */
    public suspend fun describeDbClusters(input: DescribeDbClustersRequest = DescribeDbClustersRequest {}): DescribeDbClustersResponse

    /**
     * Returns a list of the available engines.
     */
    public suspend fun describeDbEngineVersions(input: DescribeDbEngineVersionsRequest = DescribeDbEngineVersionsRequest {}): DescribeDbEngineVersionsResponse

    /**
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     */
    public suspend fun describeDbInstances(input: DescribeDbInstancesRequest = DescribeDbInstancesRequest {}): DescribeDbInstancesResponse

    /**
     * Returns a list of `DBSubnetGroup` descriptions. If a `DBSubnetGroupName` is specified, the list will contain only the descriptions of the specified `DBSubnetGroup`.
     */
    public suspend fun describeDbSubnetGroups(input: DescribeDbSubnetGroupsRequest = DescribeDbSubnetGroupsRequest {}): DescribeDbSubnetGroupsResponse

    /**
     * Returns the default engine and system parameter information for the cluster database engine.
     */
    public suspend fun describeEngineDefaultClusterParameters(input: DescribeEngineDefaultClusterParametersRequest): DescribeEngineDefaultClusterParametersResponse

    /**
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     */
    public suspend fun describeEventCategories(input: DescribeEventCategoriesRequest = DescribeEventCategoriesRequest {}): DescribeEventCategoriesResponse

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
     *
     * If you specify a `SubscriptionName`, lists the description for that subscription.
     */
    public suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest = DescribeEventSubscriptionsRequest {}): DescribeEventSubscriptionsResponse

    /**
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.
     */
    public suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest {}): DescribeEventsResponse

    /**
     * Returns information about Amazon DocumentDB global clusters. This API supports pagination.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    public suspend fun describeGlobalClusters(input: DescribeGlobalClustersRequest = DescribeGlobalClustersRequest {}): DescribeGlobalClustersResponse

    /**
     * Returns a list of orderable instance options for the specified engine.
     */
    public suspend fun describeOrderableDbInstanceOptions(input: DescribeOrderableDbInstanceOptionsRequest): DescribeOrderableDbInstanceOptionsResponse

    /**
     * Returns a list of resources (for example, instances) that have at least one pending maintenance action.
     */
    public suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest = DescribePendingMaintenanceActionsRequest {}): DescribePendingMaintenanceActionsResponse

    /**
     * Forces a failover for a cluster.
     *
     * A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer).
     *
     * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
     */
    public suspend fun failoverDbCluster(input: FailoverDbClusterRequest = FailoverDbClusterRequest {}): FailoverDbClusterResponse

    /**
     * Lists all tags on an Amazon DocumentDB resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    public suspend fun modifyDbCluster(input: ModifyDbClusterRequest): ModifyDbClusterResponse

    /**
     * Modifies the parameters of a cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
     *
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot or maintenance window before the change can take effect.
     *
     * After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully complete the create action before the parameter group is used as the default for a new cluster. This step is especially important for parameters that are critical when creating the default database for a cluster, such as the character set for the default database defined by the `character_set_database` parameter.
     */
    public suspend fun modifyDbClusterParameterGroup(input: ModifyDbClusterParameterGroupRequest): ModifyDbClusterParameterGroupResponse

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.
     *
     * To share a manual cluster snapshot with other Amazon Web Services accounts, specify `restore` as the `AttributeName`, and use the `ValuesToAdd` parameter to add a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual cluster snapshot. Use the value `all` to make the manual cluster snapshot public, which means that it can be copied or restored by all Amazon Web Services accounts. Do not add the `all` value for any manual cluster snapshots that contain private information that you don't want available to all Amazon Web Services accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web Services account IDs for the `ValuesToAdd` parameter. You can't use `all` as a value for that parameter in this case.
     */
    public suspend fun modifyDbClusterSnapshotAttribute(input: ModifyDbClusterSnapshotAttributeRequest): ModifyDbClusterSnapshotAttributeResponse

    /**
     * Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    public suspend fun modifyDbInstance(input: ModifyDbInstanceRequest): ModifyDbInstanceResponse

    /**
     * Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
     */
    public suspend fun modifyDbSubnetGroup(input: ModifyDbSubnetGroupRequest): ModifyDbSubnetGroupResponse

    /**
     * Modifies an existing Amazon DocumentDB event notification subscription.
     */
    public suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse

    /**
     * Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    public suspend fun modifyGlobalCluster(input: ModifyGlobalClusterRequest): ModifyGlobalClusterResponse

    /**
     * You might need to reboot your instance, usually for maintenance reasons. For example, if you make certain changes, or if you change the cluster parameter group that is associated with the instance, you must reboot the instance for the changes to take effect.
     *
     * Rebooting an instance restarts the database engine service. Rebooting an instance results in a momentary outage, during which the instance status is set to *rebooting*.
     */
    public suspend fun rebootDbInstance(input: RebootDbInstanceRequest): RebootDbInstanceResponse

    /**
     * Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    public suspend fun removeFromGlobalCluster(input: RemoveFromGlobalClusterRequest): RemoveFromGlobalClusterResponse

    /**
     * Removes a source identifier from an existing Amazon DocumentDB event notification subscription.
     */
    public suspend fun removeSourceIdentifierFromSubscription(input: RemoveSourceIdentifierFromSubscriptionRequest): RemoveSourceIdentifierFromSubscriptionResponse

    /**
     * Removes metadata tags from an Amazon DocumentDB resource.
     */
    public suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Modifies the parameters of a cluster parameter group to the default value. To reset specific parameters, submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
     *
     *  When you reset the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance reboot.
     */
    public suspend fun resetDbClusterParameterGroup(input: ResetDbClusterParameterGroupRequest): ResetDbClusterParameterGroupResponse

    /**
     * Creates a new cluster from a snapshot or cluster snapshot.
     *
     * If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group.
     *
     * If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.
     */
    public suspend fun restoreDbClusterFromSnapshot(input: RestoreDbClusterFromSnapshotRequest): RestoreDbClusterFromSnapshotResponse

    /**
     * Restores a cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target cluster is created from the source cluster with the same configuration as the original cluster, except that the new cluster is created with the default security group.
     */
    public suspend fun restoreDbClusterToPointInTime(input: RestoreDbClusterToPointInTimeRequest): RestoreDbClusterToPointInTimeResponse

    /**
     * Restarts the stopped cluster that is specified by `DBClusterIdentifier`. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
     */
    public suspend fun startDbCluster(input: StartDbClusterRequest): StartDbClusterResponse

    /**
     * Stops the running cluster that is specified by `DBClusterIdentifier`. The cluster must be in the *available* state. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
     */
    public suspend fun stopDbCluster(input: StopDbClusterRequest): StopDbClusterResponse
}

/**
 * Adds a source identifier to an existing event notification subscription.
 */
public suspend inline fun DocDbClient.addSourceIdentifierToSubscription(crossinline block: AddSourceIdentifierToSubscriptionRequest.Builder.() -> Unit): AddSourceIdentifierToSubscriptionResponse = addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest.Builder().apply(block).build())

/**
 * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to track costs that are associated with Amazon DocumentDB resources or in a `Condition` statement in an Identity and Access Management (IAM) policy for Amazon DocumentDB.
 */
public suspend inline fun DocDbClient.addTagsToResource(crossinline block: AddTagsToResourceRequest.Builder.() -> Unit): AddTagsToResourceResponse = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

/**
 * Applies a pending maintenance action to a resource (for example, to an Amazon DocumentDB instance).
 */
public suspend inline fun DocDbClient.applyPendingMaintenanceAction(crossinline block: ApplyPendingMaintenanceActionRequest.Builder.() -> Unit): ApplyPendingMaintenanceActionResponse = applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.Builder().apply(block).build())

/**
 * Copies the specified cluster parameter group.
 */
public suspend inline fun DocDbClient.copyDbClusterParameterGroup(crossinline block: CopyDbClusterParameterGroupRequest.Builder.() -> Unit): CopyDbClusterParameterGroupResponse = copyDbClusterParameterGroup(CopyDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Copies a snapshot of a cluster.
 *
 * To copy a cluster snapshot from a shared manual cluster snapshot, `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name (ARN) of the shared cluster snapshot. You can only copy a shared DB cluster snapshot, whether encrypted or not, in the same Amazon Web Services Region.
 *
 * To cancel the copy operation after it is in progress, delete the target cluster snapshot identified by `TargetDBClusterSnapshotIdentifier` while that cluster snapshot is in the *copying* status.
 */
public suspend inline fun DocDbClient.copyDbClusterSnapshot(crossinline block: CopyDbClusterSnapshotRequest.Builder.() -> Unit): CopyDbClusterSnapshotResponse = copyDbClusterSnapshot(CopyDbClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon DocumentDB cluster.
 */
public suspend inline fun DocDbClient.createDbCluster(crossinline block: CreateDbClusterRequest.Builder.() -> Unit): CreateDbClusterResponse = createDbCluster(CreateDbClusterRequest.Builder().apply(block).build())

/**
 * Creates a new cluster parameter group.
 *
 * Parameters in a cluster parameter group apply to all of the instances in a cluster.
 *
 * A cluster parameter group is initially created with the default parameters for the database engine used by instances in the cluster. In Amazon DocumentDB, you cannot make modifications directly to the `default.docdb3.6` cluster parameter group. If your Amazon DocumentDB cluster is using the default cluster parameter group and you want to modify a value in it, you must first [ create a new parameter group](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html) or [ copy an existing parameter group](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html), modify it, and then apply the modified parameter group to your cluster. For the new cluster parameter group and associated settings to take effect, you must then reboot the instances in the cluster without failover. For more information, see [ Modifying Amazon DocumentDB Cluster Parameter Groups](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html).
 */
public suspend inline fun DocDbClient.createDbClusterParameterGroup(crossinline block: CreateDbClusterParameterGroupRequest.Builder.() -> Unit): CreateDbClusterParameterGroupResponse = createDbClusterParameterGroup(CreateDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of a cluster.
 */
public suspend inline fun DocDbClient.createDbClusterSnapshot(crossinline block: CreateDbClusterSnapshotRequest.Builder.() -> Unit): CreateDbClusterSnapshotResponse = createDbClusterSnapshot(CreateDbClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a new instance.
 */
public suspend inline fun DocDbClient.createDbInstance(crossinline block: CreateDbInstanceRequest.Builder.() -> Unit): CreateDbInstanceResponse = createDbInstance(CreateDbInstanceRequest.Builder().apply(block).build())

/**
 * Creates a new subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
 */
public suspend inline fun DocDbClient.createDbSubnetGroup(crossinline block: CreateDbSubnetGroupRequest.Builder.() -> Unit): CreateDbSubnetGroupResponse = createDbSubnetGroup(CreateDbSubnetGroupRequest.Builder().apply(block).build())

/**
 * Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.
 *
 * You can specify the type of source (`SourceType`) that you want to be notified of. You can also provide a list of Amazon DocumentDB sources (`SourceIds`) that trigger the events, and you can provide a list of event categories (`EventCategories`) for events that you want to be notified of. For example, you can specify `SourceType = db-instance`, `SourceIds = mydbinstance1, mydbinstance2` and `EventCategories = Availability, Backup`.
 *
 * If you specify both the `SourceType` and `SourceIds` (such as `SourceType = db-instance` and `SourceIdentifier = myDBInstance1`), you are notified of all the `db-instance` events for the specified source. If you specify a `SourceType` but do not specify a `SourceIdentifier`, you receive notice of the events for that source type for all your Amazon DocumentDB sources. If you do not specify either the `SourceType` or the `SourceIdentifier`, you are notified of events generated from all Amazon DocumentDB sources belonging to your customer account.
 */
public suspend inline fun DocDbClient.createEventSubscription(crossinline block: CreateEventSubscriptionRequest.Builder.() -> Unit): CreateEventSubscriptionResponse = createEventSubscription(CreateEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates an Amazon DocumentDB global cluster that can span multiple multiple Amazon Web Services Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.
 *
 * You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster.
 *
 * This action only applies to Amazon DocumentDB clusters.
 */
public suspend inline fun DocDbClient.createGlobalCluster(crossinline block: CreateGlobalClusterRequest.Builder.() -> Unit): CreateGlobalClusterResponse = createGlobalCluster(CreateGlobalClusterRequest.Builder().apply(block).build())

/**
 * Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
 */
public suspend inline fun DocDbClient.deleteDbCluster(crossinline block: DeleteDbClusterRequest.Builder.() -> Unit): DeleteDbClusterResponse = deleteDbCluster(DeleteDbClusterRequest.Builder().apply(block).build())

/**
 * Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.
 */
public suspend inline fun DocDbClient.deleteDbClusterParameterGroup(crossinline block: DeleteDbClusterParameterGroupRequest.Builder.() -> Unit): DeleteDbClusterParameterGroupResponse = deleteDbClusterParameterGroup(DeleteDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
 *
 * The cluster snapshot must be in the `available` state to be deleted.
 */
public suspend inline fun DocDbClient.deleteDbClusterSnapshot(crossinline block: DeleteDbClusterSnapshotRequest.Builder.() -> Unit): DeleteDbClusterSnapshotResponse = deleteDbClusterSnapshot(DeleteDbClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes a previously provisioned instance.
 */
public suspend inline fun DocDbClient.deleteDbInstance(crossinline block: DeleteDbInstanceRequest.Builder.() -> Unit): DeleteDbInstanceResponse = deleteDbInstance(DeleteDbInstanceRequest.Builder().apply(block).build())

/**
 * Deletes a subnet group.
 *
 * The specified database subnet group must not be associated with any DB instances.
 */
public suspend inline fun DocDbClient.deleteDbSubnetGroup(crossinline block: DeleteDbSubnetGroupRequest.Builder.() -> Unit): DeleteDbSubnetGroupResponse = deleteDbSubnetGroup(DeleteDbSubnetGroupRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon DocumentDB event notification subscription.
 */
public suspend inline fun DocDbClient.deleteEventSubscription(crossinline block: DeleteEventSubscriptionRequest.Builder.() -> Unit): DeleteEventSubscriptionResponse = deleteEventSubscription(DeleteEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.
 *
 * This action only applies to Amazon DocumentDB clusters.
 */
public suspend inline fun DocDbClient.deleteGlobalCluster(crossinline block: DeleteGlobalClusterRequest.Builder.() -> Unit): DeleteGlobalClusterResponse = deleteGlobalCluster(DeleteGlobalClusterRequest.Builder().apply(block).build())

/**
 * Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this Amazon Web Services account.
 */
public suspend inline fun DocDbClient.describeCertificates(crossinline block: DescribeCertificatesRequest.Builder.() -> Unit): DescribeCertificatesResponse = describeCertificates(DescribeCertificatesRequest.Builder().apply(block).build())

/**
 * Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list contains only the description of the specified cluster parameter group.
 */
public suspend inline fun DocDbClient.describeDbClusterParameterGroups(crossinline block: DescribeDbClusterParameterGroupsRequest.Builder.() -> Unit): DescribeDbClusterParameterGroupsResponse = describeDbClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.Builder().apply(block).build())

/**
 * Returns the detailed parameter list for a particular cluster parameter group.
 */
public suspend inline fun DocDbClient.describeDbClusterParameters(crossinline block: DescribeDbClusterParametersRequest.Builder.() -> Unit): DescribeDbClusterParametersResponse = describeDbClusterParameters(DescribeDbClusterParametersRequest.Builder().apply(block).build())

/**
 * Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot.
 *
 * When you share snapshots with other Amazon Web Services accounts, `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute and a list of IDs for the Amazon Web Services accounts that are authorized to copy or restore the manual cluster snapshot. If `all` is included in the list of values for the `restore` attribute, then the manual cluster snapshot is public and can be copied or restored by all Amazon Web Services accounts.
 */
public suspend inline fun DocDbClient.describeDbClusterSnapshotAttributes(crossinline block: DescribeDbClusterSnapshotAttributesRequest.Builder.() -> Unit): DescribeDbClusterSnapshotAttributesResponse = describeDbClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.Builder().apply(block).build())

/**
 * Returns information about cluster snapshots. This API operation supports pagination.
 */
public suspend inline fun DocDbClient.describeDbClusterSnapshots(crossinline block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit): DescribeDbClusterSnapshotsResponse = describeDbClusterSnapshots(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages operational technology that is shared with Amazon RDS and Amazon Neptune. Use the `filterName=engine,Values=docdb` filter parameter to return only Amazon DocumentDB clusters.
 */
public suspend inline fun DocDbClient.describeDbClusters(crossinline block: DescribeDbClustersRequest.Builder.() -> Unit): DescribeDbClustersResponse = describeDbClusters(DescribeDbClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of the available engines.
 */
public suspend inline fun DocDbClient.describeDbEngineVersions(crossinline block: DescribeDbEngineVersionsRequest.Builder.() -> Unit): DescribeDbEngineVersionsResponse = describeDbEngineVersions(DescribeDbEngineVersionsRequest.Builder().apply(block).build())

/**
 * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
 */
public suspend inline fun DocDbClient.describeDbInstances(crossinline block: DescribeDbInstancesRequest.Builder.() -> Unit): DescribeDbInstancesResponse = describeDbInstances(DescribeDbInstancesRequest.Builder().apply(block).build())

/**
 * Returns a list of `DBSubnetGroup` descriptions. If a `DBSubnetGroupName` is specified, the list will contain only the descriptions of the specified `DBSubnetGroup`.
 */
public suspend inline fun DocDbClient.describeDbSubnetGroups(crossinline block: DescribeDbSubnetGroupsRequest.Builder.() -> Unit): DescribeDbSubnetGroupsResponse = describeDbSubnetGroups(DescribeDbSubnetGroupsRequest.Builder().apply(block).build())

/**
 * Returns the default engine and system parameter information for the cluster database engine.
 */
public suspend inline fun DocDbClient.describeEngineDefaultClusterParameters(crossinline block: DescribeEngineDefaultClusterParametersRequest.Builder.() -> Unit): DescribeEngineDefaultClusterParametersResponse = describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.Builder().apply(block).build())

/**
 * Displays a list of categories for all event source types, or, if specified, for a specified source type.
 */
public suspend inline fun DocDbClient.describeEventCategories(crossinline block: DescribeEventCategoriesRequest.Builder.() -> Unit): DescribeEventCategoriesResponse = describeEventCategories(DescribeEventCategoriesRequest.Builder().apply(block).build())

/**
 * Lists all the subscription descriptions for a customer account. The description for a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
 *
 * If you specify a `SubscriptionName`, lists the description for that subscription.
 */
public suspend inline fun DocDbClient.describeEventSubscriptions(crossinline block: DescribeEventSubscriptionsRequest.Builder.() -> Unit): DescribeEventSubscriptionsResponse = describeEventSubscriptions(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

/**
 * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.
 */
public suspend inline fun DocDbClient.describeEvents(crossinline block: DescribeEventsRequest.Builder.() -> Unit): DescribeEventsResponse = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

/**
 * Returns information about Amazon DocumentDB global clusters. This API supports pagination.
 *
 * This action only applies to Amazon DocumentDB clusters.
 */
public suspend inline fun DocDbClient.describeGlobalClusters(crossinline block: DescribeGlobalClustersRequest.Builder.() -> Unit): DescribeGlobalClustersResponse = describeGlobalClusters(DescribeGlobalClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of orderable instance options for the specified engine.
 */
public suspend inline fun DocDbClient.describeOrderableDbInstanceOptions(crossinline block: DescribeOrderableDbInstanceOptionsRequest.Builder.() -> Unit): DescribeOrderableDbInstanceOptionsResponse = describeOrderableDbInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.Builder().apply(block).build())

/**
 * Returns a list of resources (for example, instances) that have at least one pending maintenance action.
 */
public suspend inline fun DocDbClient.describePendingMaintenanceActions(crossinline block: DescribePendingMaintenanceActionsRequest.Builder.() -> Unit): DescribePendingMaintenanceActionsResponse = describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.Builder().apply(block).build())

/**
 * Forces a failover for a cluster.
 *
 * A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer).
 *
 * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
 */
public suspend inline fun DocDbClient.failoverDbCluster(crossinline block: FailoverDbClusterRequest.Builder.() -> Unit): FailoverDbClusterResponse = failoverDbCluster(FailoverDbClusterRequest.Builder().apply(block).build())

/**
 * Lists all tags on an Amazon DocumentDB resource.
 */
public suspend inline fun DocDbClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
 */
public suspend inline fun DocDbClient.modifyDbCluster(crossinline block: ModifyDbClusterRequest.Builder.() -> Unit): ModifyDbClusterResponse = modifyDbCluster(ModifyDbClusterRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
 *
 * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot or maintenance window before the change can take effect.
 *
 * After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully complete the create action before the parameter group is used as the default for a new cluster. This step is especially important for parameters that are critical when creating the default database for a cluster, such as the character set for the default database defined by the `character_set_database` parameter.
 */
public suspend inline fun DocDbClient.modifyDbClusterParameterGroup(crossinline block: ModifyDbClusterParameterGroupRequest.Builder.() -> Unit): ModifyDbClusterParameterGroupResponse = modifyDbClusterParameterGroup(ModifyDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.
 *
 * To share a manual cluster snapshot with other Amazon Web Services accounts, specify `restore` as the `AttributeName`, and use the `ValuesToAdd` parameter to add a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual cluster snapshot. Use the value `all` to make the manual cluster snapshot public, which means that it can be copied or restored by all Amazon Web Services accounts. Do not add the `all` value for any manual cluster snapshots that contain private information that you don't want available to all Amazon Web Services accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web Services account IDs for the `ValuesToAdd` parameter. You can't use `all` as a value for that parameter in this case.
 */
public suspend inline fun DocDbClient.modifyDbClusterSnapshotAttribute(crossinline block: ModifyDbClusterSnapshotAttributeRequest.Builder.() -> Unit): ModifyDbClusterSnapshotAttributeResponse = modifyDbClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest.Builder().apply(block).build())

/**
 * Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
 */
public suspend inline fun DocDbClient.modifyDbInstance(crossinline block: ModifyDbInstanceRequest.Builder.() -> Unit): ModifyDbInstanceResponse = modifyDbInstance(ModifyDbInstanceRequest.Builder().apply(block).build())

/**
 * Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
 */
public suspend inline fun DocDbClient.modifyDbSubnetGroup(crossinline block: ModifyDbSubnetGroupRequest.Builder.() -> Unit): ModifyDbSubnetGroupResponse = modifyDbSubnetGroup(ModifyDbSubnetGroupRequest.Builder().apply(block).build())

/**
 * Modifies an existing Amazon DocumentDB event notification subscription.
 */
public suspend inline fun DocDbClient.modifyEventSubscription(crossinline block: ModifyEventSubscriptionRequest.Builder.() -> Unit): ModifyEventSubscriptionResponse = modifyEventSubscription(ModifyEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.
 *
 * This action only applies to Amazon DocumentDB clusters.
 */
public suspend inline fun DocDbClient.modifyGlobalCluster(crossinline block: ModifyGlobalClusterRequest.Builder.() -> Unit): ModifyGlobalClusterResponse = modifyGlobalCluster(ModifyGlobalClusterRequest.Builder().apply(block).build())

/**
 * You might need to reboot your instance, usually for maintenance reasons. For example, if you make certain changes, or if you change the cluster parameter group that is associated with the instance, you must reboot the instance for the changes to take effect.
 *
 * Rebooting an instance restarts the database engine service. Rebooting an instance results in a momentary outage, during which the instance status is set to *rebooting*.
 */
public suspend inline fun DocDbClient.rebootDbInstance(crossinline block: RebootDbInstanceRequest.Builder.() -> Unit): RebootDbInstanceResponse = rebootDbInstance(RebootDbInstanceRequest.Builder().apply(block).build())

/**
 * Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region.
 *
 * This action only applies to Amazon DocumentDB clusters.
 */
public suspend inline fun DocDbClient.removeFromGlobalCluster(crossinline block: RemoveFromGlobalClusterRequest.Builder.() -> Unit): RemoveFromGlobalClusterResponse = removeFromGlobalCluster(RemoveFromGlobalClusterRequest.Builder().apply(block).build())

/**
 * Removes a source identifier from an existing Amazon DocumentDB event notification subscription.
 */
public suspend inline fun DocDbClient.removeSourceIdentifierFromSubscription(crossinline block: RemoveSourceIdentifierFromSubscriptionRequest.Builder.() -> Unit): RemoveSourceIdentifierFromSubscriptionResponse = removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest.Builder().apply(block).build())

/**
 * Removes metadata tags from an Amazon DocumentDB resource.
 */
public suspend inline fun DocDbClient.removeTagsFromResource(crossinline block: RemoveTagsFromResourceRequest.Builder.() -> Unit): RemoveTagsFromResourceResponse = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a cluster parameter group to the default value. To reset specific parameters, submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
 *
 *  When you reset the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance reboot.
 */
public suspend inline fun DocDbClient.resetDbClusterParameterGroup(crossinline block: ResetDbClusterParameterGroupRequest.Builder.() -> Unit): ResetDbClusterParameterGroupResponse = resetDbClusterParameterGroup(ResetDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Creates a new cluster from a snapshot or cluster snapshot.
 *
 * If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group.
 *
 * If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.
 */
public suspend inline fun DocDbClient.restoreDbClusterFromSnapshot(crossinline block: RestoreDbClusterFromSnapshotRequest.Builder.() -> Unit): RestoreDbClusterFromSnapshotResponse = restoreDbClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest.Builder().apply(block).build())

/**
 * Restores a cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target cluster is created from the source cluster with the same configuration as the original cluster, except that the new cluster is created with the default security group.
 */
public suspend inline fun DocDbClient.restoreDbClusterToPointInTime(crossinline block: RestoreDbClusterToPointInTimeRequest.Builder.() -> Unit): RestoreDbClusterToPointInTimeResponse = restoreDbClusterToPointInTime(RestoreDbClusterToPointInTimeRequest.Builder().apply(block).build())

/**
 * Restarts the stopped cluster that is specified by `DBClusterIdentifier`. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
 */
public suspend inline fun DocDbClient.startDbCluster(crossinline block: StartDbClusterRequest.Builder.() -> Unit): StartDbClusterResponse = startDbCluster(StartDbClusterRequest.Builder().apply(block).build())

/**
 * Stops the running cluster that is specified by `DBClusterIdentifier`. The cluster must be in the *available* state. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
 */
public suspend inline fun DocDbClient.stopDbCluster(crossinline block: StopDbClusterRequest.Builder.() -> Unit): StopDbClusterResponse = stopDbCluster(StopDbClusterRequest.Builder().apply(block).build())
