// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CopyDBClusterParameterGroup.
 */
public class CopyDbClusterParameterGroupRequest private constructor(builder: Builder) {
    /**
     * The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.
     *
     * Constraints:
     * + Must specify a valid cluster parameter group.
     * + If the source cluster parameter group is in the same Amazon Web Services Region as the copy, specify a valid parameter group identifier; for example, `my-db-cluster-param-group`, or a valid ARN.
     * + If the source parameter group is in a different Amazon Web Services Region than the copy, specify a valid cluster parameter group ARN; for example, `arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group`.
     */
    public val sourceDbClusterParameterGroupIdentifier: kotlin.String? = builder.sourceDbClusterParameterGroupIdentifier
    /**
     * The tags that are to be assigned to the parameter group.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A description for the copied cluster parameter group.
     */
    public val targetDbClusterParameterGroupDescription: kotlin.String? = builder.targetDbClusterParameterGroupDescription
    /**
     * The identifier for the copied cluster parameter group.
     *
     * Constraints:
     * + Cannot be null, empty, or blank.
     * + Must contain from 1 to 255 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-cluster-param-group1`
     */
    public val targetDbClusterParameterGroupIdentifier: kotlin.String? = builder.targetDbClusterParameterGroupIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.CopyDbClusterParameterGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyDbClusterParameterGroupRequest(")
        append("sourceDbClusterParameterGroupIdentifier=$sourceDbClusterParameterGroupIdentifier,")
        append("tags=$tags,")
        append("targetDbClusterParameterGroupDescription=$targetDbClusterParameterGroupDescription,")
        append("targetDbClusterParameterGroupIdentifier=$targetDbClusterParameterGroupIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceDbClusterParameterGroupIdentifier?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterParameterGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterParameterGroupIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyDbClusterParameterGroupRequest

        if (sourceDbClusterParameterGroupIdentifier != other.sourceDbClusterParameterGroupIdentifier) return false
        if (tags != other.tags) return false
        if (targetDbClusterParameterGroupDescription != other.targetDbClusterParameterGroupDescription) return false
        if (targetDbClusterParameterGroupIdentifier != other.targetDbClusterParameterGroupIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.CopyDbClusterParameterGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.
         *
         * Constraints:
         * + Must specify a valid cluster parameter group.
         * + If the source cluster parameter group is in the same Amazon Web Services Region as the copy, specify a valid parameter group identifier; for example, `my-db-cluster-param-group`, or a valid ARN.
         * + If the source parameter group is in a different Amazon Web Services Region than the copy, specify a valid cluster parameter group ARN; for example, `arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group`.
         */
        public var sourceDbClusterParameterGroupIdentifier: kotlin.String? = null
        /**
         * The tags that are to be assigned to the parameter group.
         */
        public var tags: List<Tag>? = null
        /**
         * A description for the copied cluster parameter group.
         */
        public var targetDbClusterParameterGroupDescription: kotlin.String? = null
        /**
         * The identifier for the copied cluster parameter group.
         *
         * Constraints:
         * + Cannot be null, empty, or blank.
         * + Must contain from 1 to 255 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-cluster-param-group1`
         */
        public var targetDbClusterParameterGroupIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.CopyDbClusterParameterGroupRequest) : this() {
            this.sourceDbClusterParameterGroupIdentifier = x.sourceDbClusterParameterGroupIdentifier
            this.tags = x.tags
            this.targetDbClusterParameterGroupDescription = x.targetDbClusterParameterGroupDescription
            this.targetDbClusterParameterGroupIdentifier = x.targetDbClusterParameterGroupIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.CopyDbClusterParameterGroupRequest = CopyDbClusterParameterGroupRequest(this)
    }
}
