// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about a cluster snapshot.
 */
public class DbClusterSnapshot private constructor(builder: Builder) {
    /**
     * Provides the list of Amazon EC2 Availability Zones that instances in the cluster snapshot can be restored in.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Specifies the time when the cluster was created, in Universal Coordinated Time (UTC).
     */
    public val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * Specifies the cluster identifier of the cluster that this cluster snapshot was created from.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) for the cluster snapshot.
     */
    public val dbClusterSnapshotArn: kotlin.String? = builder.dbClusterSnapshotArn
    /**
     * Specifies the identifier for the cluster snapshot.
     */
    public val dbClusterSnapshotIdentifier: kotlin.String? = builder.dbClusterSnapshotIdentifier
    /**
     * Specifies the name of the database engine.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * Provides the version of the database engine for this cluster snapshot.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * If `StorageEncrypted` is `true`, the KMS key identifier for the encrypted cluster snapshot.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Provides the master user name for the cluster snapshot.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * Specifies the percentage of the estimated data that has been transferred.
     */
    public val percentProgress: kotlin.Int = builder.percentProgress
    /**
     * Specifies the port that the cluster was listening on at the time of the snapshot.
     */
    public val port: kotlin.Int = builder.port
    /**
     * Provides the time when the snapshot was taken, in UTC.
     */
    public val snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotCreateTime
    /**
     * Provides the type of the cluster snapshot.
     */
    public val snapshotType: kotlin.String? = builder.snapshotType
    /**
     * If the cluster snapshot was copied from a source cluster snapshot, the ARN for the source cluster snapshot; otherwise, a null value.
     */
    public val sourceDbClusterSnapshotArn: kotlin.String? = builder.sourceDbClusterSnapshotArn
    /**
     * Specifies the status of this cluster snapshot.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Specifies whether the cluster snapshot is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean = builder.storageEncrypted
    /**
     * Provides the virtual private cloud (VPC) ID that is associated with the cluster snapshot.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DbClusterSnapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterSnapshot(")
        append("availabilityZones=$availabilityZones,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterSnapshotArn=$dbClusterSnapshotArn,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("masterUsername=$masterUsername,")
        append("percentProgress=$percentProgress,")
        append("port=$port,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotType=$snapshotType,")
        append("sourceDbClusterSnapshotArn=$sourceDbClusterSnapshotArn,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterSnapshotArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (percentProgress)
        result = 31 * result + (port)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterSnapshotArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterSnapshot

        if (availabilityZones != other.availabilityZones) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterSnapshotArn != other.dbClusterSnapshotArn) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (masterUsername != other.masterUsername) return false
        if (percentProgress != other.percentProgress) return false
        if (port != other.port) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotType != other.snapshotType) return false
        if (sourceDbClusterSnapshotArn != other.sourceDbClusterSnapshotArn) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DbClusterSnapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides the list of Amazon EC2 Availability Zones that instances in the cluster snapshot can be restored in.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Specifies the time when the cluster was created, in Universal Coordinated Time (UTC).
         */
        public var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the cluster identifier of the cluster that this cluster snapshot was created from.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the cluster snapshot.
         */
        public var dbClusterSnapshotArn: kotlin.String? = null
        /**
         * Specifies the identifier for the cluster snapshot.
         */
        public var dbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * Specifies the name of the database engine.
         */
        public var engine: kotlin.String? = null
        /**
         * Provides the version of the database engine for this cluster snapshot.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * If `StorageEncrypted` is `true`, the KMS key identifier for the encrypted cluster snapshot.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Provides the master user name for the cluster snapshot.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * Specifies the percentage of the estimated data that has been transferred.
         */
        public var percentProgress: kotlin.Int = 0
        /**
         * Specifies the port that the cluster was listening on at the time of the snapshot.
         */
        public var port: kotlin.Int = 0
        /**
         * Provides the time when the snapshot was taken, in UTC.
         */
        public var snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides the type of the cluster snapshot.
         */
        public var snapshotType: kotlin.String? = null
        /**
         * If the cluster snapshot was copied from a source cluster snapshot, the ARN for the source cluster snapshot; otherwise, a null value.
         */
        public var sourceDbClusterSnapshotArn: kotlin.String? = null
        /**
         * Specifies the status of this cluster snapshot.
         */
        public var status: kotlin.String? = null
        /**
         * Specifies whether the cluster snapshot is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean = false
        /**
         * Provides the virtual private cloud (VPC) ID that is associated with the cluster snapshot.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DbClusterSnapshot) : this() {
            this.availabilityZones = x.availabilityZones
            this.clusterCreateTime = x.clusterCreateTime
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterSnapshotArn = x.dbClusterSnapshotArn
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.masterUsername = x.masterUsername
            this.percentProgress = x.percentProgress
            this.port = x.port
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotType = x.snapshotType
            this.sourceDbClusterSnapshotArn = x.sourceDbClusterSnapshotArn
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DbClusterSnapshot = DbClusterSnapshot(this)
    }
}
