// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Contains the name and values of a manual cluster snapshot attribute.
 *
 * Manual cluster snapshot attributes are used to authorize other Amazon Web Services accounts to restore a manual cluster snapshot.
 */
public class DbClusterSnapshotAttribute private constructor(builder: Builder) {
    /**
     * The name of the manual cluster snapshot attribute.
     *
     * The attribute named `restore` refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual cluster snapshot.
     */
    public val attributeName: kotlin.String? = builder.attributeName
    /**
     * The values for the manual cluster snapshot attribute.
     *
     * If the `AttributeName` field is set to `restore`, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual cluster snapshot. If a value of `all` is in the list, then the manual cluster snapshot is public and available for any Amazon Web Services account to copy or restore.
     */
    public val attributeValues: List<String>? = builder.attributeValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DbClusterSnapshotAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterSnapshotAttribute(")
        append("attributeName=$attributeName,")
        append("attributeValues=$attributeValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (attributeValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterSnapshotAttribute

        if (attributeName != other.attributeName) return false
        if (attributeValues != other.attributeValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DbClusterSnapshotAttribute = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the manual cluster snapshot attribute.
         *
         * The attribute named `restore` refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual cluster snapshot.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The values for the manual cluster snapshot attribute.
         *
         * If the `AttributeName` field is set to `restore`, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual cluster snapshot. If a value of `all` is in the list, then the manual cluster snapshot is public and available for any Amazon Web Services account to copy or restore.
         */
        public var attributeValues: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DbClusterSnapshotAttribute) : this() {
            this.attributeName = x.attributeName
            this.attributeValues = x.attributeValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DbClusterSnapshotAttribute = DbClusterSnapshotAttribute(this)
    }
}
