// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DescribePendingMaintenanceActions.
 */
public class DescribePendingMaintenanceActionsRequest private constructor(builder: Builder) {
    /**
     * A filter that specifies one or more resources to return pending maintenance actions for.
     *
     * Supported filters:
     * + `db-cluster-id` - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only pending maintenance actions for the clusters identified by these ARNs.
     * + `db-instance-id` - Accepts instance identifiers and instance ARNs. The results list includes only pending maintenance actions for the DB instances identified by these ARNs.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The ARN of a resource to return pending maintenance actions for.
     */
    public val resourceIdentifier: kotlin.String? = builder.resourceIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DescribePendingMaintenanceActionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePendingMaintenanceActionsRequest(")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("resourceIdentifier=$resourceIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePendingMaintenanceActionsRequest

        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (resourceIdentifier != other.resourceIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DescribePendingMaintenanceActionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A filter that specifies one or more resources to return pending maintenance actions for.
         *
         * Supported filters:
         * + `db-cluster-id` - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only pending maintenance actions for the clusters identified by these ARNs.
         * + `db-instance-id` - Accepts instance identifiers and instance ARNs. The results list includes only pending maintenance actions for the DB instances identified by these ARNs.
         */
        public var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The ARN of a resource to return pending maintenance actions for.
         */
        public var resourceIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DescribePendingMaintenanceActionsRequest) : this() {
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.resourceIdentifier = x.resourceIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DescribePendingMaintenanceActionsRequest = DescribePendingMaintenanceActionsRequest(this)
    }
}
